/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.dbproxy;

import com.sdjxd.pms.platform.data.DataSource;
import com.sdjxd.pms.platform.dbproxy.JdaCommon;
import com.sdjxd.pms.platform.dbproxy.JdaException;
import com.sdjxd.pms.platform.dbproxy.PacketHeader;
import com.sdjxd.pms.platform.dbproxy.Parameter;
import com.sdjxd.pms.platform.dbproxy.ParameterBlob;
import com.sdjxd.pms.platform.dbproxy.ParameterString;
import com.sdjxd.pms.platform.dbproxy.RequestNcExecute;
import com.sdjxd.pms.platform.dbproxy.RequestNcFuncCall;
import com.sdjxd.pms.platform.dbproxy.RequestNcQuery;
import com.sdjxd.pms.platform.dbproxy.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.dbcp.ConnectionFactory;

public abstract class AbstractRequest {
    protected final PacketHeader requestHeader;

    public static final AbstractRequest getRequest(InputStream inputStream) throws JdaException {
        AbstractRequest object;
        PacketHeader header = AbstractRequest.createPacketHeader(inputStream);
        byte messageType = header.getMessageType();
        switch (messageType) {
            case 67: {
                object = new RequestNcQuery(header, inputStream);
                break;
            }
            case 68: {
                object = new RequestNcExecute(header, inputStream);
                break;
            }
            case 72: {
                object = new RequestNcFuncCall(header, inputStream);
                break;
            }
            default: {
                throw new JdaException(501, "\u7cfb\u7edf\u4e0d\u652f\u6301\u6b64\u8bf7\u6c42\u3002");
            }
        }
        return object;
    }

    public Response execute() throws JdaException {
        return this.execute("");
    }

    public abstract Response execute(String var1) throws JdaException;

    public byte getMessageType() {
        return this.requestHeader.getMessageType();
    }

    public byte getStringCharset() {
        return this.requestHeader.getStringCharset();
    }

    public String getStringCharsetString() {
        return this.requestHeader.getStringCharsetString();
    }

    protected AbstractRequest(PacketHeader header) {
        this.requestHeader = header;
    }

    protected void closePreparedStatement(PreparedStatement preparedStatement) throws JdaException {
        Connection conn = null;
        try {
            try {
                conn = preparedStatement.getConnection();
                preparedStatement.close();
            }
            catch (SQLException e) {
                throw this.createExecuteFailedException(e);
            }
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
        }
    }

    protected JdaException createExecuteFailedException(SQLException exception) {
        int errorCode = this.requestHeader.getMessageType() << 16 | 1;
        return new JdaException(errorCode, "\u6267\u884c\u5931\u8d25: " + exception.getMessage(), exception);
    }

    protected PreparedStatement getPreparedStatement(String m_dataSourceName, String sql2) throws JdaException {
        Connection conn = this.getConnection(m_dataSourceName);
        try {
            return conn.prepareStatement(sql2);
        }
        catch (SQLException e) {
            this.closeConnection(conn);
            throw this.createExecuteFailedException(e);
        }
    }

    protected static void read(InputStream inputStream, byte[] buffer, int length) throws JdaException {
        try {
            int len = 0;
            int total = 0;
            do {
                if ((len = inputStream.read(buffer, total, length - total)) > 0) continue;
                throw new JdaException(400, "\u4f20\u8f93\u6570\u636e\u4e0d\u5b8c\u6574");
            } while (length > (total += len));
        }
        catch (IOException e) {
            throw new JdaException(400, "\u4f20\u8f93\u6570\u636e\u4e0d\u5b8c\u6574: " + e.getMessage(), e);
        }
    }

    protected Parameter[] readSqlParameters(InputStream inputStream, int byteOrder, String stringCharset) throws JdaException {
        byte[] intBuffer = new byte[4];
        AbstractRequest.read(inputStream, intBuffer, 4);
        int paramCount = JdaCommon.bytesToInt(intBuffer, byteOrder);
        Parameter[] paramList = new Parameter[paramCount];
        int i = 0;
        while (i < paramCount) {
            AbstractRequest.read(inputStream, intBuffer, 4);
            AbstractRequest.read(inputStream, intBuffer, 4);
            int paramType = JdaCommon.bytesToInt(intBuffer, byteOrder);
            String paramName = this.readString(inputStream, byteOrder, stringCharset);
            Parameter param = Parameter.createParameter(paramName, paramType);
            switch (paramType) {
                case 22: {
                    ParameterBlob blob = (ParameterBlob)param;
                    AbstractRequest.read(inputStream, intBuffer, 4);
                    int blobLen = JdaCommon.bytesToInt(intBuffer, byteOrder);
                    byte[] buffer = new byte[blobLen];
                    AbstractRequest.read(inputStream, buffer, blobLen);
                    blob.setValue(buffer);
                    break;
                }
                case 20: {
                    ParameterString string = (ParameterString)param;
                    String value = this.readString(inputStream, byteOrder, stringCharset);
                    string.setValue(value);
                    break;
                }
                default: {
                    int errorCode = this.requestHeader.getMessageType() << 16 | 5;
                    throw new JdaException(errorCode, "\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b\u3002");
                }
            }
            paramList[i] = param;
            ++i;
        }
        return paramList;
    }

    protected String readString(InputStream inputStream, int byteOrder, String stringCharset) throws JdaException {
        String string;
        byte[] intBuffer = new byte[4];
        AbstractRequest.read(inputStream, intBuffer, 4);
        int stringLength = JdaCommon.bytesToInt(intBuffer, byteOrder);
        byte[] stringBuffer = new byte[stringLength];
        AbstractRequest.read(inputStream, stringBuffer, stringLength);
        try {
            string = new String(stringBuffer, 0, stringLength - 1, stringCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new JdaException(506, "\u4e0d\u652f\u6301\u7684\u7f16\u7801\u7c7b\u578b: " + e.getMessage(), e);
        }
        return string;
    }

    protected String[] readStrings(InputStream inputStream, int byteOrder, String stringCharset) throws JdaException {
        byte[] intBuffer = new byte[4];
        byte[] stringBuffer = new byte[1024];
        AbstractRequest.read(inputStream, intBuffer, 4);
        int sqlCount = JdaCommon.bytesToInt(intBuffer, byteOrder);
        String[] sqlList = new String[sqlCount];
        int i = 0;
        while (i < sqlCount) {
            String sql2;
            AbstractRequest.read(inputStream, intBuffer, 4);
            int stringLength = JdaCommon.bytesToInt(intBuffer, byteOrder);
            if (stringBuffer.length < stringLength) {
                stringBuffer = new byte[stringLength];
            }
            AbstractRequest.read(inputStream, stringBuffer, stringLength);
            try {
                sql2 = new String(stringBuffer, 0, stringLength - 1, stringCharset);
            }
            catch (UnsupportedEncodingException e) {
                throw new JdaException(506, "\u4e0d\u652f\u6301\u7684\u7f16\u7801\u7c7b\u578b: " + e.getMessage(), e);
            }
            sqlList[i] = sql2;
            ++i;
        }
        return sqlList;
    }

    protected void setSqlParameter(PreparedStatement preparedStatement, Parameter[] parameters) throws JdaException {
        try {
            int i = 0;
            while (i < parameters.length) {
                switch (parameters[i].getType()) {
                    case 20: {
                        preparedStatement.setString(i + 1, ((ParameterString)parameters[i]).getValue());
                        break;
                    }
                    case 22: {
                        preparedStatement.setObject(i + 1, ((ParameterBlob)parameters[i]).getValue());
                        break;
                    }
                    default: {
                        throw new JdaException(500, "RequestNcExecute.execute(): \u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b\u3002");
                    }
                }
                ++i;
            }
        }
        catch (SQLException e) {
            throw this.createExecuteFailedException(e);
        }
    }

    private void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.createExecuteFailedException(e);
        }
    }

    private static final PacketHeader createPacketHeader(InputStream input) throws JdaException {
        byte[] requestHead = new byte[48];
        AbstractRequest.read(input, requestHead, 48);
        return new PacketHeader(requestHead);
    }

    private Connection getConnection(String m_dataSourceName) throws JdaException {
        ConnectionFactory connFactory = this.getConnectionFactory(m_dataSourceName);
        try {
            return connFactory.createConnection();
        }
        catch (SQLException e) {
            throw this.createExecuteFailedException(e);
        }
    }

    private ConnectionFactory getConnectionFactory(String m_dataSourceName) throws JdaException {
        ConnectionFactory connFactory = DataSource.getDataSource(m_dataSourceName).getConnectionFactory();
        if (connFactory == null) {
            throw new JdaException(500, "\u65e0\u6cd5\u83b7\u5f97ConnectionFactory\u3002");
        }
        return connFactory;
    }
}

