/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.data;

import com.sdjxd.pms.platform.data.DbNull;
import com.sdjxd.pms.platform.data.DbmsSpecificImpl;
import com.sdjxd.pms.platform.tool.Convert;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import sun.misc.BASE64Decoder;

public abstract class DbTypeConverter {
    public static Object convertIntegerValue(Object p_value) {
        Long longValue = Long.valueOf(p_value.toString());
        if (longValue > Integer.MAX_VALUE) {
            return longValue;
        }
        return Integer.valueOf(p_value.toString());
    }

    public static Object toCommonType(Object p_value, int p_commonType) {
        Object value = p_value;
        if (value == null) {
            value = new DbNull();
        } else if (p_commonType == 4) {
            value = p_value instanceof Integer ? Integer.valueOf(p_value.toString()) : DbTypeConverter.convertIntegerValue(p_value);
        } else if (value instanceof Number) {
            BigDecimal bg;
            if (value instanceof BigDecimal && (bg = (BigDecimal)value).scale() <= 0) {
                value = DbTypeConverter.convertIntegerValue(bg.toString());
            }
            if (!(value instanceof Integer) && !(value instanceof Long)) {
                value = Double.valueOf(p_value.toString());
            }
        } else if (value instanceof Blob) {
            Blob blob = (Blob)value;
            try {
                value = blob.getBytes(2640522911210799105L, (int)blob.length());
            }
            catch (Exception e) {
                System.out.println("\u5c06Blob\u5b57\u6bb5\u503c\u4ee5byte[]\u683c\u5f0f\u8bfb\u51fa\u65f6\u53d1\u751f\u5f02\u5e38\u3002");
            }
        } else if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                value = clob.getSubString(2640522911210799105L, (int)clob.length());
            }
            catch (Exception e) {
                System.out.println("\u5c06Clob\u5b57\u6bb5\u503c\u4ee5String\u683c\u5f0f\u8bfb\u51fa\u65f6\u53d1\u751f\u5f02\u5e38\u3002");
            }
        } else {
            value = DbmsSpecificImpl.toCommonType(value, p_commonType);
        }
        if (value instanceof Number) {
            if (!(value instanceof Integer)) {
                value = Convert.toInteger((Number)p_value);
            }
            if (value.toString().equals(Integer.valueOf("-2147483648"))) {
                value = new DbNull();
            }
        }
        if (value instanceof Date && value.toString().equals("0001-01-01 00:00:00.000000")) {
            value = new DbNull();
        }
        return value;
    }

    public static Object toCommonType(String p_value, int p_dbType) {
        if (p_dbType == 2004) {
            try {
                return new BASE64Decoder().decodeBuffer(p_value);
            }
            catch (IOException e) {
                System.out.println("BLOB \u7c7b\u578b\u7684\u5b57\u6bb5\u5728 base64 \u89e3\u7801\u65f6\u53d1\u751f\u5f02\u5e38\u3002");
            }
        }
        Class c = String.class;
        if (p_dbType == 2 || p_dbType == 6 || p_dbType == 8) {
            c = Double.class;
        }
        if (p_dbType == 4) {
            c = Integer.class;
        }
        if (p_dbType == -5) {
            c = BigInteger.class;
        }
        if (p_dbType == 91) {
            c = java.sql.Date.class;
        }
        if (p_dbType == 92) {
            c = Time.class;
        }
        if (p_dbType == 93) {
            c = Timestamp.class;
        }
        return Convert.instanceSimpleClass(c, p_value);
    }

    public static Object validateDbNullToNull(Object p_value) {
        if (p_value == null || p_value instanceof DbNull) {
            return null;
        }
        return p_value;
    }

    public static String getDbTypeName(int p_dbType) {
        switch (p_dbType) {
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "NUMERIC";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "NUMERIC";
            }
            case 6: {
                return "NUMERIC";
            }
            case 8: {
                return "NUMERIC";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
        }
        return "UNKNOWN";
    }

    public static int getDbType(String p_dbTypeName) {
        if (p_dbTypeName.equalsIgnoreCase("CHAR")) {
            return 1;
        }
        if (p_dbTypeName.equalsIgnoreCase("VARCHAR")) {
            return 12;
        }
        if (p_dbTypeName.equalsIgnoreCase("INTEGER")) {
            return 4;
        }
        if (p_dbTypeName.equalsIgnoreCase("NUMERIC")) {
            return 2;
        }
        if (p_dbTypeName.equalsIgnoreCase("DATE")) {
            return 91;
        }
        if (p_dbTypeName.equalsIgnoreCase("TIME")) {
            return 92;
        }
        if (p_dbTypeName.equalsIgnoreCase("TIMESTAMP")) {
            return 93;
        }
        if (p_dbTypeName.equalsIgnoreCase("BLOB")) {
            return 2004;
        }
        if (p_dbTypeName.equalsIgnoreCase("CLOB")) {
            return 2005;
        }
        return -1;
    }
}

