/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.data;

import com.sdjxd.pms.platform.data.DataSource;
import com.sdjxd.pms.platform.tool.StringTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DbSession {
    private DataSource dataSource;
    private Connection conn;
    private Statement state;
    private PreparedStatement preState;
    private ResultSet resultSet;
    private static ThreadLocal session = new ThreadLocal();

    public DbSession(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        if (dataSource.getJndiDataSource() != null) {
            javax.sql.DataSource ds = dataSource.getJndiDataSource();
            this.conn = ds.getConnection();
        } else {
            this.conn = dataSource.getConnectionFactory().createConnection();
        }
        this.conn.setAutoCommit(false);
    }

    public Connection getConn() {
        return this.conn;
    }

    public PreparedStatement getPreState(String sql2) throws SQLException {
        if (this.preState == null) {
            this.conn.setAutoCommit(false);
        } else {
            this.preState.close();
        }
        this.preState = this.conn.prepareStatement(sql2);
        return this.preState;
    }

    public Statement getState() throws SQLException {
        if (this.state == null) {
            this.conn.setAutoCommit(false);
            this.state = this.conn.createStatement();
        }
        return this.state;
    }

    public void close() throws SQLException {
        this.conn.setAutoCommit(true);
        if (this.state != null) {
            this.state.close();
        }
        if (this.preState != null) {
            this.preState.close();
        }
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.conn.close();
    }

    public static DbSession getSession(String m_dataSourceName) {
        if (session.get() == null) {
            return null;
        }
        Map map = (Map)session.get();
        if (StringTool.isEmpty(m_dataSourceName)) {
            return (DbSession)map.get("defaultds");
        }
        return (DbSession)map.get(m_dataSourceName);
    }

    public static void setSession(String m_dataSourceName, DbSession dbSession) {
        Map map = session.get() == null ? new HashMap() : (Map)session.get();
        String dataSourceName = m_dataSourceName;
        if (StringTool.isEmpty(m_dataSourceName)) {
            dataSourceName = "defaultds";
        }
        if (dbSession == null) {
            map.remove(dataSourceName);
        } else {
            map.put(dataSourceName, dbSession);
        }
        session.set(map);
    }

    public static void closeSession(DbSession dbSession) throws SQLException {
        if (dbSession != null) {
            if (session.get() != null) {
                Map map = (Map)session.get();
                map.remove(dbSession.dataSource.getName());
            }
            dbSession.close();
        }
    }

    public static void closeAllSession() throws SQLException {
        if (session.get() != null) {
            Map map = (Map)session.get();
            Iterator it = map.entrySet().iterator();
            try {
                try {
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        DbSession dbSession = (DbSession)entry.getValue();
                        dbSession.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            finally {
                session.set(null);
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }
}

