/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.data;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DataSource;
import com.sdjxd.pms.platform.data.DataTable;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.data.DbType;
import com.sdjxd.pms.platform.data.ListMap;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.PublicTool;
import com.sdjxd.pms.platform.tool.StringTool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import oracle.sql.BLOB;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.log4j.Logger;

public class DbOper {
    private static final Logger log;
    private static DataSource defaultDataSource;

    static {
        defaultDataSource = null;
        log = Logger.getLogger(DbOper.class);
        Global.version = Global.OSType == 0 ? PublicTool.convertstring("version") : PublicTool.c0nvertstring("version");
        DbOper.getDbConfig();
    }

    public static final ConnectionFactory getConnectionFactory() {
        if (defaultDataSource == null) {
            DbOper.getDbConfig();
        }
        return defaultDataSource.getConnectionFactory();
    }

    private static void getDbConfig() {
        defaultDataSource = DataSource.getDataSource();
        if (Global.OSType == 0) {
            int confresult = PublicTool.verifyCode("code");
            if (confresult == 0) {
                log.error((Object)"\u5f53\u524d\u7248\u672c\u4e3a\u8bd5\u7528\u7248\uff0c\u8fd0\u884c\u4e00\u6bb5\u65f6\u95f4\u540e\u4f1a\u51fa\u73b0\u5f02\u5e38......");
                log.error((Object)"\u51fa\u73b0\u5f02\u5e38\u540e\u8bf7\u91cd\u542f\u5e94\u7528\u670d\u52a1\u5373\u53ef......");
                log.error((Object)"\u5982\u679c\u60a8\u611f\u89c9\u91cd\u542f\u670d\u52a1\u592a\u9ebb\u70e6\uff0c\u8bf7\u8054\u7cfb\u5382\u5bb6\u7533\u8bf7\u6388\u6743\u7801......");
            }
            if (confresult == 2) {
                log.error((Object)"\u8bd5\u7528\u671f\u9650\u5df2\u8fc7\uff0c\u8bf7\u8054\u7cfb\u5382\u5bb6\u7533\u8bf7\u5ef6\u957f\u8bd5\u7528\u671f......");
            }
        }
    }

    public static DbSession openDb() throws SQLException {
        return DbOper.openDb("defaultds");
    }

    public static DbSession openDb(String m_dataSourceName) throws SQLException {
        DbSession session = DbSession.getSession(m_dataSourceName);
        if (session == null) {
            DataSource dataSource = DataSource.getDataSource(m_dataSourceName);
            if (dataSource == null) {
                System.out.println(String.valueOf(m_dataSourceName) + "&&&&" + DataSource.dataSources + "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
            }
            session = new DbSession(dataSource);
            DbSession.setSession(m_dataSourceName, session);
            return session;
        }
        return null;
    }

    public static void closeDb(DbSession _session) throws SQLException {
        DbSession session = _session;
        if (session != null) {
            DbSession.closeSession(_session);
        }
    }

    public static void commitDb(DbSession _session) throws SQLException {
        DbSession session = _session;
        if (session != null) {
            Connection conn = session.getConn();
            conn.commit();
        }
    }

    public static void rollbackDb(DbSession _session) throws SQLException {
        DbSession session = _session;
        if (session != null) {
            Connection conn = session.getConn();
            conn.rollback();
        }
    }

    public static DbSession getDbSession() {
        return DbSession.getSession("defaultds");
    }

    public static DbSession getDbSession(String m_dataSourceName) {
        return DbSession.getSession(m_dataSourceName);
    }

    public static boolean sessionOpend() {
        return DbSession.getSession("defaultds") != null;
    }

    public static boolean sessionOpend(String m_dataSourceName) {
        return DbSession.getSession(m_dataSourceName) != null;
    }

    public static int executeNonQuery(String sql2) throws SQLException {
        return DbOper.executeNonQuery("defaultds", sql2);
    }

    public static int executeNonQuery(String m_dataSourceName, String sql2) throws SQLException {
        int num = 0;
        if (sql2 == null || sql2.length() == 0) {
            return num;
        }
        DbSession session = DbOper.openDb(m_dataSourceName);
        DbSession currSession = DbOper.getDbSession(m_dataSourceName);
        String r_sql = sql2;
        try {
            try {
                Statement state = currSession.getState();
                r_sql = DbOper.replaceKeyWords(m_dataSourceName, r_sql);
                num += state.executeUpdate(r_sql);
                DbOper.commitDb(session);
                log.info((Object)r_sql);
                if (Global.getContext() != null) {
                    String uuid = (String)Global.getContext().getSession("USERUUID");
                    log.info((Object)("\u7528\u6237\u4f1a\u8bddid\uff1a" + uuid + "\n\u6267\u884csql:" + r_sql));
                }
            }
            catch (SQLException exp) {
                DbOper.rollbackDb(session);
                if (exp.getMessage().indexOf("Connection reset") >= 0) {
                    currSession.getDataSource().clearConnectionFactory();
                }
                log.error((Object)(String.valueOf(exp.getMessage()) + r_sql));
                num = -1;
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        return num;
    }

    public static int executeNonQuery(String m_dataSourceName, String sql2, Object[] params) throws SQLException {
        int num = 0;
        if (sql2 == null || sql2.length() == 0) {
            return num;
        }
        DbSession session = DbOper.openDb(m_dataSourceName);
        DbSession currSession = DbOper.getDbSession(m_dataSourceName);
        String r_sql = sql2;
        try {
            try {
                r_sql = DbOper.replaceKeyWords(m_dataSourceName, r_sql);
                PreparedStatement state = currSession.getPreState(r_sql);
                int i = 0;
                while (i < params.length) {
                    if (params[i] != null) {
                        state.setObject(i + 1, params[i]);
                    } else {
                        state.setNull(i + 1, 12);
                    }
                    ++i;
                }
                num += state.executeUpdate();
                DbOper.commitDb(session);
                log.info((Object)r_sql);
                if (Global.getContext() != null) {
                    String uuid = (String)Global.getContext().getSession("USERUUID");
                    log.info((Object)("\u7528\u6237\u4f1a\u8bddid\uff1a" + uuid + "\n\u6267\u884csql:" + r_sql));
                }
            }
            catch (SQLException exp) {
                DbOper.rollbackDb(session);
                if (exp.getMessage().indexOf("Connection reset") >= 0) {
                    currSession.getDataSource().clearConnectionFactory();
                }
                log.error((Object)(String.valueOf(exp.getMessage()) + r_sql));
                num = -1;
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        return num;
    }

    public static int executeNonQuery(List sqlList) throws SQLException {
        return DbOper.executeNonQuery("defaultds", sqlList);
    }

    public static int executeNonQuery(String m_dataSourceName, List sqlList) throws SQLException {
        int num = 0;
        if (sqlList != null) {
            String[] sqlArray = new String[sqlList.size()];
            sqlList.toArray(sqlArray);
            num = DbOper.executeNonQuery(m_dataSourceName, sqlArray);
        }
        return num;
    }

    public static int executeNonQuery(String[] sqlList) throws SQLException {
        return DbOper.executeNonQuery("defaultds", sqlList);
    }

    /*
     * Unable to fully structure code
     */
    public static int executeNonQuery(String m_dataSourceName, String[] sqlList) throws SQLException {
        num = 0;
        len = sqlList.length;
        maxOfOnce = 1000;
        j = 0;
        while (j * maxOfOnce < len) {
            session = DbOper.openDb(m_dataSourceName);
            currSession = DbOper.getDbSession(m_dataSourceName);
            state = null;
            try {
                try {
                    block18: {
                        block21: {
                            block20: {
                                block19: {
                                    state = currSession.getState();
                                    i = 0;
                                    while (i < maxOfOnce && i + maxOfOnce * j < len) {
                                        r_sql = sqlList[i + j * maxOfOnce];
                                        r_sql = DbOper.replaceKeyWords(m_dataSourceName, r_sql);
                                        state.addBatch(r_sql);
                                        DbOper.log.info((Object)r_sql);
                                        ++i;
                                    }
                                    result = null;
                                    try {
                                        result = state.executeBatch();
                                        state.clearBatch();
                                        i = 0;
                                        while (i < result.length) {
                                            num += result[i];
                                            ++i;
                                        }
                                        break block18;
                                    }
                                    catch (BatchUpdateException exp) {
                                        DbOper.log.error((Object)exp);
                                        if (!DbType.SQL.equals(currSession.getDataSource().getDbType())) break block19;
                                        r = exp.getUpdateCounts();
                                        index = r.length - 1;
                                        ** while (index >= 0)
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        if (r[index] == -3) {
                                            System.out.print("\u6267\u884c\u6279\u5904\u7406\u4e2d\u7b2c");
                                            System.out.print(index);
                                            System.out.print("\u6761sql\u8bed\u53e5\u51fa\u9519\uff1a");
                                            System.out.println(sqlList[index + j * maxOfOnce]);
                                        }
                                        --index;
                                        continue;
lbl43:
                                        // 1 sources

                                        break block20;
                                    }
                                }
                                if (DbType.ORACLE.equals(currSession.getDataSource().getDbType())) {
                                    index = exp.getUpdateCounts().length;
                                    System.out.print("\u6267\u884c\u6279\u5904\u7406\u4e2d\u7b2c");
                                    System.out.print(index);
                                    System.out.print("\u6761sql\u8bed\u53e5\u51fa\u9519\uff1a");
                                    System.out.println(sqlList[index + j * maxOfOnce]);
                                } else if (!DbType.SQLITE.equals(currSession.getDataSource().getDbType())) {
                                    index = exp.getUpdateCounts().length;
                                    System.out.print("\u6267\u884c\u6279\u5904\u7406\u4e2d\u7b2c");
                                    System.out.print(index);
                                    System.out.print("\u6761sql\u8bed\u53e5\u51fa\u9519\uff1a");
                                    System.out.println(sqlList[index + j * maxOfOnce]);
                                }
                            }
                            state.clearBatch();
                            DbOper.rollbackDb(session);
                            throw exp;
                            catch (SQLException exp) {
                                DbOper.log.error((Object)exp);
                                if (exp.getMessage().indexOf("not allowed in batch commands") < 0 && exp.getMessage().indexOf("CREATE VIEW") < 0) break block21;
                                state.clearBatch();
                                DbOper.rollbackDb(session);
                                i = 0;
                                ** while (i < len)
                            }
lbl-1000:
                            // 1 sources

                            {
                                r_sql = sqlList[i];
                                r_sql = DbOper.replaceKeyWords(m_dataSourceName, r_sql);
                                DbOper.log.info((Object)r_sql);
                                state.executeUpdate(r_sql);
                                ++i;
                                continue;
lbl76:
                                // 1 sources

                                break block18;
                            }
                        }
                        throw exp;
                    }
                    DbOper.commitDb(session);
                }
                catch (SQLException exp) {
                    DbOper.log.error((Object)exp);
                    DbOper.rollbackDb(session);
                    if (exp.getMessage().indexOf("Connection reset") >= 0) {
                        currSession.getDataSource().clearConnectionFactory();
                    }
                    num = -1;
                    throw exp;
                }
            }
            finally {
                DbOper.closeDb(session);
            }
            ++j;
        }
        return num;
    }

    public static int executeNonQuery(String[][] sqlList) throws SQLException {
        int num = 0;
        int len = sqlList.length;
        int i = 0;
        while (i < len) {
            String r_sql = sqlList[i][0];
            String m_dataSourceName = sqlList[i][1];
            DbOper.executeNonQuery(m_dataSourceName, r_sql);
            ++i;
        }
        return num;
    }

    public static RowSet executeQuery(String sql2) throws SQLException {
        return DbOper.executeQuery("defaultds", sql2);
    }

    public static RowSet executeQuery(String m_dataSourceName, String sql2) throws SQLException {
        return DbOper.executeQuery(m_dataSourceName, sql2, true);
    }

    public static ResultSet resultSetQuery(String m_dataSourceName, String sql2) throws SQLException {
        return DbOper.resultSetQuery(m_dataSourceName, sql2, true);
    }

    public static ResultSet resultSetQuery(String m_dataSourceName, String sql2, boolean islog) throws SQLException {
        if (StringTool.isEmpty(sql2)) {
            throw new SQLException("sql\u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String str = DbOper.replaceKeyWords(m_dataSourceName, sql2);
        DbSession session = DbOper.openDb(m_dataSourceName);
        DbSession currSession = DbOper.getDbSession(m_dataSourceName);
        ResultSet resultSet = null;
        try {
            Statement state = currSession.getState();
            resultSet = state.executeQuery(str);
            DbOper.commitDb(session);
            log.info((Object)str);
        }
        catch (SQLException exp) {
            DbOper.rollbackDb(session);
            if (exp.getMessage().indexOf("Connection reset") >= 0 || exp.getMessage().indexOf("\u5173\u95ed\u7684\u8fde\u63a5") >= 0) {
                currSession.getDataSource().clearConnectionFactory();
            }
            if (islog) {
                log.error((Object)(String.valueOf(exp.getMessage()) + str));
            }
            throw exp;
        }
        return resultSet;
    }

    public static RowSet executeQuery(String m_dataSourceName, String sql2, boolean islog) throws SQLException {
        RowSet result;
        if (StringTool.isEmpty(sql2)) {
            throw new SQLException("sql\u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String str = DbOper.replaceKeyWords(m_dataSourceName, sql2);
        DbSession session = DbOper.openDb(m_dataSourceName);
        DbSession currSession = DbOper.getDbSession(m_dataSourceName);
        try {
            try {
                Statement state = currSession.getState();
                ResultSet resultSet = state.executeQuery(str);
                result = currSession.getDataSource().createCachedRowSet(resultSet);
                resultSet.close();
                DbOper.commitDb(session);
                log.info((Object)str);
            }
            catch (SQLException exp) {
                DbOper.rollbackDb(session);
                if (exp.getMessage().indexOf("Connection reset") >= 0 || exp.getMessage().indexOf("\u5173\u95ed\u7684\u8fde\u63a5") >= 0) {
                    currSession.getDataSource().clearConnectionFactory();
                }
                if (islog) {
                    log.error((Object)(String.valueOf(exp.getMessage()) + str));
                }
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        return result;
    }

    public static DbSession executeSession(String m_dataSourceName, String sql2) throws SQLException {
        if (StringTool.isEmpty(sql2)) {
            throw new SQLException("sql\u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String str = DbOper.replaceKeyWords(m_dataSourceName, sql2);
        DataSource dataSource = DataSource.getDataSource(m_dataSourceName);
        if (dataSource == null) {
            System.out.println(String.valueOf(m_dataSourceName) + "&&&&" + DataSource.dataSources + "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        }
        DbSession session = new DbSession(dataSource);
        try {
            Statement state = session.getState();
            session.setResultSet(state.executeQuery(str));
            log.info((Object)str);
        }
        catch (SQLException exp) {
            if (exp.getMessage().indexOf("Connection reset") >= 0 || exp.getMessage().indexOf("\u5173\u95ed\u7684\u8fde\u63a5") >= 0) {
                session.getDataSource().clearConnectionFactory();
            }
            log.error((Object)(String.valueOf(exp.getMessage()) + str));
            session.close();
            throw exp;
        }
        return session;
    }

    public static RowSet executeQuery(String m_dataSourceName, String sql2, Object[] params) throws SQLException {
        RowSet result;
        if (StringTool.isEmpty(sql2)) {
            throw new SQLException("sql\u67e5\u8be2\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String str = DbOper.replaceKeyWords(m_dataSourceName, sql2);
        DbSession session = DbOper.openDb(m_dataSourceName);
        DbSession currSession = DbOper.getDbSession(m_dataSourceName);
        try {
            try {
                PreparedStatement state = currSession.getPreState(str);
                int i = 0;
                while (i < params.length) {
                    state.setObject(1 + i, params[i]);
                    ++i;
                }
                ResultSet resultSet = state.executeQuery();
                result = currSession.getDataSource().createCachedRowSet(resultSet);
                resultSet.close();
                DbOper.commitDb(session);
                log.info((Object)str);
            }
            catch (SQLException exp) {
                DbOper.rollbackDb(session);
                if (exp.getMessage().indexOf("Connection reset") >= 0 || exp.getMessage().indexOf("\u5173\u95ed\u7684\u8fde\u63a5") >= 0) {
                    currSession.getDataSource().clearConnectionFactory();
                }
                exp.printStackTrace();
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        return result;
    }

    public static ArrayList executeList(String sql2) throws SQLException {
        return DbOper.executeList("defaultds", sql2);
    }

    public static ArrayList executeList(String m_dataSourceName, String sql2) throws SQLException {
        ArrayList<ListMap> list = new ArrayList<ListMap>(20);
        try {
            RowSet rs = DbOper.executeQuery(m_dataSourceName, sql2);
            if (rs != null) {
                int columnSize = rs.getMetaData().getColumnCount();
                while (rs.next()) {
                    ListMap data = new ListMap();
                    int i = 0;
                    while (i < columnSize) {
                        String columnType = rs.getMetaData().getColumnTypeName(i + 1);
                        if (columnType.equalsIgnoreCase("date")) {
                            Timestamp datetime = rs.getTimestamp(i + 1);
                            String temp = DateTool.formatDateTime(datetime);
                            data.put(rs.getMetaData().getColumnName(i + 1), temp);
                        } else if (columnType.equalsIgnoreCase("float")) {
                            BigDecimal num = rs.getBigDecimal(i + 1);
                            if (num != null && num.scale() < 0) {
                                num = num.setScale(0);
                            }
                            data.put(rs.getMetaData().getColumnName(i + 1), num == null ? null : num.toString());
                        } else if (columnType.equalsIgnoreCase("varchar")) {
                            data.put(rs.getMetaData().getColumnName(i + 1), rs.getString(i + 1));
                        } else if (columnType.equalsIgnoreCase("nvarchar")) {
                            data.put(rs.getMetaData().getColumnName(i + 1), rs.getString(i + 1));
                        } else if (columnType.equalsIgnoreCase("int")) {
                            data.put(rs.getMetaData().getColumnName(i + 1), rs.getString(i + 1));
                        } else if (columnType.equalsIgnoreCase("decimal")) {
                            data.put(rs.getMetaData().getColumnName(i + 1), rs.getString(i + 1));
                        } else if (columnType.equalsIgnoreCase("ntext")) {
                            Clob textClob = rs.getClob(i + 1);
                            String textStr = textClob == null || textClob.length() == 0L ? null : textClob.getSubString(1L, (int)textClob.length());
                            data.put(rs.getMetaData().getColumnName(i + 1), textStr);
                        } else {
                            Object obj = rs.getObject(i + 1);
                            data.put(rs.getMetaData().getColumnName(i + 1), obj == null ? null : obj.toString());
                        }
                        ++i;
                    }
                    list.add(data);
                }
            }
        }
        catch (SQLException exp) {
            log.error((Object)("executeList(String sql):" + exp.getMessage() + sql2));
            throw exp;
        }
        return list;
    }

    public static Map executeMap(String sql2) throws SQLException {
        return DbOper.executeMap("defaultds", sql2);
    }

    public static Map executeMap(String m_dataSourceName, String sql2) throws SQLException {
        ListMap data = new ListMap();
        try {
            RowSet rs = DbOper.executeQuery(m_dataSourceName, sql2);
            if (rs != null) {
                int columnSize = rs.getMetaData().getColumnCount();
                if (rs.next()) {
                    int i = 0;
                    while (i < columnSize) {
                        data.put(rs.getMetaData().getColumnName(i + 1), rs.getString(i + 1));
                        ++i;
                    }
                }
            }
        }
        catch (SQLException exp) {
            log.error((Object)("executeMap(String sql):" + exp.getMessage() + sql2));
            throw exp;
        }
        return data;
    }

    public static DataTable executeDataTable(String p_sql) {
        return DbOper.executeDataTable("defaultds", p_sql);
    }

    public static DataTable executeDataTable(String m_dataSourceName, String p_sql) {
        Statement sm = null;
        ResultSet rs = null;
        DataTable dt = null;
        try {
            DbSession session = DbOper.openDb(m_dataSourceName);
            DbSession currSession = DbOper.getDbSession(m_dataSourceName);
            try {
                try {
                    sm = currSession.getState();
                    rs = sm.executeQuery(p_sql);
                    dt = new DataTable(rs);
                    rs.close();
                    DbOper.commitDb(session);
                }
                catch (SQLException exp) {
                    DbOper.rollbackDb(session);
                    log.error((Object)exp);
                    DbOper.closeDb(session);
                }
            }
            finally {
                DbOper.closeDb(session);
            }
        }
        catch (SQLException exp) {
            log.error((Object)exp);
            dt = null;
        }
        return dt;
    }

    public static Object executeQueryObject(String sql2) throws SQLException {
        return DbOper.executeQueryObject("defaultds", sql2);
    }

    public static Object executeQueryObject(String m_dataSourceName, String sql2) throws SQLException {
        Object o = null;
        RowSet rs = DbOper.executeQuery(m_dataSourceName, sql2);
        if (rs.next()) {
            o = rs.getObject(1);
        }
        return o;
    }

    public static RowSet getRowSet(ResultSet resultSet) throws SQLException {
        return DbOper.getRowSet("defaultds", resultSet);
    }

    public static RowSet getRowSet(String m_dataSourceName, ResultSet resultSet) throws SQLException {
        RowSet result = DataSource.getDataSource(m_dataSourceName).createCachedRowSet(resultSet);
        resultSet.close();
        return result;
    }

    public static boolean updatePicture(String sql2, InputStream picture, long len) throws SQLException {
        return DbOper.updatePicture("defaultds", sql2, picture, len);
    }

    public static boolean updatePicture(String m_dataSourceName, String sql2, InputStream picture, long len) throws SQLException {
        boolean rValue = false;
        String str = "";
        str = DbOper.replaceKeyWords(m_dataSourceName, sql2);
        DbSession session = DbOper.openDb(m_dataSourceName);
        DbSession curSession = DbOper.getDbSession(m_dataSourceName);
        if (DbType.ORACLE.equals(curSession.getDataSource().getDbType()) || DbType.DB2.equals(curSession.getDataSource().getDbType())) {
            try {
                try {
                    PreparedStatement state = curSession.getPreState(str);
                    state.setBinaryStream(1, picture, (int)len);
                    state.executeUpdate();
                    rValue = true;
                    log.info((Object)str);
                    DbOper.commitDb(session);
                }
                catch (Exception exp) {
                    DbOper.rollbackDb(session);
                    log.error((Object)exp);
                    DbOper.closeDb(session);
                }
            }
            finally {
                DbOper.closeDb(session);
            }
        } else {
            try {
                try {
                    PreparedStatement state = curSession.getPreState(str);
                    state.setBinaryStream(1, picture, (int)len);
                    state.executeUpdate();
                    rValue = true;
                    log.info((Object)str);
                    DbOper.commitDb(session);
                }
                catch (Exception exp) {
                    DbOper.rollbackDb(session);
                    log.error((Object)exp);
                    exp.printStackTrace();
                    DbOper.closeDb(session);
                }
            }
            finally {
                DbOper.closeDb(session);
            }
        }
        return rValue;
    }

    public static byte[] getPictureData(String sql2) throws SQLException {
        return DbOper.getPictureData("defaultds", sql2);
    }

    public static byte[] getPictureData(String m_dataSourceName, String sql2) throws SQLException {
        byte[] result = null;
        String str = "";
        DbSession session = DbOper.openDb(m_dataSourceName);
        DbSession curSession = DbOper.getDbSession(m_dataSourceName);
        str = DbOper.replaceKeyWords(m_dataSourceName, sql2);
        PreparedStatement state = curSession.getPreState(str);
        ResultSet rs = state.executeQuery();
        BLOB blob = null;
        if (rs.next()) {
            if (DbType.ORACLE.equals(curSession.getDataSource().getDbType())) {
                blob = (BLOB)rs.getBlob(1);
                result = blob.getBytes(1L, Integer.parseInt(Long.toString(blob.length())));
            } else if (DbType.DB2.equals(curSession.getDataSource().getDbType())) {
                Blob dbBlob = rs.getBlob(1);
                InputStream in = dbBlob.getBinaryStream();
                ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
                byte[] buff = new byte[100];
                int rc = 0;
                try {
                    while ((rc = in.read(buff, 0, 100)) > 0) {
                        swapStream.write(buff, 0, rc);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                result = swapStream.toByteArray();
            } else {
                InputStream in = null;
                in = rs.getBinaryStream(1);
                ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
                byte[] buff = new byte[100];
                int rc = 0;
                try {
                    while ((rc = in.read(buff, 0, 100)) > 0) {
                        swapStream.write(buff, 0, rc);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                result = swapStream.toByteArray();
            }
        }
        rs.close();
        DbOper.closeDb(session);
        return result;
    }

    private static String replaceKeyWords(String m_dataSourceName, String sql2) {
        DataSource dataSource = DataSource.getDataSource(m_dataSourceName);
        String[][] dbUsers = dataSource.getDataSourceUser();
        int size = dbUsers.length;
        int[] keywordsLen = new int[size];
        int[] replacesLen = new int[size];
        int[] keyAndRepSubLen = new int[size];
        int i = 0;
        while (i < size) {
            if (dbUsers[i][0] != null) {
                keywordsLen[i] = dbUsers[i][0].length();
                replacesLen[i] = dbUsers[i][1].length();
                keyAndRepSubLen[i] = replacesLen[i] - keywordsLen[i];
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer(sql2);
        int len = sb.length();
        boolean quote = false;
        int i2 = 0;
        while (i2 < len) {
            quote = sb.charAt(i2) == '\'' ^ quote;
            if (!quote) {
                int j = 0;
                while (j < size) {
                    if (i2 < len - keywordsLen[j] && dbUsers[j][0] != null && sb.substring(i2, i2 + keywordsLen[j]).equals(dbUsers[j][0])) {
                        sb.replace(i2, i2 + keywordsLen[j], dbUsers[j][1]);
                        len += keyAndRepSubLen[j];
                        i2 += replacesLen[j] - 1;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return sb.toString();
    }

    public static String getSchema() {
        return defaultDataSource.getSchema();
    }

    public static String getSchemaFile() {
        String schemaFile = defaultDataSource.getSchemaFile();
        if (StringTool.isEmpty(schemaFile)) {
            return DbOper.getSchema();
        }
        return schemaFile;
    }

    public static DbType getDbType() {
        return defaultDataSource.getDbType();
    }

    public static int getDbTypeId() {
        return defaultDataSource.getDbTypeId();
    }

    public static ArrayList resultSetToArray(ResultSet rst) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ResultSetMetaData rsmd = rst.getMetaData();
        int columnSize = rsmd.getColumnCount();
        while (rst.next()) {
            Object[] columns = new Object[columnSize - 1];
            int i = 0;
            while (i < columnSize) {
                Object o = rst.getObject(i + 1);
                columns[i] = o != null ? o : "";
                ++i;
            }
            rows.add(columns);
        }
        return rows;
    }

    public static boolean isExist(String tableName) {
        return DbOper.isExist("defaultds", "[S].", tableName);
    }

    public static boolean isExist(String m_dataSourceName, String m_dataUserName, String tableName) {
        boolean hasText = true;
        StringBuffer sql2 = new StringBuffer(128);
        sql2.append("SELECT 1 FROM ");
        sql2.append(m_dataUserName == null ? "[S]." : m_dataUserName);
        sql2.append(tableName);
        sql2.append(" WHERE 1=2");
        try {
            DbOper.executeQuery(m_dataSourceName, sql2.toString(), false);
        }
        catch (SQLException e) {
            hasText = false;
        }
        return hasText;
    }

    public static String toDb(String sqlValue) {
        return StringTool.replace(sqlValue, "'", "''");
    }

    public static String toInSql(String[] array) {
        if (array == null || array.length <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(1024);
        int i = 0;
        while (i < array.length) {
            sb.append(",'");
            sb.append(DbOper.toDb(array[i]));
            sb.append("'");
            ++i;
        }
        return sb.substring(1);
    }

    public static String toInSql(List array) {
        if (array == null) {
            return "";
        }
        int len = array.size();
        if (len <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(1024);
        int i = 0;
        while (i < len) {
            sb.append(",'");
            sb.append(DbOper.toDb((String)array.get(i)));
            sb.append("'");
            ++i;
        }
        return sb.substring(1);
    }

    public static String toIn1000Sql(String columnName, String[] array) {
        StringBuffer sb = new StringBuffer(1024);
        if (array == null) {
            sb.append(columnName);
            sb.append(" IS NULL");
        } else {
            int len = array.length;
            if (len <= 0) {
                sb.append(columnName);
                sb.append(" IS NULL");
            } else {
                sb.append("(");
                int j = 0;
                while (1000 * j < len) {
                    sb.append(columnName);
                    sb.append(" IN (");
                    int i = j * 1000;
                    while (i < len && i < j * 1000 + 1000) {
                        sb.append("'");
                        sb.append(DbOper.toDb(array[i]));
                        sb.append("',");
                        ++i;
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(") OR ");
                    ++j;
                }
                sb.setLength(sb.length() - 4);
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public static String toIn1000Sql(String columnName, List array) {
        String[] a;
        if (array != null) {
            a = new String[array.size()];
            array.toArray(a);
        } else {
            a = null;
        }
        return DbOper.toIn1000Sql(columnName, a);
    }
}

