/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.data;

import com.sdjxd.pms.platform.data.DataColumn;
import com.sdjxd.pms.platform.data.DataColumnCollection;
import com.sdjxd.pms.platform.data.DataRow;
import com.sdjxd.pms.platform.data.DataRowCollection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;

public class DataTable {
    public static final String ELEMENT_DATATABLE = "DataTable";
    public static final String ELEMENT_COLUMNS = "Columns";
    public static final String ELEMENT_ROWS = "Rows";
    public static final String ATTR_TABLENAME = "tableName";
    private String tableName;
    private DataColumnCollection columns;
    private ArrayList columnIndexArray;
    private DataRowCollection rows;

    public DataTable() {
        this("NewDataTable");
    }

    public DataTable(String p_tableName) {
        this.tableName = p_tableName;
        this.columns = new DataColumnCollection();
        this.columnIndexArray = new ArrayList();
        this.rows = new DataRowCollection();
    }

    public DataTable(ResultSet p_resultSet) {
        this();
        int cols = 0;
        ResultSetMetaData rsmd = null;
        try {
            rsmd = p_resultSet.getMetaData();
            cols = rsmd.getColumnCount();
            int i = 1;
            while (i <= cols) {
                String colName = rsmd.getColumnName(i);
                DataColumn column = this.appendColumn(colName);
                column.columnType = rsmd.getColumnType(i);
                column.precision = rsmd.getPrecision(i);
                column.scale = rsmd.getScale(i);
                if (column.columnType == 2 && column.precision > 0 && column.scale == 0) {
                    column.columnType = 4;
                }
                column.nullable = rsmd.isNullable(i) == 1;
                column.caseSensitive = rsmd.isCaseSensitive(i);
                ++i;
            }
        }
        catch (Exception i) {}
        try {
            while (p_resultSet.next()) {
                DataRow row = this.appendRow();
                int i = 1;
                while (i <= cols) {
                    if (p_resultSet.getObject(i) instanceof Date) {
                        row.setValue(i - 1, (Object)p_resultSet.getTimestamp(i), false);
                    } else {
                        row.setValue(i - 1, p_resultSet.getObject(i), false);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String p_tableName) {
        this.tableName = p_tableName;
    }

    public DataColumnCollection getColumns() {
        return this.columns;
    }

    public int getColumnIndex(String p_columnName) {
        return ((DataColumn)this.columns.get(p_columnName)).getIndexInColList();
    }

    public DataColumn getColumn(String p_columnName) {
        DataColumn col = (DataColumn)this.columns.get(p_columnName.toUpperCase());
        return col;
    }

    public DataColumn getColumn(int p_columnIndex) {
        return (DataColumn)this.columnIndexArray.get(p_columnIndex);
    }

    public String getColumnName(int p_columnIndex) {
        return ((DataColumn)this.columnIndexArray.get(p_columnIndex)).getColumnName();
    }

    public boolean containsColumn(String p_columnName) {
        return this.columns.containsKey(p_columnName.toUpperCase());
    }

    public DataColumn appendColumn(String p_columnName) {
        String upname = p_columnName.toUpperCase();
        DataColumn column = null;
        if (!this.containsColumn(upname)) {
            column = new DataColumn(this, upname);
            this.columns.put(upname, column);
            this.columnIndexArray.add(column);
            column.setIndexInColList(this.columnIndexArray.size() - 1);
            int i = 0;
            while (i < this.rows.size()) {
                ((DataRow)this.rows.get(i)).addNullValue();
                ++i;
            }
        } else {
            column = this.getColumn(upname);
        }
        return column;
    }

    public DataColumn appendColumn(DataColumn p_dataColumn) {
        String upname = p_dataColumn.getColumnName().toUpperCase();
        DataColumn column = null;
        if (!this.containsColumn(upname)) {
            column = p_dataColumn;
            this.columns.put(upname, column);
            this.columnIndexArray.add(column);
            column.setIndexInColList(this.columnIndexArray.size() - 1);
            int i = 0;
            while (i < this.rows.size()) {
                ((DataRow)this.rows.get(i)).addNullValue();
                ++i;
            }
        } else {
            column = this.getColumn(upname);
        }
        return column;
    }

    public void removeColumn(String p_columnName) {
        String upname = p_columnName.toUpperCase();
        int colIndex = ((DataColumn)this.columns.get(upname)).getIndexInColList();
        int i = 0;
        while (i < this.rows.size()) {
            ((DataRow)this.rows.get(i)).removeData(colIndex);
            ++i;
        }
        this.columnIndexArray.remove(colIndex);
        this.columns.remove(upname);
        i = 0;
        while (i < this.columnIndexArray.size()) {
            ((DataColumn)this.columnIndexArray.get(i)).setIndexInColList(i);
            ++i;
        }
    }

    public void clearColumn() {
        this.columns.clear();
        this.columnIndexArray.clear();
    }

    public DataRowCollection getRows() {
        return this.rows;
    }

    public DataRow getRow(int p_index) {
        return (DataRow)this.rows.get(p_index);
    }

    public DataRow appendRow() {
        DataRow row = new DataRow(this);
        for (DataColumn column : this.getColumns().values()) {
            if (column.getDefaultValue() == null) continue;
            row.setValue(column.getIndexInColList(), column.getDefaultValue(), true);
        }
        this.rows.add(row);
        return row;
    }

    public void removeRow(int p_rowIndex) {
        this.rows.remove(p_rowIndex);
    }

    public void clearRow() {
        this.rows.clear();
    }

    public void clear() {
        this.clearColumn();
        this.clearRow();
    }

    public DataTable cloneTableStructure() {
        DataTable newTable = new DataTable();
        int i = 0;
        while (i < this.columnIndexArray.size()) {
            DataColumn col = (DataColumn)this.columnIndexArray.get(i);
            DataColumn dc = newTable.appendColumn(col.getColumnName());
            dc.caption = col.caption;
            dc.caseSensitive = col.caseSensitive;
            dc.columnType = col.columnType;
            dc.defaultValue = col.defaultValue;
            dc.expression = col.expression;
            dc.nullable = col.nullable;
            dc.precision = col.precision;
            dc.primaryKey = col.primaryKey;
            dc.readOnly = col.readOnly;
            dc.scale = col.scale;
            dc.getExtendedProperties().putAll(col.getExtendedProperties());
            ++i;
        }
        return newTable;
    }
}

