/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.data;

import com.sdjxd.pms.platform.base.MyEncodedProperties;
import com.sdjxd.pms.platform.data.CachedRowSetCreator;
import com.sdjxd.pms.platform.data.DbType;
import com.sdjxd.pms.platform.data.DefaultCachedRowSetCreator;
import com.sdjxd.pms.platform.data.OracleCachedRowSetCreator;
import com.sdjxd.pms.platform.tool.StringTool;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.RowSet;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.log4j.Logger;

public class DataSource {
    private ConnectionFactory connectionFactory;
    private BasicDataSource basicDataSource;
    private String jndiName;
    private javax.sql.DataSource jndiDataSource;
    private String name;
    private String showName;
    private String[][] users = new String[20][3];
    private DbType dbType = null;
    private String schema = "";
    private String schemaFile;
    private CachedRowSetCreator rowSetCreator;
    public static Map dataSources = new ListOrderedMap();
    private static final Logger log = Logger.getLogger(DataSource.class);
    static final Properties dbProps = DataSource.loadProperties("/jdbc.properties");
    public static final String DEFAULTDATASOURCE = "defaultds";
    public static final String DEFAULTDATAUSER = "[S].";
    private static final int MAXUSERCOUNT = 20;

    static {
        DataSource.initDataSources();
    }

    private static Properties loadProperties(String location) {
        MyEncodedProperties properties = new MyEncodedProperties();
        properties.load(location);
        return properties;
    }

    private DataSource() {
    }

    public static DataSource getDataSource() {
        return DataSource.getDataSource(DEFAULTDATASOURCE);
    }

    public static DataSource getDataSource(String m_dataSourceName) {
        String dataSourceName = StringTool.isEmpty(m_dataSourceName) ? DEFAULTDATASOURCE : m_dataSourceName;
        DataSource dataSource = (DataSource)dataSources.get(dataSourceName);
        return dataSource;
    }

    public void clearConnectionFactory() {
        this.connectionFactory = new DataSourceConnectionFactory((javax.sql.DataSource)this.basicDataSource);
    }

    public RowSet createCachedRowSet(ResultSet resultSet) throws SQLException {
        return this.getRowSetCreator().createCachedRowSet(resultSet);
    }

    private CachedRowSetCreator getRowSetCreator() {
        if (this.rowSetCreator == null) {
            this.rowSetCreator = DbType.ORACLE == this.dbType ? new OracleCachedRowSetCreator() : new DefaultCachedRowSetCreator();
        }
        return this.rowSetCreator;
    }

    private static void initDataSources() {
        Iterator<Object> it = dbProps.keySet().iterator();
        dataSources.put(DEFAULTDATASOURCE, DataSource.getFactoryConfig(DEFAULTDATASOURCE));
        while (it.hasNext()) {
            String dataSourceName = (String)it.next();
            if (dataSourceName.startsWith("user") || !dataSourceName.matches("\\w+\\.name")) continue;
            dataSourceName = dataSourceName.substring(0, dataSourceName.length() - 5);
            dataSources.put(dataSourceName, DataSource.getFactoryConfig(dataSourceName));
        }
    }

    public static Object[][] getDataSources() {
        Object[][] array = new Object[dataSources.size()][4];
        int i = 0;
        for (Map.Entry entry : dataSources.entrySet()) {
            String dataSourceName = (String)entry.getKey();
            array[i][0] = dataSourceName;
            DataSource dataSource = (DataSource)entry.getValue();
            array[i][1] = dataSource.getShowName();
            array[i][2] = String.valueOf(dataSource.getDbTypeId());
            array[i++][3] = dataSource.getDataSourceUser();
        }
        return array;
    }

    public String[][] getDataSourceUser() {
        return this.users;
    }

    private static DataSource getFactoryConfig(String m_dataSourceName) {
        String dataSourceName;
        DataSource dataSource = new DataSource();
        if (m_dataSourceName == null || DEFAULTDATASOURCE.equals(m_dataSourceName)) {
            dataSource.name = DEFAULTDATASOURCE;
            dataSourceName = "";
            dataSource.showName = dbProps.getProperty(String.valueOf(dataSourceName) + "name");
            if (StringTool.isEmpty(dataSource.showName)) {
                dataSource.showName = "\u9ed8\u8ba4\u6570\u636e\u6e90";
            }
        } else {
            dataSource.name = m_dataSourceName;
            dataSourceName = String.valueOf(m_dataSourceName) + ".";
            dataSource.showName = dbProps.getProperty(String.valueOf(dataSourceName) + "name");
        }
        dataSource.setDbType(dbProps.getProperty(String.valueOf(dataSourceName) + "db.type"));
        dataSource.setSchema(dbProps.getProperty(String.valueOf(dataSourceName) + "db.schema"));
        dataSource.setSchemaFile(dbProps.getProperty(String.valueOf(dataSourceName) + "db.fileSchema"));
        String jndiName = dbProps.getProperty(String.valueOf(dataSourceName) + "jdbc.jndiName");
        if (!StringTool.isEmpty(jndiName)) {
            dataSource.setJndiName(jndiName);
            try {
                InitialContext ic = new InitialContext();
                javax.sql.DataSource jndiDataSource = (javax.sql.DataSource)ic.lookup("java:comp/env/" + jndiName);
                dataSource.setJndiDataSource(jndiDataSource);
            }
            catch (NamingException e) {
                log.error((Object)("\u65e0\u6cd5\u83b7\u53d6jndi\uff1a" + jndiName + ",\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e"));
                e.printStackTrace();
            }
        } else {
            dataSource.basicDataSource = new BasicDataSource();
            String driveClassName = dbProps.getProperty(String.valueOf(dataSourceName) + "jdbc.driverClassName");
            String url = dbProps.getProperty(String.valueOf(dataSourceName) + "jdbc.url");
            String username = dbProps.getProperty(String.valueOf(dataSourceName) + "jdbc.username");
            String password = dbProps.getProperty(String.valueOf(dataSourceName) + "jdbc.password");
            String initialSize = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.initialSize");
            String minIdle = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.minIdle");
            String maxIdle = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.maxIdle");
            String maxWait = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.maxWait");
            String maxActive = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.maxActive");
            String testWhileIdle = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.testWhileIdle");
            String minEvictableIdleTime = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.minEvictableIdleTime");
            String timeBetweenEvictionRuns = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.timeBetweenEvictionRuns");
            String numTestsPerEvictionRun = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.numTestsPerEvictionRun");
            String validationQuery = dbProps.getProperty(String.valueOf(dataSourceName) + "dataSource.validationQuery");
            dataSource.basicDataSource.setDriverClassName(driveClassName);
            dataSource.basicDataSource.setUrl(url);
            if (!StringTool.isEmpty(username)) {
                dataSource.basicDataSource.setUsername(username);
            }
            if (!StringTool.isEmpty(username)) {
                dataSource.basicDataSource.setPassword(password);
            }
            if (initialSize != null) {
                dataSource.basicDataSource.setInitialSize(Integer.parseInt(initialSize));
            }
            if (minIdle != null) {
                dataSource.basicDataSource.setMinIdle(Integer.parseInt(minIdle));
            }
            if (maxIdle != null) {
                dataSource.basicDataSource.setMaxIdle(Integer.parseInt(maxIdle));
            }
            if (maxWait != null) {
                dataSource.basicDataSource.setMaxWait(Long.parseLong(maxWait));
            }
            if (maxActive != null && !maxActive.trim().equals("0")) {
                dataSource.basicDataSource.setMaxActive(Integer.parseInt(maxActive));
            }
            if (testWhileIdle != null) {
                if ("true".equalsIgnoreCase(testWhileIdle)) {
                    dataSource.basicDataSource.setTestWhileIdle(true);
                    dataSource.basicDataSource.setTimeBetweenEvictionRunsMillis(1800000L);
                    if (DbType.ORACLE.getId() == dataSource.dbType.getId()) {
                        dataSource.basicDataSource.setValidationQuery("select 1 from dual");
                    } else if (DbType.SQL.getId() == dataSource.dbType.getId()) {
                        dataSource.basicDataSource.setValidationQuery("select top 1 1 from sysfiles");
                    } else if (DbType.DM.getId() == dataSource.dbType.getId()) {
                        dataSource.basicDataSource.setValidationQuery("select * from SYSDBA.SYSDUAL");
                    } else if (DbType.MYSQL.getId() == dataSource.dbType.getId()) {
                        dataSource.basicDataSource.setValidationQuery("select  1");
                    }
                } else {
                    dataSource.basicDataSource.setTestWhileIdle(false);
                }
            }
            if (minEvictableIdleTime != null) {
                dataSource.basicDataSource.setMinEvictableIdleTimeMillis(Long.parseLong(minEvictableIdleTime) * 1000L);
            }
            if (numTestsPerEvictionRun != null) {
                dataSource.basicDataSource.setNumTestsPerEvictionRun(Integer.parseInt(numTestsPerEvictionRun));
            }
            if (timeBetweenEvictionRuns != null) {
                dataSource.basicDataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(timeBetweenEvictionRuns) * 1000L);
            }
            if (validationQuery != null) {
                dataSource.basicDataSource.setValidationQuery(validationQuery);
            }
            dataSource.connectionFactory = new DataSourceConnectionFactory((javax.sql.DataSource)dataSource.basicDataSource);
        }
        dataSource.users[0][0] = DEFAULTDATAUSER;
        dataSource.users[0][1] = dataSource.getSchema();
        dataSource.users[0][2] = "\u767b\u9646\u7528\u6237";
        dataSource.users[1][0] = "[SFILE].";
        dataSource.users[1][2] = "\u6587\u4ef6\u5b58\u50a8\u7528\u6237";
        dataSource.users[1][1] = !StringTool.isEmpty(dataSource.getSchemaFile()) ? dataSource.getSchemaFile() : dataSource.getSchema();
        int i = 2;
        while (i < 20) {
            String tempUserId = "user" + i;
            String tempUserDbName = dbProps.getProperty(String.valueOf(dataSourceName) + tempUserId);
            if (!StringTool.isEmpty(tempUserDbName)) {
                String tempUserName = dbProps.getProperty(String.valueOf(dataSourceName) + tempUserId + ".name");
                if (StringTool.isEmpty(tempUserName)) {
                    tempUserName = tempUserDbName;
                }
                dataSource.users[i][0] = "[S" + i + "].";
                dataSource.users[i][1] = tempUserDbName;
                dataSource.users[i][2] = tempUserName;
            }
            ++i;
        }
        return dataSource;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSchemaFile() {
        if (StringTool.isEmpty(this.schemaFile)) {
            return this.getSchema();
        }
        return this.schemaFile;
    }

    private void setSchema(String schema) {
        this.schema = schema;
    }

    private void setSchemaFile(String schemaFile) {
        this.schemaFile = schemaFile;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    private void setDbType(String dbType) {
        this.dbType = DbType.getDbType(dbType);
    }

    public int getDbTypeId() {
        return this.dbType.getId();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public String getName() {
        return this.name;
    }

    public String getShowName() {
        return this.showName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public javax.sql.DataSource getJndiDataSource() {
        return this.jndiDataSource;
    }

    public void setJndiDataSource(javax.sql.DataSource jndiDataSource) {
        this.jndiDataSource = jndiDataSource;
    }
}

