/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.data;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.ListMap;
import com.sdjxd.pms.platform.data.sql.DataSetSql;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.util.ArrayList;

public class DataSet {
    private ListMap columns = new ListMap();
    private ListMap tableNames = new ListMap();
    private ListMap outerTableNames = new ListMap();
    private ListMap innerTableNames = new ListMap();
    private ArrayList filters = new ArrayList();
    private ListMap orders = new ListMap();
    private ArrayList havings = new ArrayList();
    private String dataSourceName;
    private String pkCol;

    public DataSetSql getSqlHelper(String m_dataSourceName) {
        return (DataSetSql)BeanFactory.getSqlInstance(DataSet.class, "DataSetSql", m_dataSourceName);
    }

    public String getSql(String m_dataSourceName, int start, int dataLen) throws Exception {
        return this.getSqlHelper(m_dataSourceName).getDataSetSql(this.tableNames, this.columns, this.filters, this.orders, start, dataLen, this.pkCol);
    }

    public ArrayList exec(int start, int dataLen) throws Exception {
        if (StringTool.isEmpty(this.dataSourceName)) {
            this.dataSourceName = "defaultds";
        }
        return DbOper.executeList(this.dataSourceName, this.getSql(this.dataSourceName, start, dataLen));
    }

    public static ArrayList exec(DataSet dataSet, int start, int dataLen) throws Exception {
        return dataSet.exec(start, dataLen);
    }

    public static ArrayList exec(String m_dataSourceName, String sql2) throws Exception {
        return DbOper.executeList(m_dataSourceName, sql2);
    }

    public void addColumn(String columnName) {
        this.addColumn(columnName, null);
    }

    public void addColumn(String columnName, String asname) {
        if (!StringTool.isEmpty(columnName)) {
            if (!StringTool.isEmpty(asname) && !columnName.equals(asname)) {
                this.columns.put(columnName, asname);
            } else {
                this.columns.put(columnName, null);
            }
        }
    }

    public void addFilter(String filterExpression) {
        if (StringTool.isEmpty(filterExpression)) {
            this.filters.add(filterExpression);
        }
    }

    public void addHaving(String havingExpression) {
        if (StringTool.isEmpty(havingExpression)) {
            this.havings.add(havingExpression);
        }
    }

    public void setDataSourceName(String m_dataSourceName) {
        this.dataSourceName = m_dataSourceName;
    }

    public void addInnerTableName(String tableName) {
        this.addInnerTableName(tableName, null);
    }

    public void addInnerTableName(String tableName, String asname) {
        if (!StringTool.isEmpty(tableName)) {
            if (!StringTool.isEmpty(asname) && !tableName.equals(asname)) {
                this.innerTableNames.put(tableName, asname);
            } else {
                this.innerTableNames.put(tableName, null);
            }
        }
    }

    public void addOrder(String expression) {
        this.addOrder(expression, null);
    }

    public void addOrder(String expression, String orderType) {
        if (!StringTool.isEmpty(expression)) {
            if (StringTool.isEmpty(orderType) || orderType.equalsIgnoreCase("ASC")) {
                this.orders.put(expression, null);
            } else {
                this.orders.put(expression, orderType);
            }
        }
    }

    public void addOuterTableName(String tableName) {
        this.addOuterTableName(tableName, null);
    }

    public void addOuterTableName(String tableName, String asname) {
        if (!StringTool.isEmpty(tableName)) {
            if (!StringTool.isEmpty(asname) && !tableName.equals(asname)) {
                this.outerTableNames.put(tableName, asname);
            } else {
                this.outerTableNames.put(tableName, null);
            }
        }
    }

    public void addTableName(String tableName) {
        this.addTableName(tableName, null);
    }

    public void addTableName(String tableName, String asname) {
        if (!StringTool.isEmpty(tableName)) {
            if (!StringTool.isEmpty(asname) && !tableName.equals(asname)) {
                this.tableNames.put(tableName, asname);
            } else {
                this.tableNames.put(tableName, null);
            }
        }
    }

    public void setPkCol(String pkCol) {
        this.pkCol = pkCol;
        this.columns.add(0, pkCol, null);
    }
}

