/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.data;

import com.sdjxd.pms.platform.data.CalculatedColumnScriptRunner;
import com.sdjxd.pms.platform.data.DataColumn;
import com.sdjxd.pms.platform.data.DataTable;
import com.sdjxd.pms.platform.data.DbNull;
import com.sdjxd.pms.platform.data.DbTypeConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DataRow
implements Cloneable,
Serializable {
    public static final String ELEMENT_ROW = "Row";
    private DataTable table;
    private List data;
    private static final DbNull CONST_DBDATA_NULL = new DbNull();

    public DataRow(DataTable p_table) {
        this.table = p_table;
        this.data = Collections.synchronizedList(new ArrayList(this.table.getColumns().size()));
        int i = 0;
        while (i < this.table.getColumns().size()) {
            this.data.add(CONST_DBDATA_NULL);
            ++i;
        }
    }

    public DataTable getTable() {
        return this.table;
    }

    public void addNullValue() {
        this.data.add(new DbNull());
    }

    public void removeData(int index) {
        this.data.remove(index);
    }

    public Object getValue(String p_columnName) {
        DataColumn column = this.table.getColumn(p_columnName);
        if (column != null && column.isCalculated()) {
            Object value = new CalculatedColumnScriptRunner(this, column).eval(column.getExpression());
            return value;
        }
        return DbTypeConverter.validateDbNullToNull(this.data.get(column.getIndexInColList()));
    }

    public Object getValue(int p_columnIndex) {
        DataColumn column = this.table.getColumn(p_columnIndex);
        if (column != null && column.isCalculated()) {
            Object value = new CalculatedColumnScriptRunner(this, column).eval(column.getExpression());
            return value;
        }
        return DbTypeConverter.validateDbNullToNull(this.data.get(p_columnIndex));
    }

    public void setValue(String p_columnName, Object p_value, boolean p_ignoreReadOnly) {
        DataColumn column = this.table.getColumn(p_columnName.toUpperCase());
        this.data.set(column.getIndexInColList(), DbTypeConverter.toCommonType(p_value, column.getColumnType()));
    }

    public void setValue(String p_columnName, Object p_value) {
        this.setValue(p_columnName, p_value, false);
    }

    public void setValue(int p_columnIndex, Object p_value, boolean p_ignoreReadOnly) {
        DataColumn column = this.table.getColumn(p_columnIndex);
        this.data.set(p_columnIndex, DbTypeConverter.toCommonType(p_value, column.getColumnType()));
    }

    public Object clone() {
        DataRow row = new DataRow(this.table.cloneTableStructure());
        int i = 0;
        while (i < this.data.size()) {
            Object value = this.data.get(i);
            if (value != null) {
                if (value instanceof DbNull) {
                    value = null;
                } else if (value instanceof String) {
                    value = new String(value.toString());
                } else if (value instanceof Date) {
                    value = ((Date)value).clone();
                } else if (value instanceof byte[]) {
                    byte[] org = (byte[])value;
                    byte[] bytes = new byte[org.length];
                    System.arraycopy(org, 0, bytes, 0, org.length);
                    value = bytes;
                }
            }
            row.setValue(i, value, false);
            row.getTable().getRows().add(row);
            ++i;
        }
        return row;
    }

    public boolean equals(Object p_row) {
        if (p_row instanceof DataRow) {
            DataRow row = (DataRow)p_row;
            if (row.table.getColumns().size() != this.table.getColumns().size()) {
                return false;
            }
            int i = 0;
            while (i < this.data.size()) {
                if (!this.data.get(i).equals(row.data.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.data.size()) {
            if (this.data.get(i) instanceof Integer || this.data.get(i) instanceof String || this.data.get(i) instanceof Date) {
                hashCode += this.data.get(i).toString().hashCode();
            }
            ++i;
        }
        return hashCode;
    }

    public int copyData(DataRow row) {
        int i = 0;
        while (i < row.getTable().getColumns().size()) {
            this.table.appendColumn(row.getTable().getColumn(i));
            ++i;
        }
        i = 0;
        while (i < row.getTable().getColumns().size()) {
            boolean ro = this.table.getColumn((String)row.getTable().getColumnName((int)i)).readOnly;
            this.table.getColumn((String)row.getTable().getColumnName((int)i)).readOnly = false;
            this.setValue(row.getTable().getColumnName(i), row.getValue(i));
            this.table.getColumn((String)row.getTable().getColumnName((int)i)).readOnly = ro;
            ++i;
        }
        return this.data.size();
    }
}

