/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.cacheMonitor.service;

import com.sdjxd.pms.platform.Limit.bean.LimitTemplateBean;
import com.sdjxd.pms.platform.cache.Cache;
import com.sdjxd.pms.platform.cacheMonitor.model.CacheDetailBean;
import com.sdjxd.pms.platform.form.model.TreeDaoBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.cell.ListStyleBean;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheMonitor {
    public static Map cacheAccountMap = new HashMap();
    public static Map cacheDetailMap = new HashMap();
    public static final String CACHE_PATTERN = "PATTERN";
    public static final String CACHE_TREEDAOBEAN = "TREEDAOBEAN";
    public static final String CACHE_LISTSTYLEBEAN = "LISTSTYLEBEAN";
    public static final String CACHE_TABLEBYNAME = "TABLEBYNAME";
    public static final String CACHE_TABLEBYID = "TABLEBYID";
    public static final String CACHE_LIMITTEMPLATEBEAN = "LIMITTEMPLATEBEAN";
    public static final String CACHE_XMBH = "XMBH";
    public static final String CACHE_WHITERULELIST = "whiteRuleList";
    public static final String CACHE_WHITELIST = "whiteList";
    public static final Map<String, String> catchNameMap = new HashMap<String, String>();

    static {
        catchNameMap.put(CACHE_PATTERN, "\u8868\u5355");
        catchNameMap.put(CACHE_TREEDAOBEAN, "\u6811\u754c\u9762\u65b9\u6848");
        catchNameMap.put(CACHE_LISTSTYLEBEAN, "\u5217\u8868\u663e\u793a\u65b9\u6848");
        catchNameMap.put(CACHE_TABLEBYNAME, "\u8868-\u6309\u540d\u79f0");
        catchNameMap.put(CACHE_TABLEBYID, "\u8868-\u6309id");
        catchNameMap.put(CACHE_LIMITTEMPLATEBEAN, "\u6743\u9650");
        catchNameMap.put(CACHE_XMBH, "\u7cfb\u7edfip");
        catchNameMap.put(CACHE_WHITERULELIST, "\u767d\u540d\u5355\u89c4\u5219");
        catchNameMap.put(CACHE_WHITELIST, "\u767d\u540d\u5355");
    }

    public static boolean clearAllCache(Object[] cacheTypes) {
        try {
            if (cacheTypes.length > 0) {
                int i = 0;
                while (i < cacheTypes.length) {
                    String type = (String)cacheTypes[i];
                    if (CACHE_PATTERN.equals(type)) {
                        Cache.getPatternCache().clear();
                        cacheDetailMap.remove(CACHE_PATTERN);
                    } else if (CACHE_TREEDAOBEAN.equals(type)) {
                        Cache.getTreeDaoBeanCache().clear();
                        cacheDetailMap.remove(CACHE_TREEDAOBEAN);
                    } else if (CACHE_LISTSTYLEBEAN.equals(type)) {
                        Cache.getListStyleBeanCache().clear();
                        cacheDetailMap.remove(CACHE_LISTSTYLEBEAN);
                    } else if (CACHE_TABLEBYNAME.equals(type)) {
                        Cache.getTableByNameCache().clear();
                        cacheDetailMap.remove(CACHE_TABLEBYNAME);
                    } else if (CACHE_TABLEBYID.equals(type)) {
                        Cache.getTableByIdCache().clear();
                        cacheDetailMap.remove(CACHE_TABLEBYID);
                    } else if (CACHE_LIMITTEMPLATEBEAN.equals(type)) {
                        Cache.getLimitTemplateBeanCache().clear();
                        cacheDetailMap.remove(CACHE_LIMITTEMPLATEBEAN);
                    } else if (CACHE_XMBH.equals(type)) {
                        Cache.getXmbhCache().clear();
                        cacheDetailMap.remove(CACHE_XMBH);
                    } else if (CACHE_WHITERULELIST.equals(type)) {
                        Cache.getWhiteRuleListCache().clear();
                        cacheDetailMap.remove(CACHE_WHITERULELIST);
                    } else if (CACHE_WHITELIST.equals(type)) {
                        Cache.getWhiteListCache().clear();
                        cacheDetailMap.remove(CACHE_WHITELIST);
                    }
                    ++i;
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void clearCaches(Object[] cacheIds) {
        if (cacheIds.length > 0) {
            String[] array = (String[])cacheIds;
            int i = 0;
            while (i < array.length) {
                String cacheId = array[i];
                for (Map.Entry entry : cacheDetailMap.entrySet()) {
                    Map itemMap = (Map)entry.getValue();
                    CacheDetailBean bean = (CacheDetailBean)itemMap.get(cacheId);
                    if (bean == null) continue;
                    itemMap.remove(cacheId);
                    String type = bean.getType();
                    if (CACHE_PATTERN.equals(type)) {
                        Cache.getPatternCache().remove((Object)array[i]);
                        continue;
                    }
                    if (CACHE_TREEDAOBEAN.equals(type)) {
                        Cache.getTreeDaoBeanCache().remove((Object)array[i]);
                        continue;
                    }
                    if (CACHE_LISTSTYLEBEAN.equals(type)) {
                        Cache.getListStyleBeanCache().remove((Object)array[i]);
                        continue;
                    }
                    if (CACHE_TABLEBYID.equals(type)) {
                        Cache.getTableByIdCache().remove((Object)array[i]);
                        continue;
                    }
                    if (CACHE_TABLEBYNAME.equals(type)) {
                        Cache.getTableByNameCache().remove((Object)array[i]);
                        continue;
                    }
                    if (CACHE_LIMITTEMPLATEBEAN.equals(type)) {
                        Cache.getLimitTemplateBeanCache().remove((Object)array[i]);
                        continue;
                    }
                    if (CACHE_XMBH.equals(type)) {
                        Cache.getXmbhCache().remove((Object)array[i]);
                        continue;
                    }
                    if (CACHE_WHITERULELIST.equals(type)) {
                        Cache.getWhiteRuleListCache().remove((Object)array[i]);
                        continue;
                    }
                    if (!CACHE_WHITELIST.equals(type)) continue;
                    Cache.getWhiteListCache().remove((Object)array[i]);
                }
                ++i;
            }
        }
    }

    public static List<Map> getAccountData() {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Map.Entry entry : cacheDetailMap.entrySet()) {
            String key = (String)entry.getKey();
            String name = catchNameMap.get(key);
            Map value = (Map)entry.getValue();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("KEY", key);
            map.put("SIZE", value.size());
            map.put("NAME", name);
            list.add(map);
        }
        return list;
    }

    public static List<Map> getDetailData(String type, String id) {
        ArrayList<Map> list;
        block7: {
            block8: {
                block6: {
                    CacheDetailBean value;
                    list = new ArrayList<Map>();
                    if (StringTool.isEmpty(type) || StringTool.isEmpty(id)) break block6;
                    Map map = (Map)cacheDetailMap.get(type);
                    if (map == null || (value = (CacheDetailBean)map.get(id)) == null) break block7;
                    Map itemMap = CacheMonitor.getItemData(value);
                    list.add(itemMap);
                    break block7;
                }
                if (StringTool.isEmpty(type) || !StringTool.isEmpty(id)) break block8;
                Map map = (Map)cacheDetailMap.get(type);
                if (map == null) break block7;
                for (CacheDetailBean value : map.values()) {
                    Map itemMap = CacheMonitor.getItemData(value);
                    list.add(itemMap);
                }
                break block7;
            }
            if (StringTool.isEmpty(type) && !StringTool.isEmpty(id)) {
                for (Map.Entry entry : cacheDetailMap.entrySet()) {
                    Map value = (Map)entry.getValue();
                    CacheDetailBean bean = (CacheDetailBean)value.get(id);
                    if (bean == null) continue;
                    Map itemMap = CacheMonitor.getItemData(bean);
                    list.add(itemMap);
                }
            } else {
                for (Map.Entry entry : cacheDetailMap.entrySet()) {
                    Map map = (Map)entry.getValue();
                    for (CacheDetailBean value : map.values()) {
                        Map itemMap = CacheMonitor.getItemData(value);
                        list.add(itemMap);
                    }
                }
            }
        }
        return list;
    }

    public static Map getItemData(CacheDetailBean value) {
        if (value != null) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            String type = value.getType();
            itemMap.put("CATCHID", value.getCacheId());
            itemMap.put("COUNT", value.getCount());
            itemMap.put("LASTACCESSTIME", value.getLastAccessTime());
            itemMap.put("CREATETYPE", type);
            itemMap.put("CREATETYPENAME", catchNameMap.get(type));
            itemMap.put("CREATEDATA", value.getCreateDate());
            if (CACHE_PATTERN.equals(type)) {
                Form form = (Form)value.getValue();
                String catchname = form.getName();
                itemMap.put("CATCHNAME", catchname);
            } else if (CACHE_TREEDAOBEAN.equals(type)) {
                TreeDaoBean item = (TreeDaoBean)value.getValue();
                String catchname = (String)item.getM_appMap().get("APPNAME");
                itemMap.put("CATCHNAME", catchname);
            } else if (CACHE_LISTSTYLEBEAN.equals(type)) {
                ListStyleBean item = (ListStyleBean)value.getValue();
                String catchname = item.getStyleData().getStyleName();
                itemMap.put("CATCHNAME", catchname);
            } else if (CACHE_TABLEBYNAME.equals(type)) {
                TableBean item = (TableBean)value.getValue();
                String catchname = item.getTableName();
                itemMap.put("CATCHNAME", catchname);
            } else if (CACHE_TABLEBYID.equals(type)) {
                TableBean item = (TableBean)value.getValue();
                String catchname = item.getTableName();
                itemMap.put("CATCHNAME", catchname);
            } else if (CACHE_LIMITTEMPLATEBEAN.equals(type)) {
                LimitTemplateBean item = (LimitTemplateBean)value.getValue();
                String catchname = item.getLimitBean().getLimitName();
                itemMap.put("CATCHNAME", catchname);
            } else if (CACHE_XMBH.equals(type)) {
                String item;
                String catchname = item = (String)value.getValue();
                itemMap.put("CATCHNAME", catchname);
            } else if (CACHE_WHITERULELIST.equals(type)) {
                itemMap.put("CATCHNAME", catchNameMap.get("CACHE_WHITERULELIST"));
            } else if (CACHE_WHITELIST.equals(type)) {
                itemMap.put("CATCHNAME", catchNameMap.get("CACHE_WHITELIST"));
            }
            return itemMap;
        }
        return null;
    }
}

