/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.cache;

import com.jxd.ehcache.EHCacheTools;
import com.sdjxd.pms.platform.Limit.bean.LimitTemplateBean;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.cacheMonitor.model.CacheDetailBean;
import com.sdjxd.pms.platform.cacheMonitor.service.CacheMonitor;
import com.sdjxd.pms.platform.form.model.TreeDaoBean;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.cell.ListStyleBean;
import com.sdjxd.pms.platform.security.model.WhitRuleList;
import com.sdjxd.pms.platform.security.model.WhiteList;
import com.sdjxd.pms.platform.table.model.TableBean;
import com.sdjxd.pms.platform.tool.DateTool;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ehcache.CacheManager;
import org.xml.sax.SAXException;

public class Cache
extends HashMap {
    private String name;
    private int maxSize;
    public static Cache instance;
    private static Map stat;
    private static CacheManager cacheManager;
    private static org.ehcache.Cache<String, Form> patternCache;
    private static org.ehcache.Cache<String, TreeDaoBean> treeDaoBeanCache;
    private static org.ehcache.Cache<String, ListStyleBean> listStyleBeanCache;
    private static org.ehcache.Cache<String, TableBean> tableByNameCache;
    private static org.ehcache.Cache<String, TableBean> tableByIdCache;
    private static org.ehcache.Cache<String, LimitTemplateBean> limitTemplateBeanCache;
    private static org.ehcache.Cache<String, String> xmbhCache;
    private static org.ehcache.Cache<String, WhitRuleList> whiteRuleListCache;
    private static org.ehcache.Cache<String, WhiteList> whiteListCache;

    static {
        cacheManager = null;
        patternCache = null;
        treeDaoBeanCache = null;
        listStyleBeanCache = null;
        tableByNameCache = null;
        tableByIdCache = null;
        limitTemplateBeanCache = null;
        xmbhCache = null;
        whiteRuleListCache = null;
        whiteListCache = null;
        stat = new HashMap();
        instance = Cache.getCache("default", 100);
    }

    public static Cache getCache(String name, int maxSize) {
        Cache cache = null;
        cache = stat.containsKey(name) ? (Cache)stat.get(name) : new Cache(name, maxSize);
        return cache;
    }

    private Cache(String name, int i) {
        this.name = name;
        this.maxSize = i;
    }

    public Object set(Object key, Object value) {
        boolean isDebug = Global.isDebug();
        if (isDebug) {
            return null;
        }
        if (this.size() >= this.maxSize) {
            Iterator it = this.keySet().iterator();
            while (it.hasNext() && this.size() >= this.maxSize) {
                this.remove(it.next());
                it = this.keySet().iterator();
            }
        }
        return this.put(key, value);
    }

    private static synchronized boolean initEhCache() {
        Boolean result = false;
        boolean isDebug = Global.isDebug();
        if (isDebug) {
            return false;
        }
        if (cacheManager == null) {
            try {
                URL url = Cache.class.getClassLoader().getResource("");
                System.out.println(url);
                url = Thread.currentThread().getContextClassLoader().getResource("../ehcache-config.xml");
                System.out.println(url);
                cacheManager = EHCacheTools.getCacheManager((URL)url);
                if (patternCache == null) {
                    patternCache = cacheManager.getCache("pattern", String.class, Form.class);
                }
                if (treeDaoBeanCache == null) {
                    treeDaoBeanCache = cacheManager.getCache("treeDaoBean", String.class, TreeDaoBean.class);
                }
                if (listStyleBeanCache == null) {
                    listStyleBeanCache = cacheManager.getCache("listStyleBean", String.class, ListStyleBean.class);
                }
                if (tableByNameCache == null) {
                    tableByNameCache = cacheManager.getCache("tableByName", String.class, TableBean.class);
                }
                if (tableByIdCache == null) {
                    tableByIdCache = cacheManager.getCache("tableById", String.class, TableBean.class);
                }
                if (limitTemplateBeanCache == null) {
                    limitTemplateBeanCache = cacheManager.getCache("limitTemplateBean", String.class, LimitTemplateBean.class);
                }
                if (xmbhCache == null) {
                    xmbhCache = cacheManager.getCache("xmbh", String.class, String.class);
                }
                if (whiteRuleListCache == null) {
                    whiteRuleListCache = cacheManager.getCache("whiteRuleList", String.class, WhitRuleList.class);
                }
                if (whiteListCache == null) {
                    whiteListCache = cacheManager.getCache("whiteList", String.class, WhiteList.class);
                }
                result = true;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        return true;
    }

    public static Form getPatternCache(String patternId) {
        if (Cache.initEhCache()) {
            Form cache = (Form)patternCache.get((Object)patternId);
            Cache.setCountAndTime("PATTERN", patternId);
            return cache;
        }
        return null;
    }

    public static void setPatternCache(String patternId, Form pattern) {
        if (Cache.initEhCache()) {
            patternCache.put((Object)patternId, (Object)pattern);
        }
    }

    public static TreeDaoBean getTreeDaoBeanCache(String m_appId) {
        if (Cache.initEhCache()) {
            TreeDaoBean cache = (TreeDaoBean)treeDaoBeanCache.get((Object)m_appId);
            Cache.setCountAndTime("TREEDAOBEAN", m_appId);
            return cache;
        }
        return null;
    }

    public static void setTreeDaoBeanCache(String m_appId, TreeDaoBean treeDaoBean) {
        if (Cache.initEhCache()) {
            treeDaoBeanCache.put((Object)m_appId, (Object)treeDaoBean);
        }
    }

    public static ListStyleBean getListStyleBeanCache(String styleId) {
        if (Cache.initEhCache()) {
            ListStyleBean cache = (ListStyleBean)listStyleBeanCache.get((Object)styleId);
            Cache.setCountAndTime("LISTSTYLEBEAN", styleId);
            return cache;
        }
        return null;
    }

    public static void setListStyleBeanCache(String styleId, ListStyleBean listStyleBean) {
        if (Cache.initEhCache()) {
            listStyleBeanCache.put((Object)styleId, (Object)listStyleBean);
        }
    }

    public static TableBean getTableByNameCache(String tableId) {
        if (Cache.initEhCache()) {
            TableBean cache = (TableBean)tableByNameCache.get((Object)tableId);
            Cache.setCountAndTime("TABLEBYNAME", tableId);
            return cache;
        }
        return null;
    }

    public static void setTableByNameCache(String tableId, TableBean table) {
        if (Cache.initEhCache()) {
            tableByNameCache.put((Object)tableId, (Object)table);
        }
    }

    public static TableBean getTableByIdCache(String tableId) {
        if (Cache.initEhCache()) {
            TableBean cache = (TableBean)tableByIdCache.get((Object)tableId);
            Cache.setCountAndTime("TABLEBYID", tableId);
            return cache;
        }
        return null;
    }

    public static void setTableByIdCache(String tableId, TableBean table) {
        if (Cache.initEhCache()) {
            tableByIdCache.put((Object)tableId, (Object)table);
        }
    }

    public static LimitTemplateBean getLimitTemplateBeanCache(String _LimitId) {
        if (Cache.initEhCache()) {
            LimitTemplateBean cache = (LimitTemplateBean)limitTemplateBeanCache.get((Object)_LimitId);
            Cache.setCountAndTime("LIMITTEMPLATEBEAN", _LimitId);
            return cache;
        }
        return null;
    }

    public static void setLimitTemplateBeanCache(String _LimitId, LimitTemplateBean limitTemplateBean) {
        if (Cache.initEhCache()) {
            limitTemplateBeanCache.put((Object)_LimitId, (Object)limitTemplateBean);
        }
    }

    public static String getXmbhCache(String ip) {
        if (ip != null && Cache.initEhCache()) {
            String cache = (String)xmbhCache.get((Object)ip);
            Cache.setCountAndTime("XMBH", ip);
            return cache;
        }
        return null;
    }

    public static void setXmbhCache(String ip, String xmbh) {
        if (ip != null && Cache.initEhCache()) {
            xmbhCache.put((Object)ip, (Object)xmbh);
        }
    }

    public static WhitRuleList getWhiteRuleListCache(String key) {
        if (key != null && Cache.initEhCache()) {
            WhitRuleList cache = (WhitRuleList)whiteRuleListCache.get((Object)key);
            Cache.setCountAndTime("whiteRuleList", key);
            return cache;
        }
        return null;
    }

    public static void setWhiteRuleListCache(String key, WhitRuleList whitRuleList) {
        if (key != null && Cache.initEhCache()) {
            whiteRuleListCache.put((Object)key, (Object)whitRuleList);
        }
    }

    public static WhiteList getWhiteListCache(String key) {
        if (key != null && Cache.initEhCache()) {
            WhiteList cache = (WhiteList)whiteListCache.get((Object)key);
            Cache.setCountAndTime("whiteRuleList", key);
            return cache;
        }
        return null;
    }

    public static void setWhiteListCache(String key, WhiteList whiteList) {
        if (key != null && Cache.initEhCache()) {
            whiteListCache.put((Object)key, (Object)whiteList);
        }
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    public static org.ehcache.Cache<String, Form> getPatternCache() {
        return patternCache;
    }

    public static org.ehcache.Cache<String, TreeDaoBean> getTreeDaoBeanCache() {
        return treeDaoBeanCache;
    }

    public static org.ehcache.Cache<String, ListStyleBean> getListStyleBeanCache() {
        return listStyleBeanCache;
    }

    public static org.ehcache.Cache<String, TableBean> getTableByNameCache() {
        return tableByNameCache;
    }

    public static org.ehcache.Cache<String, TableBean> getTableByIdCache() {
        return tableByIdCache;
    }

    public static org.ehcache.Cache<String, LimitTemplateBean> getLimitTemplateBeanCache() {
        return limitTemplateBeanCache;
    }

    public static org.ehcache.Cache<String, String> getXmbhCache() {
        return xmbhCache;
    }

    public static org.ehcache.Cache<String, WhitRuleList> getWhiteRuleListCache() {
        return whiteRuleListCache;
    }

    public static org.ehcache.Cache<String, WhiteList> getWhiteListCache() {
        return whiteListCache;
    }

    public static CacheDetailBean setCountAndTime(String type, String cacheId) {
        CacheDetailBean bean;
        String lastAccessTime = DateTool.getCurrentDate("yyyy-MM-dd HH:mm:ss");
        Map map = (Map)CacheMonitor.cacheDetailMap.get(type);
        if (map != null && (bean = (CacheDetailBean)map.get(cacheId)) != null) {
            int count = bean.getCount();
            bean.setCount(++count);
            bean.setLastAccessTime(lastAccessTime);
            return bean;
        }
        return null;
    }
}

