/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.base.timer;

import com.sdjxd.pms.platform.base.timer.TimerEntry;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.tool.DataSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public final class TimerScheduler {
    private static final TimerScheduler m_scheduler = new TimerScheduler();
    public static final int STOP = 1;
    public static final int RUNNING = 2;
    private static final Logger m_logger = Logger.getLogger(TimerScheduler.class);
    private int m_status = 1;
    private HashMap m_timerContainer = new HashMap();

    public static TimerScheduler getInstance() {
        return m_scheduler;
    }

    public void cancel() {
    }

    public void removeFinished() {
        Iterator it = this.m_timerContainer.entrySet().iterator();
        ArrayList<String> removeList = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry temp = it.next();
            TimerEntry entry = (TimerEntry)temp.getValue();
            String id = (String)temp.getKey();
            if (4 != entry.getStatus()) continue;
            removeList.add(id);
        }
        int i = 0;
        while (i < removeList.size()) {
            this.m_timerContainer.remove(removeList.get(i));
            ++i;
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public void load() {
        String sql2 = "select timer_id, timer_name, timer_express, timer_function  from [S].jxd7_xt_timer  where timer_enabled = '1'";
        this.m_timerContainer.clear();
        this.createNewEntry(sql2);
        this.m_status = 2;
    }

    public void refresh(ArrayList timerIdArray) {
        int i = 0;
        while (i < timerIdArray.size()) {
            TimerEntry entry = (TimerEntry)this.m_timerContainer.get(timerIdArray.get(i));
            if (entry != null) {
                entry.cancel();
                this.m_timerContainer.remove(timerIdArray.get(i));
            }
            ++i;
        }
        StringBuffer in = new StringBuffer("(");
        int i2 = 0;
        while (i2 < timerIdArray.size() - 1) {
            in.append(timerIdArray.get(i2) + ",");
            ++i2;
        }
        if (timerIdArray.size() > 0) {
            in.append(timerIdArray.get(timerIdArray.size() - 1) + ")");
        }
        String sql2 = "select timer_id, timer_name, timer_express, timer_function  from [S].jxd7_xt_timer  where timer_enabled = '1' and timer_id in " + in.toString();
        this.createNewEntry(sql2);
    }

    void testAllTimer() {
        Iterator it = this.m_timerContainer.entrySet().iterator();
        while (it.hasNext()) {
            TimerEntry entry = (TimerEntry)it.next().getValue();
            entry.logNext20Time();
        }
    }

    private TimerScheduler() {
    }

    private void createNewEntry(String sql2) {
        DataSet ds = null;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            ds = new DataSet(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            m_logger.error((Object)e);
        }
        if (ds != null) {
            while (ds.next()) {
                TimerEntry timer = new TimerEntry(ds.getString("timer_id"), ds.getString("timer_name"), ds.getString("timer_express"), ds.getString("timer_function"));
                this.m_timerContainer.put(ds.getString("timer_id"), timer);
                timer.logNext20Time();
                timer.start();
            }
        }
    }
}

