/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.base.timer;

import com.sdjxd.pms.platform.base.timer.TimerEntry;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbType;
import com.sdjxd.pms.platform.tool.BeanTool;
import java.net.InetAddress;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimerTask;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public final class TimerEntryTask
extends TimerTask {
    private static final Logger m_logger = Logger.getLogger(TimerEntryTask.class);
    private final String m_id;
    private final String m_name;
    private final String m_function;
    private final TimerEntry m_entry;
    private final int m_type;

    public TimerEntryTask(String id, String name, String function, TimerEntry timerEntry, int type) {
        this.m_id = id;
        this.m_name = name;
        this.m_function = function;
        this.m_entry = timerEntry;
        this.m_type = type;
    }

    @Override
    public void run() {
        String startTime = null;
        String endTime = null;
        boolean success = true;
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        startTime = df.format(date);
        if (m_logger.isInfoEnabled()) {
            m_logger.info((Object)("timer id: " + this.m_id + ", name: " + this.m_name + ", start: " + startTime));
        }
        this.insertTimerExt();
        this.setRunningStatus();
        this.updateNextExecTime(startTime, date);
        if (!"".equals(this.m_function)) {
            int pos = this.m_function.lastIndexOf(46);
            String className = this.m_function.substring(0, pos);
            String methodName = this.m_function.substring(pos + 1);
            try {
                this.insertLog("\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c");
                BeanTool.invokeMethod(className, methodName, new Object[]{this.m_id, this.m_name});
                this.insertLog("\u5b9a\u65f6\u5668\u6267\u884c\u7ed3\u675f");
            }
            catch (Exception e) {
                success = false;
                this.insertLog("\u5b9a\u65f6\u5668\u6267\u884c\u5f02\u5e38\uff1a" + e.toString());
                m_logger.error((Object)"\u5b9a\u65f6\u5668\u6267\u884c\u5f02\u5e38!", (Throwable)e);
            }
        }
        endTime = df.format(date);
        if (m_logger.isInfoEnabled()) {
            m_logger.info((Object)("timer id: " + this.m_id + ", name: " + this.m_name + ", end: " + endTime));
        }
        if (1 == this.m_type) {
            this.m_entry.nextTimer();
        }
        this.updateThisTimeResult(startTime, success);
        this.setUnrunningStatus();
    }

    private void insertTimerExt() {
        try {
            int count;
            String querySql = "select count(1)as num  from JXD7_XT_TIMER_EX where timerid = '" + this.m_id + "'";
            RowSet rs = DbOper.executeQuery(querySql);
            if (rs.next() && (count = rs.getInt("num")) == 0) {
                String insertSql = "insert into JXD7_XT_TIMER_EX(timerid,timername)values('" + this.m_id + "','" + this.m_name + "')";
                DbOper.executeNonQuery(insertSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void updateNextExecTime(String startTime, Date date) {
        String nextTime = this.m_entry.getNextExecTime(date);
        String updateSql = "update JXD7_XT_TIMER_EX set lasttimestate = '" + startTime + "',nexttime='" + nextTime + "' where timerid = '" + this.m_id + "'";
        try {
            int i = DbOper.executeNonQuery(updateSql);
        }
        catch (SQLException e) {
            m_logger.info((Object)(String.valueOf(this.m_name) + ":\u5b9a\u65f6\u5668\u6269\u5c55\u4fe1\u606f\u66f4\u65b0\u4e0b\u6b21\u8fd0\u884c\u65f6\u95f4\u5931\u8d25\uff01"));
            e.printStackTrace();
        }
    }

    private void updateThisTimeResult(String startTime, boolean result) {
        String updateSql = "update JXD7_XT_TIMER_EX set lasttimestate = '" + (result ? "\u6210\u529f" : "\u5931\u8d25") + "(" + startTime + ")' where timerid = '" + this.m_id + "'";
        try {
            int i = DbOper.executeNonQuery(updateSql);
        }
        catch (SQLException e) {
            m_logger.info((Object)(String.valueOf(this.m_name) + ":\u5b9a\u65f6\u5668\u6269\u5c55\u4fe1\u606f\u66f4\u65b0\u672c\u6b21\u6267\u884c\u7ed3\u679c\u5931\u8d25\uff01"));
            e.printStackTrace();
        }
    }

    private void setRunningStatus() {
        try {
            String updateSql = "update JXD7_XT_TIMER_EX set state = '1' where timerid = '" + this.m_id + "'";
            int i = DbOper.executeNonQuery(updateSql);
            if (i < 1) {
                m_logger.info((Object)(String.valueOf(this.m_name) + ":\u5b9a\u65f6\u5668\u6269\u5c55\u4fe1\u606f\u66f4\u65b0\u8fd0\u884c\u72b6\u6001\u5931\u8d25\uff01"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void setUnrunningStatus() {
        try {
            String updateSql = "update JXD7_XT_TIMER_EX set state = '0' where timerid = '" + this.m_id + "'";
            int i = DbOper.executeNonQuery(updateSql);
            if (i < 1) {
                m_logger.info((Object)(String.valueOf(this.m_name) + ":\u5b9a\u65f6\u5668\u6269\u5c55\u4fe1\u606f\u66f4\u65b0\u672a\u8fd0\u884c\u72b6\u6001\u5931\u8d25\uff01"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void insertLog(String message) {
        try {
            int i;
            String ipAddress = InetAddress.getLocalHost().getHostAddress();
            String insertSql = null;
            if (DbOper.getDbType() == DbType.SQL) {
                insertSql = "insert into JXD7_XT_TIMER_LOG(datastatusid,datatype,sheetid,timerid,timername,createdate,message,T_TYPE,IPADDRESS)values ('1','1',newId(),'" + this.m_id + "','" + this.m_name + "',CONVERT(varchar(100), GETDATE(), 121),'" + message + "','0','" + ipAddress + "')";
            } else if (DbOper.getDbType() == DbType.ORACLE) {
                insertSql = "insert into JXD7_XT_TIMER_LOG(datastatusid,datatype,sheetid,timerid,timername,createdate,message,T_TYPE,IPADDRESS)values ('1','1',SYS_GUID(),'" + this.m_id + "','" + this.m_name + "', TO_CHAR(SYSDATE,'YYYY-MM-DD HH24:MI:SS'),'" + message + "','0','" + ipAddress + "')";
            } else if (DbOper.getDbType() == DbType.MYSQL) {
                insertSql = "insert into JXD7_XT_TIMER_LOG(datastatusid,datatype,sheetid,timerid,timername,createdate,message,T_TYPE,IPADDRESS)values ('1','1',uuid(),'" + this.m_id + "','" + this.m_name + "',NOW(),'" + message + "','0','" + ipAddress + "')";
            }
            if (insertSql != null && (i = DbOper.executeNonQuery(insertSql)) < 1) {
                m_logger.info((Object)(String.valueOf(this.m_name) + ":\u6dfb\u52a0\u5b9a\u65f6\u5668\u65e5\u5fd7\u5931\u8d25\uff01"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

