/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.base.timer;

import com.sdjxd.pms.platform.base.timer.TimerEntryTask;
import com.sdjxd.pms.platform.base.timer.TimerFieldItem;
import com.sdjxd.pms.platform.tool.StringTool;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public final class TimerEntry {
    public static final int CYCLE_DAY = 86400000;
    public static final int CYCLE_HOUR = 3600000;
    public static final int CYCLE_MINUTE = 60000;
    public static final int STATUS_EXPR_ERROR = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_STOP = 3;
    public static final int STATUS_FINISHED = 4;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_CALENDAR = 1;
    public static final int TYPE_CYCLE = 2;
    private static final Logger m_logger = Logger.getLogger(TimerEntry.class);
    private int m_status = 3;
    private int m_type = 0;
    private String m_id;
    private String m_name;
    private String m_express;
    private String m_function;
    private Timer m_timer;
    private int m_pattern = -1;
    private ArrayList m_yearItemList;
    private ArrayList m_quarterItemList;
    private ArrayList m_monthItemList;
    private ArrayList m_dayItemList;
    private ArrayList m_weekItemList;
    private ArrayList m_weekNItemList;
    private ArrayList m_hourItemList;
    private ArrayList m_minuteItemList;
    private Date m_lastTime;
    private Date m_startTime;
    private int m_cycle;
    private int m_cycleUnit;
    private static final int[] daysForQuarterList;
    private static final int[] daysList;

    static {
        int[] nArray = new int[13];
        nArray[2] = 31;
        nArray[5] = 30;
        nArray[6] = 61;
        nArray[8] = 31;
        nArray[9] = 62;
        nArray[11] = 30;
        nArray[12] = 61;
        daysForQuarterList = nArray;
        int[] nArray2 = new int[13];
        nArray2[1] = 31;
        nArray2[2] = 28;
        nArray2[3] = 31;
        nArray2[4] = 30;
        nArray2[5] = 31;
        nArray2[6] = 30;
        nArray2[7] = 31;
        nArray2[8] = 31;
        nArray2[9] = 30;
        nArray2[10] = 31;
        nArray2[11] = 30;
        nArray2[12] = 31;
        daysList = nArray2;
    }

    public TimerEntry(String id, String name, String express, String function) {
        this.m_id = id;
        this.m_name = name;
        this.m_express = express;
        this.m_function = function;
        if (this.parse()) {
            this.recognizePattern();
        }
    }

    public void cancel() {
        this.m_status = 3;
        this.m_timer.cancel();
        this.m_timer = null;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void start() {
        if (3 == this.m_status) {
            if (1 == this.m_type) {
                Calendar cal = Calendar.getInstance();
                if (this.next(cal)) {
                    this.m_status = 2;
                    this.m_lastTime = cal.getTime();
                    this.createTimer();
                    this.m_timer.schedule((TimerTask)new TimerEntryTask(this.m_id, this.m_name, this.m_function, this, 1), this.m_lastTime);
                } else {
                    this.m_status = 4;
                    this.m_timer = null;
                }
            } else if (2 == this.m_type) {
                Date startTime = this.getStartTime();
                long period = (long)this.m_cycle * (long)this.m_cycleUnit;
                this.m_status = 2;
                this.createTimer();
                this.m_timer.scheduleAtFixedRate((TimerTask)new TimerEntryTask(this.m_id, this.m_name, this.m_function, this, 2), startTime, period);
            }
        }
    }

    TimerEntry(String express) {
        this.m_id = "";
        this.m_name = "";
        this.m_express = express;
        this.m_function = "";
        this.parse();
        this.recognizePattern();
    }

    void nextTimer() {
        if (2 == this.m_status) {
            Calendar cal = Calendar.getInstance();
            if (this.next(cal)) {
                this.m_lastTime = cal.getTime();
                this.m_timer.schedule((TimerTask)new TimerEntryTask(this.m_id, this.m_name, this.m_function, this, 1), this.m_lastTime);
            } else {
                this.m_status = 4;
                this.m_timer = null;
            }
        }
    }

    void logNext20Time() {
        if (3 == this.m_status) {
            StringBuffer sb = new StringBuffer();
            Date date = null;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sb.append(String.valueOf(this.m_id) + "\r\n");
            sb.append(String.valueOf(this.m_name) + "\r\n");
            sb.append(String.valueOf(this.m_express) + "\r\n");
            if (1 == this.m_type) {
                Calendar cal = Calendar.getInstance();
                int i = 0;
                while (i < 20) {
                    if (this.next(cal)) {
                        date = cal.getTime();
                        sb.append(String.valueOf(df.format(date)) + "\r\n");
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (2 == this.m_type) {
                date = this.getStartTime();
                sb.append("\u4ece" + df.format(date) + "\u5f00\u59cb\u6bcf");
                switch (this.m_cycleUnit) {
                    case 86400000: {
                        sb.append(String.valueOf(this.m_cycle) + "\u5929\r\n");
                        break;
                    }
                    case 3600000: {
                        sb.append(String.valueOf(this.m_cycle) + "\u5c0f\u65f6\r\n");
                        break;
                    }
                    case 60000: {
                        sb.append(String.valueOf(this.m_cycle) + "\u5206\r\n");
                        break;
                    }
                }
            }
            m_logger.info((Object)sb.toString());
        }
    }

    private synchronized void createTimer() {
        if (this.m_timer == null) {
            this.m_timer = new Timer(true);
        }
    }

    private int getNextValue(ArrayList itemList, int current, int min, int max, int[] carry) {
        int next = Integer.MAX_VALUE;
        int first = Integer.MAX_VALUE;
        int i = 0;
        while (i < itemList.size()) {
            TimerFieldItem item = (TimerFieldItem)itemList.get(i);
            if (4 == item.m_type) {
                if (current > max) {
                    first = min;
                    break;
                }
                next = current;
                break;
            }
            if (2 == item.m_type) {
                if (current >= item.m_start && current <= item.m_end) {
                    next = current;
                    break;
                }
                if (current < item.m_start && next > item.m_start) {
                    next = item.m_start;
                } else if (current > item.m_end && first > item.m_start) {
                    first = item.m_start;
                }
            } else if (1 == item.m_type) {
                int start = item.m_start;
                if (item.m_start < 0) {
                    start = max + item.m_start + 1;
                }
                if (current == start) {
                    next = current;
                    break;
                }
                if (current < start && next > start) {
                    next = start;
                } else if (current > start && first > start) {
                    first = start;
                }
            } else if (3 == item.m_type) {
                if (current < item.m_start && next > item.m_start) {
                    next = item.m_start;
                } else if (current >= item.m_start) {
                    if ((current - item.m_start) % item.m_step == 0) {
                        next = current;
                        break;
                    }
                    int nextStep = item.m_start + ((current - item.m_start) / item.m_step + 1) * item.m_step;
                    if (nextStep <= max) {
                        next = nextStep;
                    } else {
                        first = item.m_start;
                    }
                }
            }
            ++i;
        }
        int result = -1;
        if (next < Integer.MAX_VALUE) {
            carry[0] = 0;
            result = next;
        } else if (first < Integer.MAX_VALUE) {
            carry[0] = 1;
            result = first;
        }
        return result;
    }

    private Date getStartTime() {
        Calendar cal = Calendar.getInstance();
        long now = cal.getTimeInMillis();
        Date startTime = this.m_startTime;
        cal.setTime(this.m_startTime);
        long start = cal.getTimeInMillis();
        if (start < now) {
            switch (this.m_cycleUnit) {
                case 86400000: {
                    int days = (int)((now - start - 1000L) / (long)(this.m_cycle * 24 * 3600000) + 1L) * this.m_cycle;
                    cal.add(5, days);
                    startTime = cal.getTime();
                    break;
                }
                case 3600000: {
                    int hours = (int)((now - start - 1000L) / (long)(this.m_cycle * 3600000) + 1L) * this.m_cycle;
                    cal.add(11, hours);
                    startTime = cal.getTime();
                    break;
                }
                case 60000: {
                    int minutes = (int)((now - start - 1000L) / (long)(this.m_cycle * 60000) + 1L) * this.m_cycle;
                    cal.add(12, minutes);
                    startTime = cal.getTime();
                    break;
                }
                default: {
                    m_logger.error((Object)("Timer error, id: " + this.m_id + ", name: " + this.m_name + "."));
                }
            }
        }
        return startTime;
    }

    private boolean isIgnore(ArrayList itemList) {
        return 5 == ((TimerFieldItem)itemList.get((int)0)).m_type;
    }

    private boolean isValidDayOfYear(int year, int day) {
        int days = TimerEntry.getDaysOfYear(year);
        return day <= days;
    }

    private boolean isValidDayOfQuarter(int year, int quarter, int day) {
        int days = TimerEntry.getDaysOfQuarter(year, quarter);
        return day <= days;
    }

    private boolean isValidDayOfMonth(int year, int month, int day) {
        int days = TimerEntry.getDaysOfMonth(year, month);
        return day <= days;
    }

    private boolean isValidWeekOfMonth(int year, int month, int week, int weekN) {
        if (week <= 4) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, TimerEntry.getDaysOfMonth(year, month));
        int lastWeekN = cal.get(7);
        int weeks = cal.get(4);
        cal.set(year, month - 1, 1);
        int firstWeekN = cal.get(7);
        return 5 == weeks ? weekN >= firstWeekN && weekN <= lastWeekN : 6 == weeks && (weekN >= firstWeekN || weekN <= lastWeekN);
    }

    private boolean isValidWeekNOfYear(int year, int week, int weekN) {
        if (week <= 52) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, 11, 31);
        int lastWeekN = cal.get(7);
        int weeks = cal.get(4);
        cal.set(year, 0, 1);
        int firstWeekN = cal.get(7);
        return 53 == weeks ? weekN >= firstWeekN && weekN <= lastWeekN : 54 == weeks && (weekN >= firstWeekN || weekN <= lastWeekN);
    }

    private boolean next(Calendar cal) {
        boolean result = false;
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int hour = cal.get(11);
        int minute = cal.get(12);
        int[] carry = new int[]{1};
        int nextMinute = this.getNextValue(this.m_minuteItemList, minute + carry[0], 0, 59, carry);
        int nextHour = this.getNextValue(this.m_hourItemList, hour + carry[0], 0, 23, carry);
        int[] nextYear = new int[]{year};
        int yearValue = -1;
        int monthValue = -1;
        int dayValue = -1;
        int hourValue = nextHour;
        int minuteValue = nextMinute;
        switch (this.m_pattern) {
            case 1: {
                int[] nextDay = new int[]{cal.get(6)};
                result = this.nextPattern1(nextYear, nextDay, carry[0]);
                if (!result) break;
                yearValue = nextYear[0];
                monthValue = TimerEntry.getMonthFormDay(yearValue, nextDay[0]);
                dayValue = TimerEntry.getDayOfMonthFormDay(yearValue, nextDay[0]);
                break;
            }
            case 2: {
                int quarter = (month - 1) / 3 + 1;
                int day = cal.get(5);
                int dayOfQuarter = TimerEntry.getDayOfQuarter(year, month, day);
                int[] nextQuarter = new int[]{quarter};
                int[] nextDay = new int[]{dayOfQuarter};
                result = this.nextPattern2(nextYear, nextQuarter, nextDay, carry[0]);
                if (!result) break;
                yearValue = nextYear[0];
                if (2 == nextQuarter[0]) {
                    nextDay[0] = nextDay[0] + TimerEntry.getDaysOfQuarter(yearValue, 1);
                } else if (3 == nextQuarter[0]) {
                    nextDay[0] = nextDay[0] + (TimerEntry.getDaysOfQuarter(yearValue, 1) + TimerEntry.getDaysOfQuarter(yearValue, 2));
                } else if (4 == nextQuarter[0]) {
                    nextDay[0] = nextDay[0] + (TimerEntry.getDaysOfQuarter(yearValue, 1) + TimerEntry.getDaysOfQuarter(yearValue, 2) + TimerEntry.getDaysOfQuarter(yearValue, 3));
                }
                monthValue = TimerEntry.getMonthFormDay(yearValue, nextDay[0]);
                dayValue = TimerEntry.getDayOfMonthFormDay(yearValue, nextDay[0]);
                break;
            }
            case 3: {
                int quarter = (month - 1) / 3 + 1;
                int monthInQuarter = month - (quarter - 1) * 3;
                int day = cal.get(5);
                int[] nextQuarter = new int[]{quarter};
                int[] nextMonth = new int[]{monthInQuarter};
                int[] nextDay = new int[]{day};
                result = this.nextPattern3(nextYear, nextQuarter, nextMonth, nextDay, carry[0]);
                if (!result) break;
                yearValue = nextYear[0];
                monthValue = (nextQuarter[0] - 1) * 3 + nextMonth[0];
                dayValue = nextDay[0];
                break;
            }
            case 4: {
                int[] nextDay = new int[]{cal.get(5)};
                int[] nextMonth = new int[]{month};
                result = this.nextPattern4(nextYear, nextMonth, nextDay, carry[0]);
                if (!result) break;
                yearValue = nextYear[0];
                monthValue = nextMonth[0];
                dayValue = nextDay[0];
                break;
            }
            case 5: {
                int day = cal.get(6);
                int[] nextWeek = new int[]{(day - 1) / 7 + 1};
                int[] nextWeekN = new int[]{cal.get(7)};
                result = this.nextPattern5(nextYear, nextWeek, nextWeekN, carry[0]);
                if (!result) break;
                cal.set(nextYear[0], 0, 1);
                int firstN = cal.get(7);
                int dayOfYear = (nextWeek[0] - 1) * 7 + 1 + (7 + nextWeekN[0] - firstN) % 7;
                yearValue = nextYear[0];
                monthValue = TimerEntry.getMonthFormDay(yearValue, dayOfYear);
                dayValue = TimerEntry.getDayOfMonthFormDay(yearValue, dayOfYear);
                break;
            }
            case 6: {
                int quarter = (month - 1) / 3 + 1;
                int day = cal.get(5);
                int dayOfQuarter = TimerEntry.getDayOfQuarter(year, month, day);
                cal.set(year, (quarter - 1) * 3, 1);
                int firstWeekN = cal.get(7);
                int[] nextWeek = new int[]{(dayOfQuarter - 1) / 7 + 1};
                int[] nextWeekN = new int[]{(dayOfQuarter - 1 + firstWeekN) % 7};
                int[] nextQuarter = new int[]{quarter};
                result = this.nextPattern6(nextYear, nextQuarter, nextWeek, nextWeekN, carry[0]);
                if (!result) break;
                int dayOfYear = 0;
                if (2 == nextQuarter[0]) {
                    dayOfYear += TimerEntry.getDaysOfQuarter(yearValue, 1);
                } else if (3 == nextQuarter[0]) {
                    dayOfYear += TimerEntry.getDaysOfQuarter(yearValue, 1) + TimerEntry.getDaysOfQuarter(yearValue, 2);
                } else if (4 == nextQuarter[0]) {
                    dayOfYear += TimerEntry.getDaysOfQuarter(yearValue, 1) + TimerEntry.getDaysOfQuarter(yearValue, 2) + TimerEntry.getDaysOfQuarter(yearValue, 3);
                }
                yearValue = nextYear[0];
                monthValue = TimerEntry.getMonthFormDay(yearValue, dayOfYear += (nextWeek[0] - 1) * 7 + 1 + (7 + nextWeekN[0] - firstWeekN) % 7);
                dayValue = TimerEntry.getDayOfMonthFormDay(yearValue, dayOfYear);
                break;
            }
            case 7: {
                int quarter = (month - 1) / 3 + 1;
                int monthInQuarter = month - (quarter - 1) * 3;
                int[] nextWeek = new int[]{cal.get(4)};
                int[] nextWeekN = new int[]{cal.get(7)};
                int[] nextMonth = new int[]{monthInQuarter};
                int[] nextQuarter = new int[]{quarter};
                cal.set(5, 0);
                int first = cal.get(7);
                if (nextWeekN[0] < first) {
                    nextWeek[0] = nextWeek[0] - 1;
                }
                if (!(result = this.nextPattern7(nextYear, nextQuarter, nextMonth, nextWeek, nextWeekN, carry[0]))) break;
                cal.set(nextYear[0], (nextQuarter[0] - 1) * 3 + nextMonth[0] - 1, 1);
                int firstWeekN = cal.get(7);
                int dayOfMonth = (nextWeek[0] - 1) * 7 + 1 + (7 + nextWeekN[0] - firstWeekN) % 7;
                yearValue = nextYear[0];
                monthValue = (nextQuarter[0] - 1) * 3 + nextMonth[0];
                dayValue = dayOfMonth;
                break;
            }
            case 8: {
                int[] nextWeek = new int[]{cal.get(4)};
                int[] nextWeekN = new int[]{cal.get(7)};
                int[] nextMonth = new int[]{month};
                cal.set(5, 0);
                int first = cal.get(7);
                if (nextWeekN[0] < first) {
                    nextWeek[0] = nextWeek[0] - 1;
                }
                if (!(result = this.nextPattern8(nextYear, nextMonth, nextWeek, nextWeekN, carry[0]))) break;
                cal.set(nextYear[0], nextMonth[0] - 1, 1);
                int firstWeekN = cal.get(7);
                int dayOfMonth = (nextWeek[0] - 1) * 7 + 1 + (7 + nextWeekN[0] - firstWeekN) % 7;
                yearValue = nextYear[0];
                monthValue = nextMonth[0];
                dayValue = dayOfMonth;
                break;
            }
        }
        if (result) {
            cal.set(yearValue, monthValue - 1, dayValue, hourValue, minuteValue, 0);
        } else {
            this.m_status = 3;
        }
        return result;
    }

    private boolean nextPattern1(int[] year, int[] day, int carry) {
        boolean result = true;
        int[] selfCarry = new int[]{carry};
        do {
            boolean dc = false;
            day[0] = this.getNextValue(this.m_dayItemList, day[0] + selfCarry[0], 1, TimerEntry.getDaysOfYear(year[0]), selfCarry);
            if (selfCarry[0] != 0) {
                dc = true;
            }
            year[0] = this.getNextValue(this.m_yearItemList, year[0] + selfCarry[0], 2000, 2260, selfCarry);
            if (selfCarry[0] != 0) {
                result = false;
                break;
            }
            if (dc) {
                day[0] = this.getNextValue(this.m_dayItemList, 1, 1, TimerEntry.getDaysOfYear(year[0]), selfCarry);
            }
            selfCarry[0] = 1;
        } while (!this.isValidDayOfYear(year[0], day[0]));
        return result;
    }

    private boolean nextPattern2(int[] year, int[] quarter, int[] day, int carry) {
        boolean result = true;
        int[] selfCarry = new int[]{carry};
        do {
            boolean recalc = false;
            day[0] = this.getNextValue(this.m_dayItemList, day[0] + selfCarry[0], 1, TimerEntry.getDaysOfQuarter(year[0], quarter[0]), selfCarry);
            if (selfCarry[0] != 0) {
                recalc = true;
            }
            quarter[0] = this.getNextValue(this.m_quarterItemList, quarter[0] + selfCarry[0], 1, 4, selfCarry);
            if (selfCarry[0] != 0) {
                recalc = true;
            }
            year[0] = this.getNextValue(this.m_yearItemList, year[0] + selfCarry[0], 2000, 2260, selfCarry);
            if (selfCarry[0] != 0) {
                result = false;
                break;
            }
            if (recalc) {
                day[0] = this.getNextValue(this.m_dayItemList, 1, 1, TimerEntry.getDaysOfQuarter(year[0], quarter[0]), selfCarry);
            }
            selfCarry[0] = 1;
        } while (!this.isValidDayOfQuarter(year[0], quarter[0], day[0]));
        return result;
    }

    private boolean nextPattern3(int[] year, int[] quarter, int[] month, int[] day, int carry) {
        boolean result = true;
        int[] selfCarry = new int[]{carry};
        do {
            boolean recalc = false;
            day[0] = this.getNextValue(this.m_dayItemList, day[0] + selfCarry[0], 1, TimerEntry.getDaysOfMonth(year[0], (quarter[0] - 1) * 3 + month[0]), selfCarry);
            if (selfCarry[0] != 0) {
                recalc = true;
            }
            month[0] = this.getNextValue(this.m_monthItemList, month[0] + selfCarry[0], 1, 3, selfCarry);
            if (selfCarry[0] != 0) {
                recalc = true;
            }
            quarter[0] = this.getNextValue(this.m_quarterItemList, quarter[0] + selfCarry[0], 1, 4, selfCarry);
            if (selfCarry[0] != 0) {
                recalc = true;
            }
            year[0] = this.getNextValue(this.m_yearItemList, year[0] + selfCarry[0], 2000, 2260, selfCarry);
            if (selfCarry[0] != 0) {
                result = false;
                break;
            }
            if (recalc) {
                day[0] = this.getNextValue(this.m_dayItemList, 1, 1, TimerEntry.getDaysOfMonth(year[0], (quarter[0] - 1) * 3 + month[0]), selfCarry);
            }
            selfCarry[0] = 1;
        } while (!this.isValidDayOfMonth(year[0], (quarter[0] - 1) * 3 + month[0], day[0]));
        return result;
    }

    private boolean nextPattern4(int[] year, int[] month, int[] day, int carry) {
        boolean result = true;
        int[] selfCarry = new int[]{carry};
        do {
            boolean recalc = false;
            day[0] = this.getNextValue(this.m_dayItemList, day[0] + selfCarry[0], 1, TimerEntry.getDaysOfMonth(year[0], month[0]), selfCarry);
            if (selfCarry[0] != 0) {
                recalc = true;
            }
            month[0] = this.getNextValue(this.m_monthItemList, month[0] + selfCarry[0], 1, 12, selfCarry);
            if (selfCarry[0] != 0) {
                recalc = true;
            }
            year[0] = this.getNextValue(this.m_yearItemList, year[0] + selfCarry[0], 2000, 2260, selfCarry);
            if (selfCarry[0] != 0) {
                result = false;
                break;
            }
            if (recalc) {
                day[0] = this.getNextValue(this.m_dayItemList, 1, 1, TimerEntry.getDaysOfMonth(year[0], month[0]), selfCarry);
            }
            selfCarry[0] = 1;
        } while (!this.isValidDayOfMonth(year[0], month[0], day[0]));
        return result;
    }

    private boolean nextPattern5(int[] year, int[] week, int[] weekN, int carry) {
        boolean result = true;
        int[] selfCarry = new int[]{carry};
        Calendar cal = Calendar.getInstance();
        do {
            cal.set(year[0], 0, 1);
            int firstWeekN = cal.get(7);
            int oldWeekN = weekN[0];
            weekN[0] = this.getNextValue(this.m_weekNItemList, weekN[0] + selfCarry[0], 1, 7, selfCarry);
            if (weekN[0] < firstWeekN && oldWeekN >= firstWeekN) {
                selfCarry[0] = 0;
            } else if (weekN[0] >= firstWeekN && oldWeekN < firstWeekN) {
                selfCarry[0] = 1;
            }
            boolean wc = false;
            week[0] = this.getNextValue(this.m_weekItemList, week[0] + selfCarry[0], 1, 53, selfCarry);
            if (selfCarry[0] != 0) {
                wc = true;
            }
            year[0] = this.getNextValue(this.m_yearItemList, year[0] + selfCarry[0], 2000, 2260, selfCarry);
            if (selfCarry[0] != 0) {
                result = false;
                break;
            }
            if (wc) {
                week[0] = this.getNextValue(this.m_weekItemList, 1, 1, 53, selfCarry);
                cal.set(year[0], 0, 1);
                weekN[0] = cal.get(7);
                weekN[0] = this.getNextValue(this.m_weekNItemList, weekN[0], 1, 7, selfCarry);
            }
            selfCarry[0] = 1;
        } while (!this.isValidWeekNOfYear(year[0], week[0], weekN[0]));
        return result;
    }

    private boolean nextPattern6(int[] year, int[] quarter, int[] week, int[] weekN, int carry) {
        boolean result = true;
        int[] selfCarry = new int[]{carry};
        Calendar cal = Calendar.getInstance();
        do {
            cal.set(year[0], quarter[0] * 3, 1);
            int firstWeekN = cal.get(7);
            int oldWeekN = weekN[0];
            weekN[0] = this.getNextValue(this.m_weekNItemList, weekN[0] + selfCarry[0], 1, 7, selfCarry);
            if (weekN[0] < firstWeekN && oldWeekN >= firstWeekN) {
                selfCarry[0] = 0;
            } else if (weekN[0] >= firstWeekN && oldWeekN < firstWeekN) {
                selfCarry[0] = 1;
            }
            boolean wc = false;
            week[0] = this.getNextValue(this.m_weekItemList, week[0] + selfCarry[0], 1, TimerEntry.getWeeksOfQuarter(year[0], quarter[0]), selfCarry);
            if (selfCarry[0] != 0) {
                wc = true;
            }
            quarter[0] = this.getNextValue(this.m_quarterItemList, quarter[0] + selfCarry[0], 1, 4, selfCarry);
            if (selfCarry[0] != 0) {
                wc = true;
            }
            year[0] = this.getNextValue(this.m_yearItemList, year[0] + selfCarry[0], 2000, 2260, selfCarry);
            if (selfCarry[0] != 0) {
                result = false;
                break;
            }
            if (wc) {
                week[0] = this.getNextValue(this.m_weekItemList, 1, 1, 53, selfCarry);
                cal.set(year[0], quarter[0] * 3, 1);
                weekN[0] = cal.get(7);
                weekN[0] = this.getNextValue(this.m_weekNItemList, weekN[0], 1, 7, selfCarry);
            }
            selfCarry[0] = 1;
        } while (!this.isValidWeekNOfYear(year[0], week[0], weekN[0]));
        return result;
    }

    private boolean nextPattern7(int[] year, int[] quarter, int[] month, int[] week, int[] weekN, int carry) {
        boolean result = true;
        int[] selfCarry = new int[]{carry};
        Calendar cal = Calendar.getInstance();
        do {
            cal.set(year[0], (quarter[0] - 1) * 3 + month[0] - 1, 1);
            int firstWeekN = cal.get(7);
            int oldWeekN = weekN[0];
            weekN[0] = this.getNextValue(this.m_weekNItemList, weekN[0] + selfCarry[0], 1, 7, selfCarry);
            if (weekN[0] < firstWeekN && oldWeekN >= firstWeekN) {
                selfCarry[0] = 0;
            } else if (weekN[0] >= firstWeekN && oldWeekN < firstWeekN) {
                selfCarry[0] = 1;
            }
            boolean wc = false;
            week[0] = this.getNextValue(this.m_weekItemList, week[0] + selfCarry[0], 1, TimerEntry.getWeeksOfMonth(year[0], (quarter[0] - 1) * 3 + month[0]), selfCarry);
            if (selfCarry[0] != 0) {
                wc = true;
            }
            month[0] = this.getNextValue(this.m_monthItemList, month[0] + selfCarry[0], 1, 12, selfCarry);
            if (selfCarry[0] != 0) {
                wc = true;
            }
            quarter[0] = this.getNextValue(this.m_quarterItemList, quarter[0] + selfCarry[0], 1, 4, selfCarry);
            if (selfCarry[0] != 0) {
                wc = true;
            }
            year[0] = this.getNextValue(this.m_yearItemList, year[0] + selfCarry[0], 2000, 2260, selfCarry);
            if (selfCarry[0] != 0) {
                result = false;
                break;
            }
            if (wc) {
                week[0] = this.getNextValue(this.m_weekItemList, 1, 1, TimerEntry.getWeeksOfMonth(year[0], (quarter[0] - 1) * 3 + month[0]), selfCarry);
                cal.set(year[0], (quarter[0] - 1) * 3 + month[0] - 1, 1);
                weekN[0] = cal.get(7);
                weekN[0] = this.getNextValue(this.m_weekNItemList, weekN[0], 1, 7, selfCarry);
            }
            selfCarry[0] = 1;
        } while (!this.isValidWeekOfMonth(year[0], (quarter[0] - 1) * 3 + month[0], week[0], weekN[0]));
        return result;
    }

    private boolean nextPattern8(int[] year, int[] month, int[] week, int[] weekN, int carry) {
        boolean result = true;
        int[] selfCarry = new int[]{carry};
        Calendar cal = Calendar.getInstance();
        do {
            cal.set(year[0], month[0] - 1, 1);
            int firstWeekN = cal.get(7);
            int oldWeekN = weekN[0];
            weekN[0] = this.getNextValue(this.m_weekNItemList, weekN[0] + selfCarry[0], 1, 7, selfCarry);
            if (weekN[0] < firstWeekN && oldWeekN >= firstWeekN) {
                selfCarry[0] = 0;
            } else if (weekN[0] >= firstWeekN && oldWeekN < firstWeekN) {
                selfCarry[0] = 1;
            }
            boolean wc = false;
            week[0] = this.getNextValue(this.m_weekItemList, week[0] + selfCarry[0], 1, TimerEntry.getWeeksOfMonth(year[0], month[0]), selfCarry);
            if (selfCarry[0] != 0) {
                wc = true;
            }
            month[0] = this.getNextValue(this.m_monthItemList, month[0] + selfCarry[0], 1, 12, selfCarry);
            year[0] = this.getNextValue(this.m_yearItemList, year[0] + selfCarry[0], 2000, 2260, selfCarry);
            if (selfCarry[0] != 0) {
                result = false;
                break;
            }
            if (wc) {
                week[0] = this.getNextValue(this.m_weekItemList, 1, 1, TimerEntry.getWeeksOfMonth(year[0], month[0]), selfCarry);
                cal.set(year[0], month[0] - 1, 1);
                weekN[0] = cal.get(7);
                weekN[0] = this.getNextValue(this.m_weekNItemList, weekN[0], 1, 7, selfCarry);
            }
            selfCarry[0] = 1;
        } while (!this.isValidWeekOfMonth(year[0], month[0], week[0], weekN[0]));
        return result;
    }

    private boolean parse() {
        Object[] fields = StringTool.strToArray(this.m_express);
        if (!TimerEntry.validateFields(fields)) {
            this.m_status = 1;
            return false;
        }
        if (3 == fields.length) {
            boolean result = true;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            try {
                this.m_startTime = df.parse((String)fields[0]);
                this.m_cycle = Integer.parseInt((String)fields[1]);
                if ("d".equals(fields[2])) {
                    this.m_cycleUnit = 86400000;
                } else if ("h".equals(fields[2])) {
                    this.m_cycleUnit = 3600000;
                } else if ("m".equals(fields[2])) {
                    this.m_cycleUnit = 60000;
                } else {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
            }
            if (result) {
                this.m_type = 2;
            }
            return false;
        }
        if (9 == fields.length) {
            this.m_yearItemList = TimerEntry.parseField((String)fields[0]);
            if (this.m_yearItemList.size() == 0) {
                this.m_status = 1;
                this.m_yearItemList = null;
                return false;
            }
            this.m_quarterItemList = TimerEntry.parseField((String)fields[1]);
            if (this.m_quarterItemList.size() == 0) {
                this.m_status = 1;
                this.m_yearItemList = null;
                this.m_quarterItemList = null;
                return false;
            }
            this.m_monthItemList = TimerEntry.parseField((String)fields[2]);
            if (this.m_monthItemList.size() == 0) {
                this.m_status = 1;
                this.m_yearItemList = null;
                this.m_quarterItemList = null;
                this.m_monthItemList = null;
                return false;
            }
            this.m_dayItemList = TimerEntry.parseField((String)fields[3]);
            if (this.m_dayItemList.size() == 0) {
                this.m_status = 1;
                this.m_yearItemList = null;
                this.m_quarterItemList = null;
                this.m_monthItemList = null;
                this.m_dayItemList = null;
                return false;
            }
            this.m_weekItemList = TimerEntry.parseField((String)fields[4]);
            if (this.m_weekItemList.size() == 0) {
                this.m_status = 1;
                this.m_yearItemList = null;
                this.m_quarterItemList = null;
                this.m_monthItemList = null;
                this.m_dayItemList = null;
                this.m_weekItemList = null;
                return false;
            }
            this.m_weekNItemList = TimerEntry.parseField((String)fields[5]);
            if (this.m_weekNItemList.size() == 0) {
                this.m_status = 1;
                this.m_yearItemList = null;
                this.m_quarterItemList = null;
                this.m_monthItemList = null;
                this.m_dayItemList = null;
                this.m_weekItemList = null;
                this.m_weekNItemList = null;
                return false;
            }
            this.m_hourItemList = TimerEntry.parseField((String)fields[6]);
            if (this.m_hourItemList.size() == 0) {
                this.m_status = 1;
                this.m_yearItemList = null;
                this.m_quarterItemList = null;
                this.m_monthItemList = null;
                this.m_dayItemList = null;
                this.m_weekItemList = null;
                this.m_weekNItemList = null;
                this.m_hourItemList = null;
                return false;
            }
            this.m_minuteItemList = TimerEntry.parseField((String)fields[7]);
            if (this.m_minuteItemList.size() == 0) {
                this.m_status = 1;
                this.m_yearItemList = null;
                this.m_quarterItemList = null;
                this.m_monthItemList = null;
                this.m_dayItemList = null;
                this.m_weekItemList = null;
                this.m_weekNItemList = null;
                this.m_hourItemList = null;
                this.m_minuteItemList = null;
                return false;
            }
            this.m_type = 1;
            return true;
        }
        return false;
    }

    private void recognizePattern() {
        if (this.isIgnore(this.m_quarterItemList) && this.isIgnore(this.m_monthItemList) && !this.isIgnore(this.m_dayItemList)) {
            this.m_pattern = 1;
        } else if (!this.isIgnore(this.m_quarterItemList) && this.isIgnore(this.m_monthItemList) && !this.isIgnore(this.m_dayItemList)) {
            this.m_pattern = 2;
        } else if (!(this.isIgnore(this.m_quarterItemList) || this.isIgnore(this.m_monthItemList) || this.isIgnore(this.m_dayItemList))) {
            this.m_pattern = 3;
        } else if (this.isIgnore(this.m_quarterItemList) && !this.isIgnore(this.m_monthItemList) && !this.isIgnore(this.m_dayItemList)) {
            this.m_pattern = 4;
        } else if (this.isIgnore(this.m_quarterItemList) && this.isIgnore(this.m_monthItemList) && this.isIgnore(this.m_dayItemList) && !this.isIgnore(this.m_weekItemList) && !this.isIgnore(this.m_weekNItemList)) {
            this.m_pattern = 5;
        } else if (!this.isIgnore(this.m_quarterItemList) && this.isIgnore(this.m_monthItemList) && this.isIgnore(this.m_dayItemList) && !this.isIgnore(this.m_weekItemList) && !this.isIgnore(this.m_weekNItemList)) {
            this.m_pattern = 6;
        } else if (!(this.isIgnore(this.m_quarterItemList) || this.isIgnore(this.m_monthItemList) || !this.isIgnore(this.m_dayItemList) || this.isIgnore(this.m_weekItemList) || this.isIgnore(this.m_weekNItemList))) {
            this.m_pattern = 7;
        } else if (this.isIgnore(this.m_quarterItemList) && !this.isIgnore(this.m_monthItemList) && this.isIgnore(this.m_dayItemList) && !this.isIgnore(this.m_weekItemList) && !this.isIgnore(this.m_weekNItemList)) {
            this.m_pattern = 8;
        }
    }

    private static int getDayOfMonthFormDay(int year, int day) {
        int temp = day;
        int i = 1;
        while (i <= 11) {
            int days = TimerEntry.getDaysOfMonth(year, i);
            if (days >= temp) break;
            temp -= days;
            ++i;
        }
        return temp;
    }

    private static int getDayOfQuarter(int year, int month, int day) {
        if (3 == month) {
            return 31 + TimerEntry.getDaysOfMonth(year, 2) + day;
        }
        return daysForQuarterList[month] + day;
    }

    private static int getDaysOfQuarter(int year, int quarter) {
        if (1 == quarter) {
            return 62 + TimerEntry.getDaysOfMonth(year, 2);
        }
        if (2 == quarter) {
            return 91;
        }
        return 92;
    }

    private static int getDaysOfYear(int year) {
        return 337 + TimerEntry.getDaysOfMonth(year, 2);
    }

    private static int getDaysOfMonth(int year, int month) {
        if (2 != month) {
            return daysList[month];
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 100 == 0 && year % 400 == 0) {
            return 29;
        }
        return 28;
    }

    private static int getMonthFormDay(int year, int day) {
        int temp = day;
        int i = 1;
        while (i <= 11) {
            int days = TimerEntry.getDaysOfMonth(year, i);
            if (days < temp) {
                temp -= days;
            } else {
                return i;
            }
            ++i;
        }
        return 12;
    }

    private static int getWeeksOfMonth(int year, int month) {
        if (28 == TimerEntry.getDaysOfMonth(year, month)) {
            return 4;
        }
        return 5;
    }

    private static int getWeeksOfQuarter(int year, int quarter) {
        if (92 == TimerEntry.getDaysOfQuarter(year, quarter)) {
            return 14;
        }
        return 13;
    }

    private static ArrayList parseField(String field) {
        int status = 0;
        int length = field.length();
        StringBuffer str = new StringBuffer();
        ArrayList<TimerFieldItem> itemList = new ArrayList<TimerFieldItem>();
        int first = -1;
        int i = 0;
        while (i <= length) {
            char ch = '\u0000';
            ch = i < length ? field.charAt(i) : (char)'\u0000';
            switch (status) {
                case 0: {
                    if (Character.isDigit(ch) || '-' == ch) {
                        str.append(ch);
                        status = 2;
                        break;
                    }
                    if ('*' == ch || '?' == ch) {
                        if ('*' == ch) {
                            itemList.add(new TimerFieldItem(4, 0, 0));
                        } else {
                            itemList.add(new TimerFieldItem(5, 0, 0));
                        }
                        status = 1;
                        break;
                    }
                    status = 101;
                    break;
                }
                case 1: {
                    if (ch == '\u0000') {
                        status = 100;
                        break;
                    }
                    status = 101;
                    break;
                }
                case 2: {
                    if (Character.isDigit(ch) || str.length() == 0 && '-' == ch) {
                        str.append(ch);
                        break;
                    }
                    if (',' == ch && str.length() != 0) {
                        itemList.add(new TimerFieldItem(Integer.parseInt(str.toString())));
                        str.setLength(0);
                        break;
                    }
                    if ('-' == ch && str.length() != 0) {
                        first = Integer.parseInt(str.toString());
                        str.setLength(0);
                        if (first >= 0) {
                            status = 4;
                            break;
                        }
                        status = 101;
                        break;
                    }
                    if ('/' == ch && str.length() != 0) {
                        first = Integer.parseInt(str.toString());
                        str.setLength(0);
                        if (first >= 0) {
                            status = 6;
                            break;
                        }
                        status = 101;
                        break;
                    }
                    if (ch == '\u0000') {
                        itemList.add(new TimerFieldItem(Integer.parseInt(str.toString())));
                        str.setLength(0);
                        status = 100;
                        break;
                    }
                    status = 101;
                    break;
                }
                case 4: {
                    if (Character.isDigit(ch)) {
                        str.append(ch);
                        status = 5;
                        break;
                    }
                    status = 101;
                    break;
                }
                case 5: {
                    if (Character.isDigit(ch)) {
                        str.append(ch);
                        break;
                    }
                    if (',' == ch) {
                        itemList.add(new TimerFieldItem(2, first, Integer.parseInt(str.toString())));
                        str.setLength(0);
                        status = 2;
                        break;
                    }
                    if (ch == '\u0000') {
                        itemList.add(new TimerFieldItem(2, first, Integer.parseInt(str.toString())));
                        str.setLength(0);
                        status = 100;
                        break;
                    }
                    status = 101;
                    break;
                }
                case 6: {
                    if (Character.isDigit(ch)) {
                        str.append(ch);
                        status = 7;
                        break;
                    }
                    status = 101;
                    break;
                }
                case 7: {
                    if (Character.isDigit(ch)) {
                        str.append(ch);
                        break;
                    }
                    if (',' == ch) {
                        itemList.add(new TimerFieldItem(3, first, Integer.parseInt(str.toString())));
                        str.setLength(0);
                        status = 2;
                        break;
                    }
                    if (ch == '\u0000') {
                        itemList.add(new TimerFieldItem(3, first, Integer.parseInt(str.toString())));
                        str.setLength(0);
                        status = 100;
                        break;
                    }
                    status = 101;
                    break;
                }
            }
            ++i;
        }
        if (101 == status) {
            itemList.clear();
        }
        return itemList;
    }

    private static boolean validateFields(Object[] fields) {
        if (9 != fields.length && 3 != fields.length) {
            return false;
        }
        int i = 0;
        while (i < fields.length) {
            if (!(fields[i] instanceof String)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getNextExecTime(Date nowDate) {
        Calendar cal;
        Date date = null;
        if (1 == this.m_type) {
            cal = Calendar.getInstance();
            if (this.next(cal)) {
                date = cal.getTime();
            }
        } else if (2 == this.m_type) {
            cal = Calendar.getInstance();
            cal.setTime(nowDate);
            long now = cal.getTimeInMillis();
            cal.setTime(this.m_startTime);
            long start = cal.getTimeInMillis();
            if (start < now) {
                switch (this.m_cycleUnit) {
                    case 86400000: {
                        int days = (int)((now - start - 1000L) / (long)(this.m_cycle * 24 * 3600000) + 2L) * this.m_cycle;
                        cal.add(5, days);
                        date = cal.getTime();
                        break;
                    }
                    case 3600000: {
                        int hours = (int)((now - start - 1000L) / (long)(this.m_cycle * 3600000) + 2L) * this.m_cycle;
                        cal.add(11, hours);
                        date = cal.getTime();
                        break;
                    }
                    case 60000: {
                        int minutes = (int)((now - start - 1000L) / (long)(this.m_cycle * 60000) + 2L) * this.m_cycle;
                        cal.add(12, minutes);
                        date = cal.getTime();
                        break;
                    }
                    default: {
                        m_logger.error((Object)("Timer error, id: " + this.m_id + ", name: " + this.m_name + "."));
                    }
                }
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = df.format(date);
        return dateStr;
    }
}

