/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.base.messagecenter;

import com.sdjxd.pms.platform.base.MessageCenter;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.tool.BeanTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public final class MessageCenterDefaultImpl
implements MessageCenter {
    private static final Logger m_logger = Logger.getLogger(MessageCenterDefaultImpl.class);
    private final Map m_messageMap = new HashMap();
    private final Map m_messagePostMode = new HashMap();

    @Override
    public String callMessage(String messageName, String messageBody) {
        String ret = "";
        int postMode = this.getPostMode(messageName);
        switch (postMode) {
            case 1: 
            case 2: 
            case 3: {
                this.unicast(messageName, messageBody);
                break;
            }
            case 4: {
                ret = this.call(messageName, messageBody);
                break;
            }
            default: {
                m_logger.error((Object)("\u65e0\u6548\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b: " + postMode));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadConfiguration() {
        String sql2 = "select m.name, m.post_mode, r.funcname  from [S].jxd7_xt_mc_listen l inner join [S].jxd7_xt_mc_message m    on m.enabled = 1 and l.msg_id = m.msg_id    inner join [S].jxd7_xt_mc_receiver r    on r.enabled = 1 and l.rec_id = r.rec_id  where l.enabled = 1  order by l.sequence";
        try {
            RowSet rowSet = DbOper.executeQuery("defaultds", "select m.name, m.post_mode, r.funcname  from [S].jxd7_xt_mc_listen l inner join [S].jxd7_xt_mc_message m    on m.enabled = 1 and l.msg_id = m.msg_id    inner join [S].jxd7_xt_mc_receiver r    on r.enabled = 1 and l.rec_id = r.rec_id  where l.enabled = 1  order by l.sequence");
            Map map = this.m_messageMap;
            synchronized (map) {
                Map map2 = this.m_messagePostMode;
                synchronized (map2) {
                    this.m_messageMap.clear();
                    this.m_messagePostMode.clear();
                    while (rowSet.next()) {
                        String name = rowSet.getString("name");
                        String funcname = rowSet.getString("funcname");
                        int postMode = rowSet.getInt("post_mode");
                        this.addFunc(name, funcname);
                        this.addPostMode(name, postMode);
                    }
                }
            }
        }
        catch (SQLException e) {
            m_logger.error((Object)e);
        }
    }

    @Override
    public void sendMessage(String messageName, String messageBody) {
        int postMode = this.getPostMode(messageName);
        switch (postMode) {
            case 1: 
            case 4: {
                this.unicast(messageName, messageBody);
                break;
            }
            case 2: {
                this.chain(messageName, messageBody);
                break;
            }
            case 3: {
                this.broadcast(messageName, messageBody);
                break;
            }
            default: {
                m_logger.error((Object)("\u65e0\u6548\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b: " + postMode));
            }
        }
    }

    private void addFunc(String messageName, String messageFunc) {
        String[] func;
        if (messageName != null && messageFunc != null && messageName.length() != 0 && messageFunc.length() != 0 && (func = this.getFunc(messageFunc)) != null) {
            List list = this.createList(messageName);
            list.add(func);
        }
    }

    private void addPostMode(String messageName, int postMode) {
        Integer mode;
        if (messageName != null && messageName.length() != 0 && (mode = (Integer)this.m_messagePostMode.get(messageName)) == null) {
            if (postMode >= 1 && postMode <= 4) {
                this.m_messagePostMode.put(messageName, new Integer(postMode));
            } else {
                this.m_messagePostMode.put(messageName, new Integer(3));
            }
        }
    }

    private void broadcast(String messageName, String messageBody) {
        List list = this.getFuncList(messageName);
        Object[] args = new Object[]{messageName, messageBody};
        int i = 0;
        while (i < list.size()) {
            String[] func = (String[])list.get(i);
            try {
                BeanTool.invokeMethod(func[0], func[1], args);
            }
            catch (Exception e) {
                m_logger.error((Object)e);
            }
            ++i;
        }
    }

    private String call(String messageName, String messageBody) {
        List list = this.getFuncList(messageName);
        Object[] args = new Object[]{messageName, messageBody};
        String ret = "";
        if (!list.isEmpty()) {
            String[] func = (String[])list.get(0);
            try {
                Object result = BeanTool.invokeMethod(func[0], func[1], args);
                if (result instanceof String) {
                    ret = (String)result;
                }
            }
            catch (Exception e) {
                m_logger.error((Object)e);
            }
        }
        return ret;
    }

    private void chain(String messageName, String messageBody) {
        List list = this.getFuncList(messageName);
        Object[] args = new Object[]{messageName, messageBody};
        int i = 0;
        while (i < list.size()) {
            String[] func = (String[])list.get(i);
            try {
                Object result = BeanTool.invokeMethod(func[0], func[1], args);
                if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                    break;
                }
            }
            catch (Exception e) {
                m_logger.error((Object)e);
            }
            ++i;
        }
    }

    private List createList(String messageName) {
        ArrayList list = (ArrayList)this.m_messageMap.get(messageName);
        if (list == null) {
            list = new ArrayList();
            this.m_messageMap.put(messageName, list);
        }
        return list;
    }

    private String[] getFunc(String funcname) {
        int pos = funcname.lastIndexOf(46);
        String[] func = null;
        if (-1 != pos) {
            String className = funcname.substring(0, pos);
            String methodName = funcname.substring(pos + 1);
            func = new String[]{className, methodName};
        }
        return func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFuncList(String messageName) {
        Map map = this.m_messageMap;
        synchronized (map) {
            List list = (List)this.m_messageMap.get(messageName);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPostMode(String messageName) {
        Map map = this.m_messagePostMode;
        synchronized (map) {
            Integer mode = (Integer)this.m_messagePostMode.get(messageName);
            int postMode = 0;
            if (mode != null) {
                postMode = mode;
            }
            if (postMode < 1 || postMode > 4) {
                postMode = 3;
            }
            return postMode;
        }
    }

    private void unicast(String messageName, String messageBody) {
        List list = this.getFuncList(messageName);
        if (!list.isEmpty()) {
            String[] func = (String[])list.get(0);
            try {
                BeanTool.invokeMethod(func[0], func[1], new Object[]{messageName, messageBody});
            }
            catch (Exception e) {
                m_logger.error((Object)e);
            }
        }
    }
}

