/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.base.dao;

import com.sdjxd.pms.platform.data.DataSource;
import com.sdjxd.pms.platform.data.DbType;
import com.sdjxd.pms.platform.tool.BeanTool;

public class BaseDao {
    protected BaseDao() {
    }

    protected static BaseDao createInstance(Class daoClass) {
        return BaseDao.createInstance(daoClass, "defaultds");
    }

    protected static BaseDao createInstance(Class daoClass, String dataSourceName) {
        String className = daoClass.getName();
        String packageName = daoClass.getPackage().getName();
        className = className.substring(packageName.length());
        String classPath = packageName;
        DataSource dataSource = DataSource.getDataSource(dataSourceName);
        if (!DbType.SQL.equals(dataSource.getDbType())) {
            classPath = String.valueOf(classPath) + "." + dataSource.getDbType().getName();
        }
        Object dao = BeanTool.isExist(classPath = String.valueOf(classPath) + className) ? BeanTool.getInstance(classPath) : BeanTool.getInstance(daoClass);
        return (BaseDao)dao;
    }
}

