/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.base;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.base.SysConfig;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.SqlHelper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public final class PlatformLogger {
    public static final int CREATE = 1;
    public static final int SAVE = 2;
    public static final int DELETE = 3;
    public static final int COMMIT = 4;
    public static final int LOGIN = 5;
    public static final int LOGOUT = 6;
    public static final int MODIFYPASS = 7;
    public static final int EXCEEDACCESS = 8;
    public static final int SQLINJECTION = 9;
    public static final int USERROLEASSIGN = 10;
    public static final int USERROLECONFIRM = 11;
    public static final int ASSESSALLOW = 12;
    public static final int ASSESSBLOCK = 13;
    public static final int ROLEADD = 14;
    public static final int ROLEDELETE = 15;
    public static final int ROLEMODIFY = 16;
    public static final int USERADD = 17;
    public static final int USERDELETE = 18;
    public static final int USERMODIFY = 19;
    private static final int LAST = 19;
    private static final Logger m_logger = Logger.getLogger(PlatformLogger.class);
    private static final int[] statusList = new int[20];

    static {
        PlatformLogger.load();
    }

    public static void load() {
        String value = SysConfig.getInstance().getString("logcontent");
        String[] status = value.split(",");
        int i = 0;
        while (i <= 9) {
            PlatformLogger.statusList[i] = 0;
            ++i;
        }
        i = 0;
        while (i < status.length) {
            String str = status[i].trim();
            if ("CREATE".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[1] = 1;
            } else if ("SAVE".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[2] = 1;
            } else if ("DELETE".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[3] = 1;
            } else if ("COMMIT".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[4] = 1;
            } else if ("LOGIN".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[5] = 1;
            } else if ("LOGOUT".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[6] = 1;
            } else if ("MODIFYPASS".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[7] = 1;
            } else if ("EXCEEDACCESS".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[8] = 1;
            } else if ("SQLINJECTION".equalsIgnoreCase(str)) {
                PlatformLogger.statusList[9] = 1;
            }
            ++i;
        }
        String securityAudit = Global.getConfig("SECURITY_AUDIT");
        if ("true".equalsIgnoreCase(securityAudit)) {
            int i2 = 10;
            int leni = statusList.length;
            while (i2 < leni) {
                PlatformLogger.statusList[i2] = 1;
                ++i2;
            }
        }
    }

    public static void log(String mbid, String slid, String beizu, int type) {
        if (type <= 19 && 1 == statusList[type]) {
            User curUser = User.getCurrentUser();
            String curUserId = "";
            if (curUser != null) {
                curUserId = curUser.getId();
            }
            PlatformLogger.log(curUserId, mbid, slid, beizu, type);
        }
    }

    public static void log(String userId, String mbid, String slid, String beizu, int type) {
        if (type <= 19 && 1 == statusList[type]) {
            String sheetId = Guid.create();
            String curTime = DateTool.getNow();
            SqlHelper sqlHelper = new SqlHelper("insert into [S].jxd7_xt_log  (sheetid, createuserid, createdate, mbid, slid, bz, czlx)  values('{sheetid}', '{createuserid}', '{createdate}', '{mbid}', '{slid}', '{bz}', {czlx})");
            sqlHelper.setValue("sheetid", sheetId);
            sqlHelper.setValue("createuserid", userId);
            sqlHelper.setValue("createdate", curTime);
            sqlHelper.setValue("mbid", mbid);
            sqlHelper.setValue("slid", slid);
            sqlHelper.setValue("bz", beizu);
            sqlHelper.setValue("czlx", type);
            try {
                DbOper.executeNonQuery("defaultds", sqlHelper.getString());
            }
            catch (SQLException e) {
                m_logger.error((Object)e);
            }
        }
    }

    public static void log(Object obj) {
        User curUser = User.getCurrentUser();
        String curUserId = "";
        if (curUser != null) {
            curUserId = curUser.getId();
        }
        Object[] li = (Object[])obj;
        String curTime = DateTool.getNow();
        ArrayList<String> sqlArr = new ArrayList<String>();
        int i = 0;
        while (i < li.length) {
            String sheetId = Guid.create();
            Map map = (Map)li[i];
            String mbid = (String)map.get("mbid");
            String slid = (String)map.get("slid");
            String beizu = (String)map.get("beizu");
            String type = (String)map.get("typeId");
            SqlHelper sqlHelper = new SqlHelper("insert into [S].jxd7_xt_log  (sheetid, createuserid, createdate, mbid, slid, bz, czlx)  values('{sheetid}', '{createuserid}', '{createdate}', '{mbid}', '{slid}', '{bz}', {czlx})");
            sqlHelper.setValue("sheetid", sheetId);
            sqlHelper.setValue("createuserid", curUserId);
            sqlHelper.setValue("createdate", curTime);
            sqlHelper.setValue("mbid", mbid);
            sqlHelper.setValue("slid", slid);
            sqlHelper.setValue("bz", beizu);
            sqlHelper.setValue("czlx", type);
            sqlArr.add(sqlHelper.getString());
            ++i;
        }
        try {
            DbOper.executeNonQuery(sqlArr);
        }
        catch (SQLException e) {
            m_logger.error((Object)e);
        }
    }

    private PlatformLogger() {
    }
}

