/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.base;

import com.sdjxd.pms.platform.base.Global;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class MyEncodedProperties
extends Properties {
    private static final long serialVersionUID = -5198646494427187315L;
    private static final Logger m_logger = Logger.getLogger(MyEncodedProperties.class);
    private static int $_;

    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        value = this.decodeValue(value);
        if (1 == this.get$_()) {
            if ("jdbc.url".equals(key)) {
                value = this.decodeUrl(value);
            } else if ("jdbc.username".equals(key) || "jdbc.password".equals(key) || "db.schema".equals(key)) {
                value = this.decodeString(value);
            }
        }
        if (!"x-charset".equals(key) && value != null) {
            value = this.convertCharset(value);
        }
        return value;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(String filename) {
        InputStream inStream = MyEncodedProperties.getInStream(filename);
        if (inStream != null) {
            OutputStream outStream = null;
            try {
                try {
                    this.load(inStream);
                    if (!"true".equals(this.getProperty("x-encoding")) && !"true".equals(Global.getConfig("isJdbcEncode"))) return;
                    outStream = new FileOutputStream(String.valueOf(MyEncodedProperties.getAbsPath()) + "/WEB-INF/" + filename);
                    this.store(outStream, null);
                    return;
                }
                catch (IOException e) {
                    m_logger.error((Object)e.toString(), (Throwable)e);
                    try {
                        inStream.close();
                    }
                    catch (IOException e1) {
                        m_logger.error((Object)e1.toString(), (Throwable)e1);
                    }
                    if (outStream == null) return;
                    try {
                        outStream.close();
                        return;
                    }
                    catch (IOException e2) {
                        m_logger.error((Object)e2.toString(), (Throwable)e2);
                    }
                }
                return;
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException e1) {
                    m_logger.error((Object)e1.toString(), (Throwable)e1);
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e2) {
                        m_logger.error((Object)e2.toString(), (Throwable)e2);
                    }
                }
            }
        }
        m_logger.error((Object)"\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u6d41\u4e3a\u7a7a");
    }

    @Override
    public synchronized void store(OutputStream out, String comments) throws IOException {
        if ("true".equals(Global.getConfig("isJdbcEncode")) && this.get$_() != 1) {
            String url = super.getProperty("jdbc.url");
            url = this.encodeURL(url);
            this.setProperty("jdbc.url", url);
            String name = super.getProperty("jdbc.username");
            name = this.encodeString(name);
            this.setProperty("jdbc.username", name);
            String password = super.getProperty("jdbc.password");
            password = this.encodeString(password);
            this.setProperty("jdbc.password", password);
            String schema = super.getProperty("db.schema");
            schema = this.encodeString(schema);
            this.setProperty("db.schema", schema);
            $_ = 1;
            this.setProperty("$", "1");
        }
        if ("true".equals(this.getProperty("x-encoding"))) {
            Iterator<Map.Entry<Object, Object>> it = this.entrySet().iterator();
            BASE64Encoder encoder = new BASE64Encoder();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null || value.startsWith("++")) continue;
                value = encoder.encode(value.getBytes());
                this.setProperty(key, "++" + value);
            }
        }
        super.store(out, comments);
    }

    private String convertCharset(String value) {
        String str;
        String charset = this.getProperty("x-charset", "GBK");
        try {
            str = new String(value.getBytes("ISO8859_1"), charset);
        }
        catch (UnsupportedEncodingException e) {
            str = value;
        }
        return str;
    }

    private String decodeValue(String value) {
        String str = value;
        if (str != null && str.startsWith("++")) {
            str = str.substring(2);
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                byte[] dec = decoder.decodeBuffer(str);
                str = new String(dec);
            }
            catch (IOException e) {
                str = null;
            }
        }
        return str;
    }

    private static String getAbsPath() {
        return Global.getPath();
    }

    private static InputStream getInStream(String filename) {
        FileInputStream inStream;
        try {
            String allName = String.valueOf(MyEncodedProperties.getAbsPath()) + "/WEB-INF/" + filename;
            inStream = new FileInputStream(allName);
        }
        catch (FileNotFoundException e) {
            try {
                String allName = String.valueOf(MyEncodedProperties.getAbsPath()) + "/WEB-INF/classes/" + filename;
                inStream = new FileInputStream(allName);
                m_logger.warn((Object)"\u914d\u7f6e\u6587\u4ef6\u9700\u8981\u653e\u5728WEB-INF\u76ee\u5f55\u4e2d\u3002");
            }
            catch (FileNotFoundException e1) {
                try {
                    String allName = String.valueOf(MyEncodedProperties.getAbsPath()) + "/WEB-INF/classfactory/" + filename;
                    inStream = new FileInputStream(allName);
                    m_logger.warn((Object)"\u914d\u7f6e\u6587\u4ef6\u9700\u8981\u653e\u5728WEB-INF\u76ee\u5f55\u4e2d\u3002");
                }
                catch (FileNotFoundException e2) {
                    m_logger.warn((Object)("\u914d\u7f6e\u6587\u4ef6\"" + filename + "\"\u672a\u627e\u5230\u3002"));
                    inStream = null;
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            inStream = null;
        }
        return inStream;
    }

    private String encodeString(String name) {
        if (name != null && name.length() > 0) {
            char[] nameArr = name.toCharArray();
            int i = 0;
            while (i < nameArr.length) {
                nameArr[i] = this.encodeCharacter(nameArr[i]);
                ++i;
            }
            return new String(nameArr);
        }
        return "";
    }

    private String encodeURL(String url) {
        String ipOld = "";
        String ipNew = "";
        try {
            String[] ipOlds;
            Pattern pattern = Pattern.compile("(2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})");
            Matcher mat = pattern.matcher(url);
            if (mat.find() && (ipOlds = (ipOld = mat.group()).split("\\.")).length > 0) {
                int ipThrid = Integer.parseInt(ipOlds[2]) + 4;
                int ipFourth = Integer.parseInt(ipOlds[3]) - 14;
                if (ipThrid > 255) {
                    ipThrid -= 255;
                }
                if (ipFourth < 0) {
                    ipFourth = ipThrid + 255;
                }
                ipOlds[2] = String.valueOf(ipThrid);
                ipOlds[3] = String.valueOf(ipFourth);
                ipNew = MyEncodedProperties.converToString(ipOlds);
                url = url.replace(ipOld, ipNew);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return url;
    }

    private String decodeString(String name) {
        if (name != null && name.length() > 0) {
            char[] nameArr = name.toCharArray();
            int i = 0;
            while (i < nameArr.length) {
                nameArr[i] = this.decodeCharacter(nameArr[i]);
                ++i;
            }
            return new String(nameArr);
        }
        return "";
    }

    private String decodeUrl(String url) {
        String ipOld = "";
        String ipNew = "";
        try {
            String[] ipOlds;
            Pattern pattern = Pattern.compile("(2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})");
            Matcher mat = pattern.matcher(url);
            if (mat.find() && (ipOlds = (ipOld = mat.group()).split("\\.")).length > 0) {
                int ipThrid = Integer.parseInt(ipOlds[2]) - 4;
                int ipFourth = Integer.parseInt(ipOlds[3]) + 14;
                if (ipThrid < 0) {
                    ipThrid += 255;
                }
                if (ipFourth > 255) {
                    ipFourth = ipThrid - 255;
                }
                ipOlds[2] = String.valueOf(ipThrid);
                ipOlds[3] = String.valueOf(ipFourth);
                ipNew = MyEncodedProperties.converToString(ipOlds);
                url = url.replace(ipOld, ipNew);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return url;
    }

    private static String converToString(String[] ig) {
        String str = "";
        if (ig != null && ig.length > 0) {
            int i = 0;
            while (i < ig.length) {
                str = String.valueOf(str) + ig[i] + ".";
                ++i;
            }
        }
        str = str.substring(0, str.length() - 1);
        return str;
    }

    private char encodeCharacter(char character) {
        char asciiReplace = character;
        char ascii = character;
        if (ascii >= '0' && ascii <= '9') {
            asciiReplace = (char)(105 - ascii);
        }
        if (ascii >= 'A' && ascii <= 'Z') {
            asciiReplace = (char)(ascii + 5 > 90 ? ascii + 5 - 26 : ascii + 5);
        }
        if (ascii >= 'a' && ascii <= 'z') {
            asciiReplace = (char)(ascii + 5 > 122 ? ascii + 5 - 26 : ascii + 5);
        }
        return asciiReplace;
    }

    private char decodeCharacter(char character) {
        char asciiReplace = character;
        char ascii = character;
        if (ascii >= '0' && ascii <= '9') {
            asciiReplace = (char)(105 - ascii);
        }
        if (ascii >= 'A' && ascii <= 'Z') {
            asciiReplace = (char)(ascii - 5 < 65 ? ascii - 5 + 26 : ascii - 5);
        }
        if (ascii >= 'a' && ascii <= 'z') {
            asciiReplace = (char)(ascii - 5 < 97 ? ascii - 5 + 26 : ascii - 5);
        }
        return asciiReplace;
    }

    private int get$_() {
        if ($_ == 0) {
            $_ = "1".equals(this.decodeValue(super.getProperty("$"))) ? 1 : -1;
        }
        return $_;
    }
}

