/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.base;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ClassFactory {
    private static HashMap classMap;

    static {
        ClassFactory.init();
    }

    private static void init() {
        classMap = new HashMap();
        String filePath = String.valueOf(Global.getPath()) + "/WEB-INF/classfactory";
        File configDir = (File)BeanFactory.getClass("File", new String[]{filePath});
        File[] configs = configDir.listFiles();
        int i = 0;
        while (i < configs.length) {
            String proptertiesName = configs[i].getName();
            if (proptertiesName.endsWith(".properties")) {
                String productName = proptertiesName.substring(0, proptertiesName.length() - 10);
                Properties propertiesFile = Global.loadProperties("classfactory/" + proptertiesName);
                for (Map.Entry<Object, Object> entry : propertiesFile.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (StringTool.isEmpty(key)) continue;
                    classMap.put(String.valueOf(productName) + key, value);
                }
            }
            ++i;
        }
    }

    public static Object getInstance(String className) throws ClassNotFoundException {
        if (!classMap.containsKey(className)) {
            throw new ClassNotFoundException("\u672a\u627e\u5230\u7c7b\u8def\u5f84\uff1a" + className);
        }
        return BeanTool.getInstance((String)classMap.get(className));
    }

    public static Object getSingleInstance(String className) throws ClassNotFoundException {
        if (!classMap.containsKey(className)) {
            throw new ClassNotFoundException("\u672a\u627e\u5230\u7c7b\u8def\u5f84\uff1a" + className);
        }
        return BeanTool.getSingleInstance((String)classMap.get(className));
    }
}

