/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.Limit.service;

import com.sdjxd.pms.platform.Limit.bean.LimitBean;
import com.sdjxd.pms.platform.Limit.bean.LimitConsumer;
import com.sdjxd.pms.platform.Limit.bean.LimitTemplateBean;
import com.sdjxd.pms.platform.Limit.bean.ResouceBean;
import com.sdjxd.pms.platform.Limit.dao.LimitDao;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.ArrayList;
import java.util.List;

public class LimitCtrl {
    private static LimitDao _dao = null;
    private String _LimitId = "";
    private List _Parameters = null;
    private LimitBean _LimitBean = null;
    private List _ConsumerInfo = null;
    private List _ResouceInfo = null;

    public LimitCtrl() {
        if (_dao == null) {
            _dao = new LimitDao();
        }
    }

    public LimitCtrl(String h_LimitId, String[] h_Parameter) {
        this();
        this._LimitId = h_LimitId;
        if (h_Parameter != null && h_Parameter.length > 0) {
            this._Parameters = new ArrayList();
            int i = 0;
            while (i < h_Parameter.length) {
                this._Parameters.add(h_Parameter[i]);
                ++i;
            }
        }
        this.initInfo();
    }

    public boolean isInLimit() {
        boolean bResult = false;
        bResult = this.isInConsumer();
        if (!bResult) {
            return false;
        }
        bResult = this.isInResouce(null, null);
        return bResult;
    }

    public List getLimitData() {
        boolean bResult = false;
        ArrayList data = new ArrayList();
        bResult = this.isInConsumer();
        if (!bResult) {
            return null;
        }
        bResult = this.isInResouce(data, null);
        if (data.size() <= 0) {
            return null;
        }
        return data;
    }

    public List getLimitSql() {
        if (this._ResouceInfo.size() == 0) {
            return null;
        }
        if (((ResouceBean)this._ResouceInfo.get(0)).getLevelType() == 0) {
            return null;
        }
        boolean bResult = false;
        ArrayList<String> sql2 = new ArrayList<String>();
        bResult = this.isInConsumer();
        if (!bResult) {
            sql2.add("(1=2)");
            return sql2;
        }
        bResult = this.isInResouce(null, sql2);
        if (sql2.size() <= 0) {
            return null;
        }
        return sql2;
    }

    private boolean initInfo() {
        if (this._LimitId.length() != 36) {
            return false;
        }
        LimitTemplateBean limitTemplateBean = LimitTemplateBean.getLimitTemplateBean(this._LimitId);
        if (limitTemplateBean == null) {
            return false;
        }
        this._LimitBean = limitTemplateBean.getLimitBean();
        if (this._LimitBean == null) {
            return false;
        }
        this._ConsumerInfo = limitTemplateBean.getConsumerInfo();
        this._ResouceInfo = limitTemplateBean.getResouceInfo();
        return true;
    }

    private boolean isInConsumer() {
        if (this._ConsumerInfo == null) {
            return true;
        }
        if (this._ConsumerInfo.size() <= 0) {
            return true;
        }
        User user = User.getCurrentUser();
        int i = 0;
        while (i < this._ConsumerInfo.size()) {
            block10: {
                boolean bSuccess = false;
                LimitConsumer bean = (LimitConsumer)this._ConsumerInfo.get(i);
                int type = bean.getConsumerType();
                switch (type) {
                    case 0: {
                        bSuccess = _dao.isInSelDef(user, bean.getParameters());
                        break;
                    }
                    case 1: {
                        bSuccess = _dao.isInRoles(user, bean.getParameters());
                        break;
                    }
                    case 2: {
                        bSuccess = _dao.isInDep(user, bean.getParameters());
                        break;
                    }
                    case 3: {
                        bSuccess = this.isInUsers(user, bean.getParameters());
                        break;
                    }
                    default: {
                        break block10;
                    }
                }
                if (bSuccess) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isInResouce(List h_data, List h_sql) {
        if (this._ResouceInfo == null || this._ResouceInfo.size() == 0) {
            if (h_data != null) {
                h_data.add("1");
            }
            return true;
        }
        boolean bSuccess = false;
        int i = 0;
        while (i < this._ResouceInfo.size()) {
            block10: {
                boolean bResult = false;
                ResouceBean bean = (ResouceBean)this._ResouceInfo.get(i);
                int type = bean.getLevelType();
                String parameters = bean.getParameters();
                if (parameters.length() > 0) {
                    switch (type) {
                        case 0: {
                            bResult = true;
                            if (h_data == null) break;
                            h_data.add(parameters);
                            break;
                        }
                        case 1: {
                            Object[] jsonPara = StringTool.strToArray(parameters);
                            if (jsonPara == null || jsonPara.length != 2) break;
                            bResult = _dao.isHasResouce(this.getDataSourceName(), jsonPara[1], h_data, h_sql);
                            break;
                        }
                        case 2: {
                            bResult = true;
                            if (h_data == null) break;
                            h_data.add(parameters);
                            break;
                        }
                        default: {
                            break block10;
                        }
                    }
                    if (bResult) {
                        bSuccess = true;
                    }
                }
            }
            ++i;
        }
        return bSuccess;
    }

    private boolean isInUsers(User h_user, String h_parameters) {
        Object[] jsonUsers = StringTool.strToArray(h_parameters);
        if (jsonUsers != null) {
            String UserId = h_user.getId();
            int i = 0;
            while (i < jsonUsers.length) {
                Object[] oneUser = (Object[])jsonUsers[i];
                if (UserId.equals(oneUser[0])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getDataSourceName() {
        if (this._LimitBean != null) {
            return this._LimitBean.getDataSourceName();
        }
        return "";
    }
}

