/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.Limit.dao;

import com.sdjxd.pms.platform.Limit.bean.LimitConsumer;
import com.sdjxd.pms.platform.Limit.sql.UserLimitSql;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.tool.StringTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class UserLimitDao {
    private static Logger daoLogger = Logger.getLogger(UserLimitDao.class);
    private static UserLimitSql sqlHelper = new UserLimitSql();

    static List getLimit(String userID, String cousumerType) {
        int cousumerTypeInt = Integer.parseInt(cousumerType);
        ArrayList<String> limit = new ArrayList<String>();
        String sql2 = sqlHelper.getLimitSql(userID, cousumerTypeInt);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                limit.add(rs.getString("LIMITID"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return limit;
    }

    static List getLimitConsumerObject(String userID, String cousumerType) {
        int cousumerTypeInt = Integer.parseInt(cousumerType);
        ArrayList<LimitConsumer> limitConsumer = new ArrayList<LimitConsumer>();
        String sql2 = sqlHelper.getLimitConsumerObjectSql(userID, cousumerTypeInt);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                LimitConsumer lc = new LimitConsumer();
                lc.setLimitId(rs.getString("LIMITID"));
                lc.setShowOrder(Integer.parseInt(rs.getString("SHOWORDER")));
                lc.setConsumerType(cousumerTypeInt);
                lc.setParameters(rs.getString("PARAMETERS"));
                limitConsumer.add(lc);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return limitConsumer;
    }

    static boolean saveUserLimit(String[] userLimit, String cousumerType) {
        String sql2;
        String userID = userLimit[0];
        ArrayList<String> userLimitIDList = new ArrayList<String>();
        int i = 1;
        while (i < userLimit.length) {
            userLimitIDList.add(userLimit[i]);
            ++i;
        }
        int cousumerTypeInt = Integer.parseInt(cousumerType);
        List limitConsumerInDB = UserLimitDao.getLimitConsumerObject(userID, cousumerType);
        List limitIDInDB = UserLimitDao.getLimit(userID, cousumerType);
        int i2 = 0;
        while (i2 < limitConsumerInDB.size()) {
            LimitConsumer limitConsumer = (LimitConsumer)limitConsumerInDB.get(i2);
            if (!userLimitIDList.contains(limitConsumer.getLimitId())) {
                String[] parameters = (String[])StringTool.strToArray(limitConsumer.getParameters());
                if (parameters.length == 1 && parameters[0].equals(userID)) {
                    sql2 = sqlHelper.deleteLimitSql(limitConsumer.getLimitId(), limitConsumer.getShowOrder());
                    try {
                        DbOper.executeNonQuery("defaultds", sql2);
                    }
                    catch (SQLException e) {
                        daoLogger.error((Object)e.getMessage());
                    }
                } else if (parameters.length > 1) {
                    String[] temp = new String[parameters.length];
                    int len = 0;
                    int j = 0;
                    while (j < parameters.length) {
                        if (!parameters[j].equals(userID)) {
                            temp[len] = parameters[j];
                            ++len;
                        }
                        ++j;
                    }
                    Object[] newParameters = new String[len];
                    int j2 = 0;
                    while (j2 < len) {
                        newParameters[j2] = temp[j2];
                        ++j2;
                    }
                    sql2 = sqlHelper.updateLimitSql(limitConsumer.getLimitId(), limitConsumer.getShowOrder(), limitConsumer.getConsumerType(), StringTool.arrayToStr(newParameters));
                    try {
                        DbOper.executeNonQuery("defaultds", sql2);
                    }
                    catch (SQLException e) {
                        daoLogger.error((Object)e.getMessage());
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < userLimitIDList.size()) {
            String userLimitID = (String)userLimitIDList.get(i2);
            if (!limitIDInDB.contains(userLimitID)) {
                sql2 = sqlHelper.selectLimitSql(userLimitID, cousumerTypeInt);
                try {
                    RowSet rs = DbOper.executeQuery("defaultds", sql2);
                    if (rs.next()) {
                        String[] parameters = (String[])StringTool.strToArray(rs.getString("PARAMETERS"));
                        Object[] temp = new String[parameters.length + 1];
                        int j = 0;
                        while (j < parameters.length) {
                            temp[j] = parameters[j];
                            ++j;
                        }
                        temp[parameters.length] = userID;
                        sql2 = sqlHelper.updateLimitSql(userLimitID, Integer.parseInt(rs.getString("SHOWORDER")), cousumerTypeInt, StringTool.arrayToStr(temp));
                        try {
                            DbOper.executeNonQuery("defaultds", sql2);
                        }
                        catch (SQLException e) {
                            daoLogger.error((Object)e.getMessage());
                        }
                    } else {
                        sql2 = sqlHelper.insertLimitSql(userLimitID, cousumerTypeInt, userID);
                        try {
                            DbOper.executeNonQuery("defaultds", sql2);
                        }
                        catch (SQLException e) {
                            daoLogger.error((Object)e.getMessage());
                        }
                    }
                }
                catch (SQLException e) {
                    daoLogger.error((Object)e.getMessage());
                }
            }
            ++i2;
        }
        return true;
    }

    static List getUser(String userID) {
        ArrayList<String> limit = new ArrayList<String>();
        String sql2 = sqlHelper.getUserSqlByID(userID);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                limit.add(rs.getString("VNAME"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return limit;
    }

    static List getIsSaveThisLimit(String moduleID) {
        ArrayList userGroup = new ArrayList();
        HashMap<String, String> map = null;
        String sql2 = sqlHelper.getIsSaveThisLimitSql(moduleID);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                map = new HashMap<String, String>();
                map.put("SHEETID", rs.getString("SHEETID"));
                map.put("GROUPID", rs.getString("GROUPID"));
                map.put("USERID", rs.getString("USERID"));
                map.put("USERTYPE", rs.getString("USERTYPE"));
                userGroup.add(map);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return userGroup;
    }

    static List getIsSaveThisLimitByGroupId(String groupID) {
        ArrayList userGroup = new ArrayList();
        HashMap<String, String> map = null;
        String sql2 = sqlHelper.getIsSaveThisLimitByGroupSql(groupID);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                map = new HashMap<String, String>();
                map.put("SHEETID", rs.getString("SHEETID"));
                map.put("GROUPID", rs.getString("GROUPID"));
                map.put("USERID", rs.getString("USERID"));
                map.put("USERTYPE", rs.getString("USERTYPE"));
                userGroup.add(map);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return userGroup;
    }

    static List getGroupAndUserNameByID(String groupID, String userID) {
        ArrayList<String> name = new ArrayList<String>();
        String sql2 = null;
        sql2 = sqlHelper.getGroupAndUserNameByIDSql(groupID, userID);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                name.add(rs.getString("GROUPNAME"));
                name.add(rs.getString("VNAME"));
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return null;
        }
        return name;
    }

    static boolean getIsSaveThisUserGroup(String groupID, String userID) {
        String sql2 = sqlHelper.getIsSaveThisUserGroupSql(groupID, userID);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            return rs.next();
        }
        catch (SQLException e) {
            daoLogger.error((Object)e.getMessage());
            return false;
        }
    }
}

