/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.Limit.dao;

import com.sdjxd.pms.platform.Limit.bean.LimitBean;
import com.sdjxd.pms.platform.Limit.bean.LimitConsumer;
import com.sdjxd.pms.platform.Limit.bean.ResouceBean;
import com.sdjxd.pms.platform.Limit.sql.LimitSql;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.StringTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class LimitDao {
    private static Logger daoLogger = Logger.getLogger((String)"LimitCtrl");
    private static LimitSql _sqlHelper = null;

    public LimitDao() {
        if (_sqlHelper == null) {
            _sqlHelper = new LimitSql();
        }
    }

    public LimitBean getLimitInfo(String h_LimitId) {
        if (h_LimitId.length() != 36) {
            return null;
        }
        LimitBean limit = null;
        String sql2 = _sqlHelper.getLimitSql(h_LimitId);
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null && rs.next()) {
                limit = new LimitBean();
                limit.setLimitId(rs.getString("LIMITID"));
                limit.setLimitName(rs.getString("LIMITNAME"));
                limit.setTableId(rs.getString("TABLEID"));
                limit.setBeiZhu(rs.getString("BEIZHU"));
                limit.setDataSourceName(rs.getString("DATASOURCENAME"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
            return null;
        }
        return limit;
    }

    public List getLimitConsumerInfo(String h_LimitId) {
        ArrayList<LimitConsumer> arrBean = null;
        try {
            String sql2 = _sqlHelper.getLimitConsumerSql(h_LimitId);
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null) {
                arrBean = new ArrayList<LimitConsumer>();
                while (rs.next()) {
                    LimitConsumer bean = new LimitConsumer();
                    bean.setLimitId(rs.getString("LIMITID"));
                    bean.setConsumerType(rs.getInt("CONSUMERTYPE"));
                    bean.setParameters(rs.getString("PARAMETERS"));
                    arrBean.add(bean);
                }
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
            return null;
        }
        return arrBean;
    }

    public List getLimitResouceInfo(String h_LimitId) {
        ArrayList<ResouceBean> arrBean = null;
        try {
            String sql2 = _sqlHelper.getLimitResouceSql(h_LimitId);
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs != null) {
                arrBean = new ArrayList<ResouceBean>();
                while (rs.next()) {
                    ResouceBean bean = new ResouceBean();
                    bean.setResouceId(rs.getString("RESOURCEID"));
                    bean.setResouceName(rs.getString("RESOURCENAME"));
                    bean.setLevelType(rs.getInt("LEVELTYPE"));
                    bean.setParameters(rs.getString("PARAMETERS"));
                    bean.setBeizhu(rs.getString("BEIZHU"));
                    arrBean.add(bean);
                }
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
            return null;
        }
        return arrBean;
    }

    public boolean isInRoles(User h_user, String h_parameters) {
        Object[] jsonRoles = StringTool.strToArray(h_parameters);
        if (jsonRoles != null) {
            StringBuffer roles = new StringBuffer();
            int i = 0;
            while (i < jsonRoles.length) {
                roles.append(",'").append(jsonRoles[i]).append("'");
                ++i;
            }
            if (roles.length() > 1) {
                String sql2 = _sqlHelper.getRoleUserSql(h_user.getId(), roles.substring(1));
                try {
                    RowSet rs = DbOper.executeQuery("defaultds", sql2);
                    if (rs != null && rs.next()) {
                        return true;
                    }
                }
                catch (SQLException exp) {
                    daoLogger.error((Object)exp);
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isInSelDef(User h_user, String h_parameters) {
        String sqlTable = "[S].JXD7_XT_USER U";
        String sqlCondition = "";
        Object[] jsonPara = StringTool.strToArray(h_parameters);
        if (jsonPara != null) {
            Object[] tableInfo = (Object[])jsonPara[0];
            int i = 0;
            while (i < tableInfo.length) {
                Object[] oneTable = (Object[])tableInfo[i];
                if (oneTable[0] != null && oneTable[0].toString().length() != 0 || oneTable[1] != null && oneTable[1].toString().length() != 0) {
                    sqlTable = String.valueOf(sqlTable) + ", " + oneTable[0] + " " + oneTable[1];
                }
                ++i;
            }
            sqlCondition = StringTool.replaceKeyWord(this.getConditonWithJson(jsonPara[1]));
        }
        try {
            String sql2 = _sqlHelper.getSelDefSql(h_user.getId(), sqlTable, sqlCondition);
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            return rs != null && rs.next();
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
            return false;
        }
    }

    public boolean isInDep(User h_user, String h_parameters) {
        Object[] jsonDepts = StringTool.strToArray(h_parameters);
        if (jsonDepts != null) {
            StringBuffer depts = new StringBuffer();
            int i = 0;
            while (i < jsonDepts.length) {
                depts.append(",'").append(jsonDepts[i]).append("'");
                ++i;
            }
            if (depts.length() > 1) {
                String sql2 = _sqlHelper.getDeptUserSql(h_user.getId(), depts.substring(1));
                try {
                    RowSet rs = DbOper.executeQuery("defaultds", sql2);
                    if (rs != null && rs.next()) {
                        return true;
                    }
                }
                catch (SQLException exp) {
                    daoLogger.error((Object)exp);
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isHasResouce(String dataSourceName, Object h_para, List h_data, List h_sql) {
        RowSet rs;
        String[] fields;
        boolean bSuccess;
        block8: {
            Object[] arrPara = (Object[])h_para;
            if (arrPara == null || arrPara.length != 3) {
                return false;
            }
            String table = "";
            String field = "";
            String condition = "";
            bSuccess = false;
            field = (String)arrPara[0];
            table = (String)arrPara[1];
            condition = StringTool.replaceKeyWord((String)arrPara[2]);
            if (h_sql != null) {
                h_sql.add(condition);
            }
            if (h_data == null) {
                return true;
            }
            fields = field.split(",");
            String sql2 = _sqlHelper.getResouceData(field, table, condition);
            rs = DbOper.executeQuery(dataSourceName, sql2);
            if (rs != null && rs.next()) break block8;
            return false;
        }
        try {
            bSuccess = true;
            ArrayList datas = new ArrayList();
            rs.previous();
            while (rs.next()) {
                TreeMap<String, String> rowData = new TreeMap<String, String>();
                int i = 0;
                while (i < fields.length) {
                    String fieldName = fields[i];
                    fieldName = fieldName.trim();
                    rowData.put(fieldName, rs.getString(fieldName));
                    ++i;
                }
                datas.add(rowData);
            }
            h_data.add(datas);
        }
        catch (SQLException exp) {
            daoLogger.error((Object)exp);
            return false;
        }
        return bSuccess;
    }

    public String getConditonWithJson(Object h_condition) {
        if (h_condition instanceof String) {
            String condition = "";
            condition = "(" + (String)h_condition + ")";
            return condition;
        }
        Object[] arrCon = (Object[])h_condition;
        if (arrCon[0] instanceof String && "AND".equals(arrCon[0]) || "OR".equals(arrCon[0])) {
            String condition = "";
            String strRalation = (String)arrCon[0];
            int i = 1;
            while (i < arrCon.length) {
                String temp = this.getConditonWithJson(arrCon[i]);
                if (temp.length() >= 2) {
                    condition = String.valueOf(condition) + " " + strRalation + " ";
                    condition = String.valueOf(condition) + temp;
                }
                ++i;
            }
            if (condition.length() < 2 * (strRalation.length() + 2)) {
                return "";
            }
            return "(" + condition.substring(strRalation.length() + 2) + ")";
        }
        String condition = "";
        int i = 0;
        while (i < arrCon.length) {
            condition = String.valueOf(condition) + " AND ";
            String temp = this.getConditonWithJson(arrCon[i]);
            if (temp.length() < 2) {
                return "";
            }
            condition = String.valueOf(condition) + temp;
            ++i;
        }
        return condition.substring(5);
    }
}

