/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.locale.BaseLocaleConverter;

public class StringLocaleConverter
extends BaseLocaleConverter {
    public StringLocaleConverter() {
        this(false);
    }

    public StringLocaleConverter(boolean bl) {
        this(Locale.getDefault(), bl);
    }

    public StringLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public StringLocaleConverter(Locale locale, boolean bl) {
        this(locale, (String)null, bl);
    }

    public StringLocaleConverter(Locale locale, String string) {
        this(locale, string, false);
    }

    public StringLocaleConverter(Locale locale, String string, boolean bl) {
        super(locale, string, bl);
    }

    public StringLocaleConverter(Object object) {
        this(object, false);
    }

    public StringLocaleConverter(Object object, boolean bl) {
        this(object, Locale.getDefault(), bl);
    }

    public StringLocaleConverter(Object object, Locale locale) {
        this(object, locale, false);
    }

    public StringLocaleConverter(Object object, Locale locale, boolean bl) {
        this(object, locale, null, bl);
    }

    public StringLocaleConverter(Object object, Locale locale, String string) {
        this(object, locale, string, false);
    }

    public StringLocaleConverter(Object object, Locale locale, String string, boolean bl) {
        super(object, locale, string, bl);
    }

    protected Object parse(Object object, String string) throws ParseException {
        String string2 = null;
        if (object instanceof Integer || object instanceof Long || object instanceof BigInteger || object instanceof Byte || object instanceof Short) {
            string2 = this.getDecimalFormat(this.locale, string).format(((Number)object).longValue());
        } else if (object instanceof Double || object instanceof BigDecimal || object instanceof Float) {
            string2 = this.getDecimalFormat(this.locale, string).format(((Number)object).doubleValue());
        } else if (object instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, this.locale);
            string2 = simpleDateFormat.format(object);
        } else {
            string2 = object.toString();
        }
        return string2;
    }

    private DecimalFormat getDecimalFormat(Locale locale, String string) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        if (this.locPattern) {
            decimalFormat.applyLocalizedPattern(string);
        } else {
            decimalFormat.applyPattern(string);
        }
        return decimalFormat;
    }
}

