/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.beanutils.locale.BaseLocaleConverter;

public class DateLocaleConverter
extends BaseLocaleConverter {
    private SimpleDateFormat formatter;

    public DateLocaleConverter() {
        this(false);
    }

    public DateLocaleConverter(boolean bl) {
        this(Locale.getDefault(), bl);
    }

    public DateLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public DateLocaleConverter(Locale locale, boolean bl) {
        this(locale, (String)null, bl);
    }

    public DateLocaleConverter(Locale locale, String string) {
        this(locale, string, false);
    }

    public DateLocaleConverter(Locale locale, String string, boolean bl) {
        super(locale, string, bl);
        this.formatter = new SimpleDateFormat(this.pattern, this.locale);
    }

    public DateLocaleConverter(Object object) {
        this(object, false);
    }

    public DateLocaleConverter(Object object, boolean bl) {
        this(object, Locale.getDefault(), bl);
    }

    public DateLocaleConverter(Object object, Locale locale) {
        this(object, locale, false);
    }

    public DateLocaleConverter(Object object, Locale locale, boolean bl) {
        this(object, locale, null, bl);
    }

    public DateLocaleConverter(Object object, Locale locale, String string) {
        this(object, locale, string, false);
    }

    public DateLocaleConverter(Object object, Locale locale, String string, boolean bl) {
        super(object, locale, string, bl);
        this.formatter = new SimpleDateFormat(this.pattern, this.locale);
    }

    public boolean isLenient() {
        return this.formatter.isLenient();
    }

    public void setLenient(boolean bl) {
        this.formatter.setLenient(bl);
    }

    protected Object parse(Object object, String string) throws ParseException {
        if (this.locPattern) {
            this.formatter.applyLocalizedPattern(string);
        } else {
            this.formatter.applyPattern(string);
        }
        return this.formatter.parse((String)object);
    }
}

