/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.lang.reflect.Array;
import java.util.Locale;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import org.apache.commons.beanutils.locale.converters.StringLocaleConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleConvertUtils {
    private static Locale defaultLocale = Locale.getDefault();
    private static boolean applyLocalized = false;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$locale$LocaleConvertUtils == null ? (class$org$apache$commons$beanutils$locale$LocaleConvertUtils = LocaleConvertUtils.class$("org.apache.commons.beanutils.locale.LocaleConvertUtils")) : class$org$apache$commons$beanutils$locale$LocaleConvertUtils));
    private static FastHashMap mapConverters = new FastHashMap();
    static /* synthetic */ Class class$org$apache$commons$beanutils$locale$LocaleConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale locale) {
        defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    public static boolean getApplyLocalized() {
        return applyLocalized;
    }

    public static void setApplyLocalized(boolean bl) {
        applyLocalized = bl;
    }

    public static String convert(Object object) {
        return LocaleConvertUtils.convert(object, defaultLocale, null);
    }

    public static String convert(Object object, String string) {
        return LocaleConvertUtils.convert(object, defaultLocale, string);
    }

    public static String convert(Object object, Locale locale, String string) {
        LocaleConverter localeConverter = LocaleConvertUtils.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtils.class$("java.lang.String")) : class$java$lang$String, locale);
        return (String)localeConverter.convert(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtils.class$("java.lang.String")) : class$java$lang$String, object, string);
    }

    public static Object convert(String string, Class clazz) {
        return LocaleConvertUtils.convert(string, clazz, defaultLocale, null);
    }

    public static Object convert(String string, Class clazz, String string2) {
        return LocaleConvertUtils.convert(string, clazz, defaultLocale, string2);
    }

    public static Object convert(String string, Class clazz, Locale locale, String string2) {
        LocaleConverter localeConverter;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Convert string " + string + " to class " + clazz.getName() + " using " + locale.toString() + " locale and " + string2 + " pattern"));
        }
        if ((localeConverter = LocaleConvertUtils.lookup(clazz, locale)) == null) {
            localeConverter = LocaleConvertUtils.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtils.class$("java.lang.String")) : class$java$lang$String, locale);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Using converter " + localeConverter));
        }
        return localeConverter.convert(clazz, string, string2);
    }

    public static Object convert(String[] stringArray, Class clazz, String string) {
        return LocaleConvertUtils.convert(stringArray, clazz, LocaleConvertUtils.getDefaultLocale(), string);
    }

    public static Object convert(String[] stringArray, Class clazz, Locale locale, String string) {
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Convert String[" + stringArray.length + "] to class " + clazz2.getName() + "[] using " + locale.toString() + " locale and " + string + " pattern"));
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            Array.set(object, n, LocaleConvertUtils.convert(stringArray[n], clazz2, locale, string));
            ++n;
        }
        return object;
    }

    public static void register(LocaleConverter localeConverter, Class clazz, Locale locale) {
        LocaleConvertUtils.lookup(locale).put((Object)clazz, (Object)localeConverter);
    }

    public static void deregister() {
        FastHashMap fastHashMap = LocaleConvertUtils.lookup(defaultLocale);
        mapConverters.setFast(false);
        mapConverters.clear();
        mapConverters.put((Object)defaultLocale, (Object)fastHashMap);
        mapConverters.setFast(true);
    }

    public static void deregister(Locale locale) {
        mapConverters.remove((Object)locale);
    }

    public static void deregister(Class clazz, Locale locale) {
        LocaleConvertUtils.lookup(locale).remove((Object)clazz);
    }

    public static LocaleConverter lookup(Class clazz, Locale locale) {
        return (LocaleConverter)LocaleConvertUtils.lookup(locale).get((Object)clazz);
    }

    protected static FastHashMap lookup(Locale locale) {
        FastHashMap fastHashMap;
        if (locale == null) {
            fastHashMap = (FastHashMap)mapConverters.get((Object)defaultLocale);
        } else {
            fastHashMap = (FastHashMap)mapConverters.get((Object)locale);
            if (fastHashMap == null) {
                fastHashMap = LocaleConvertUtils.create(locale);
                mapConverters.put((Object)locale, (Object)fastHashMap);
            }
        }
        return fastHashMap;
    }

    protected static FastHashMap create(Locale locale) {
        FastHashMap fastHashMap = new FastHashMap();
        fastHashMap.setFast(false);
        fastHashMap.put((Object)(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = LocaleConvertUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal), (Object)new BigDecimalLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$math$BigInteger == null ? (class$java$math$BigInteger = LocaleConvertUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger), (Object)new BigIntegerLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$lang$Byte == null ? (class$java$lang$Byte = LocaleConvertUtils.class$("java.lang.Byte")) : class$java$lang$Byte), (Object)new ByteLocaleConverter(locale, applyLocalized));
        fastHashMap.put(Byte.TYPE, (Object)new ByteLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$lang$Double == null ? (class$java$lang$Double = LocaleConvertUtils.class$("java.lang.Double")) : class$java$lang$Double), (Object)new DoubleLocaleConverter(locale, applyLocalized));
        fastHashMap.put(Double.TYPE, (Object)new DoubleLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$lang$Float == null ? (class$java$lang$Float = LocaleConvertUtils.class$("java.lang.Float")) : class$java$lang$Float), (Object)new FloatLocaleConverter(locale, applyLocalized));
        fastHashMap.put(Float.TYPE, (Object)new FloatLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = LocaleConvertUtils.class$("java.lang.Integer")) : class$java$lang$Integer), (Object)new IntegerLocaleConverter(locale, applyLocalized));
        fastHashMap.put(Integer.TYPE, (Object)new IntegerLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$lang$Long == null ? (class$java$lang$Long = LocaleConvertUtils.class$("java.lang.Long")) : class$java$lang$Long), (Object)new LongLocaleConverter(locale, applyLocalized));
        fastHashMap.put(Long.TYPE, (Object)new LongLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$lang$Short == null ? (class$java$lang$Short = LocaleConvertUtils.class$("java.lang.Short")) : class$java$lang$Short), (Object)new ShortLocaleConverter(locale, applyLocalized));
        fastHashMap.put(Short.TYPE, (Object)new ShortLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtils.class$("java.lang.String")) : class$java$lang$String), (Object)new StringLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$sql$Date == null ? (class$java$sql$Date = LocaleConvertUtils.class$("java.sql.Date")) : class$java$sql$Date), (Object)new SqlDateLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$sql$Time == null ? (class$java$sql$Time = LocaleConvertUtils.class$("java.sql.Time")) : class$java$sql$Time), (Object)new SqlTimeLocaleConverter(locale, applyLocalized));
        fastHashMap.put((Object)(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = LocaleConvertUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp), (Object)new SqlTimestampLocaleConverter(locale, applyLocalized));
        fastHashMap.setFast(true);
        return fastHashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LocaleConvertUtils.deregister();
    }
}

