/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.LocaleConverter;

public abstract class BaseLocaleConverter
implements LocaleConverter {
    private Object defaultValue = null;
    protected boolean useDefault = false;
    protected Locale locale = Locale.getDefault();
    protected String pattern = null;
    protected boolean locPattern = false;

    protected BaseLocaleConverter(Locale locale, String string) {
        this(null, locale, string, false, false);
    }

    protected BaseLocaleConverter(Locale locale, String string, boolean bl) {
        this(null, locale, string, false, bl);
    }

    protected BaseLocaleConverter(Object object, Locale locale, String string) {
        this(object, locale, string, false);
    }

    protected BaseLocaleConverter(Object object, Locale locale, String string, boolean bl) {
        this(object, locale, string, true, bl);
    }

    private BaseLocaleConverter(Object object, Locale locale, String string, boolean bl, boolean bl2) {
        if (bl) {
            this.defaultValue = object;
            this.useDefault = true;
        }
        if (locale != null) {
            this.locale = locale;
        }
        this.pattern = string;
        this.locPattern = bl2;
    }

    protected abstract Object parse(Object var1, String var2) throws ParseException;

    public Object convert(Object object) {
        return this.convert(object, null);
    }

    public Object convert(Object object, String string) {
        return this.convert(null, object, string);
    }

    public Object convert(Class clazz, Object object) {
        return this.convert(clazz, object, null);
    }

    public Object convert(Class clazz, Object object, String string) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        try {
            if (string != null) {
                return this.parse(object, string);
            }
            return this.parse(object, this.pattern);
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(exception);
        }
    }
}

