/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class ShortArrayConverter
extends AbstractArrayConverter {
    private static short[] model = new short[0];

    public ShortArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ShortArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (AbstractArrayConverter.strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                short[] sArray = new short[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    sArray[n] = Short.parseShort(stringArray[n]);
                    ++n;
                }
                return sArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            short[] sArray = new short[list.size()];
            int n = 0;
            while (n < sArray.length) {
                sArray[n] = Short.parseShort((String)list.get(n));
                ++n;
            }
            return sArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

