/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class FloatArrayConverter
extends AbstractArrayConverter {
    private static float[] model = new float[0];

    public FloatArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public FloatArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (AbstractArrayConverter.strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                float[] fArray = new float[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    fArray[n] = Float.parseFloat(stringArray[n]);
                    ++n;
                }
                return fArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            float[] fArray = new float[list.size()];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = Float.parseFloat((String)list.get(n));
                ++n;
            }
            return fArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

