/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class ByteArrayConverter
extends AbstractArrayConverter {
    private static byte[] model = new byte[0];

    public ByteArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ByteArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (AbstractArrayConverter.strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                byte[] byArray = new byte[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    byArray[n] = Byte.parseByte(stringArray[n]);
                    ++n;
                }
                return byArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            byte[] byArray = new byte[list.size()];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = Byte.parseByte((String)list.get(n));
                ++n;
            }
            return byArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

