/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class RowSetDynaClass
implements DynaClass,
Serializable {
    protected boolean lowerCase = true;
    protected DynaProperty[] properties = null;
    protected Map propertiesMap = new HashMap();
    protected List rows = new ArrayList();
    static /* synthetic */ Class class$java$lang$Object;

    public RowSetDynaClass(ResultSet resultSet) throws SQLException {
        this(resultSet, true);
    }

    public RowSetDynaClass(ResultSet resultSet, boolean bl) throws SQLException {
        if (resultSet == null) {
            throw new NullPointerException();
        }
        this.lowerCase = bl;
        this.introspect(resultSet);
        this.copy(resultSet);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public DynaProperty getDynaProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(string);
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    public List getRows() {
        return this.rows;
    }

    protected void copy(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            BasicDynaBean basicDynaBean = new BasicDynaBean(this);
            int n = 0;
            while (n < this.properties.length) {
                String string = this.properties[n].getName();
                basicDynaBean.set(string, resultSet.getObject(string));
                ++n;
            }
            this.rows.add(basicDynaBean);
        }
    }

    protected void introspect(ResultSet resultSet) throws SQLException {
        ArrayList<DynaProperty> arrayList = new ArrayList<DynaProperty>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            DynaProperty dynaProperty = this.createDynaProperty(resultSetMetaData, n2);
            if (dynaProperty != null) {
                arrayList.add(dynaProperty);
            }
            ++n2;
        }
        this.properties = arrayList.toArray(new DynaProperty[arrayList.size()]);
        int n3 = 0;
        while (n3 < this.properties.length) {
            this.propertiesMap.put(this.properties[n3].getName(), this.properties[n3]);
            ++n3;
        }
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        Class clazz;
        String string = null;
        string = this.lowerCase ? resultSetMetaData.getColumnName(n).toLowerCase() : resultSetMetaData.getColumnName(n);
        String string2 = null;
        try {
            string2 = resultSetMetaData.getColumnClassName(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = RowSetDynaClass.class$("java.lang.Object")) : class$java$lang$Object;
        if (string2 != null) {
            clazz = this.loadClass(string2);
        }
        return new DynaProperty(string, clazz);
    }

    protected Class loadClass(String string) throws SQLException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            return classLoader.loadClass(string);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot load column class '" + string + "': " + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

