/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.ResultSetIterator;

public class ResultSetDynaClass
implements DynaClass {
    protected boolean lowerCase = true;
    protected DynaProperty[] properties = null;
    protected HashMap propertiesMap = new HashMap();
    protected ResultSet resultSet = null;
    static /* synthetic */ Class class$java$lang$Object;

    public ResultSetDynaClass(ResultSet resultSet) throws SQLException {
        this(resultSet, true);
    }

    public ResultSetDynaClass(ResultSet resultSet, boolean bl) throws SQLException {
        if (resultSet == null) {
            throw new NullPointerException();
        }
        this.resultSet = resultSet;
        this.lowerCase = bl;
        this.introspect();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public DynaProperty getDynaProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(string);
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    public Iterator iterator() {
        return new ResultSetIterator(this);
    }

    ResultSet getResultSet() {
        return this.resultSet;
    }

    protected void introspect() throws SQLException {
        ArrayList<DynaProperty> arrayList = new ArrayList<DynaProperty>();
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            DynaProperty dynaProperty = this.createDynaProperty(resultSetMetaData, n2);
            if (dynaProperty != null) {
                arrayList.add(dynaProperty);
            }
            ++n2;
        }
        this.properties = arrayList.toArray(new DynaProperty[arrayList.size()]);
        int n3 = 0;
        while (n3 < this.properties.length) {
            this.propertiesMap.put(this.properties[n3].getName(), this.properties[n3]);
            ++n3;
        }
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        Class clazz;
        String string = null;
        string = this.lowerCase ? resultSetMetaData.getColumnName(n).toLowerCase() : resultSetMetaData.getColumnName(n);
        String string2 = null;
        try {
            string2 = resultSetMetaData.getColumnClassName(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = ResultSetDynaClass.class$("java.lang.Object")) : class$java$lang$Object;
        if (string2 != null) {
            clazz = this.loadClass(string2);
        }
        return new DynaProperty(string, clazz);
    }

    protected Class loadClass(String string) throws SQLException {
        try {
            return this.getClass().getClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot load column class '" + string + "': " + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

