/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.FastHashMap;

public class PropertyUtils {
    public static final char INDEXED_DELIM = '[';
    public static final char INDEXED_DELIM2 = ']';
    public static final char MAPPED_DELIM = '(';
    public static final char MAPPED_DELIM2 = ')';
    public static final char NESTED_DELIM = '.';
    private static int debug = 0;
    private static FastHashMap descriptorsCache = null;
    private static FastHashMap mappedDescriptorsCache = null;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int n) {
        debug = n;
    }

    public static void clearDescriptors() {
        descriptorsCache.clear();
        mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public static void copyProperties(Object object, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (object2 instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object2).getDynaClass().getDynaProperties();
            int n = 0;
            while (n < dynaPropertyArray.length) {
                Object object3;
                String string = dynaPropertyArray[n].getName();
                if (object instanceof DynaBean) {
                    if (PropertyUtils.isWriteable(object, string)) {
                        object3 = ((DynaBean)object2).get(string);
                        ((DynaBean)object).set(string, object3);
                    }
                } else if (PropertyUtils.isWriteable(object, string)) {
                    object3 = ((DynaBean)object2).get(string);
                    PropertyUtils.setSimpleProperty(object, string, object3);
                }
                ++n;
            }
        } else if (object2 instanceof Map) {
            Iterator iterator = ((Map)object2).keySet().iterator();
            while (iterator.hasNext()) {
                Object v;
                String string = (String)iterator.next();
                if (object instanceof DynaBean) {
                    if (!PropertyUtils.isWriteable(object, string)) continue;
                    v = ((Map)object2).get(string);
                    ((DynaBean)object).set(string, v);
                    continue;
                }
                if (!PropertyUtils.isWriteable(object, string)) continue;
                v = ((Map)object2).get(string);
                PropertyUtils.setSimpleProperty(object, string, v);
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors(object2);
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String string = propertyDescriptorArray[n].getName();
                if (PropertyUtils.isReadable(object2, string)) {
                    Object object4;
                    if (object instanceof DynaBean) {
                        if (PropertyUtils.isWriteable(object, string)) {
                            object4 = PropertyUtils.getSimpleProperty(object2, string);
                            ((DynaBean)object).set(string, object4);
                        }
                    } else if (PropertyUtils.isWriteable(object, string)) {
                        object4 = PropertyUtils.getSimpleProperty(object2, string);
                        PropertyUtils.setSimpleProperty(object, string, object4);
                    }
                }
                ++n;
            }
        }
    }

    public static Map describe(Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (object instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object).getDynaClass().getDynaProperties();
            int n = 0;
            while (n < dynaPropertyArray.length) {
                String string = dynaPropertyArray[n].getName();
                hashMap.put(string, PropertyUtils.getProperty(object, string));
                ++n;
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors(object);
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String string = propertyDescriptorArray[n].getName();
                if (propertyDescriptorArray[n].getReadMethod() != null) {
                    hashMap.put(string, PropertyUtils.getProperty(object, string));
                }
                ++n;
            }
        }
        return hashMap;
    }

    public static Object getIndexedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        if (n < 0 || n2 <= n) {
            throw new IllegalArgumentException("Invalid indexed property '" + string + "'");
        }
        int n3 = -1;
        try {
            String string2 = string.substring(n + 1, n2);
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid indexed property '" + string + "'");
        }
        string = string.substring(0, n);
        return PropertyUtils.getIndexedProperty(object, string, n3);
    }

    public static Object getIndexedProperty(Object object, String string, int n) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method;
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            return ((DynaBean)object).get(string, n);
        }
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor && (method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod()) != null) {
            Object[] objectArray = new Object[]{new Integer(n)};
            try {
                return method.invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof ArrayIndexOutOfBoundsException) {
                    throw (ArrayIndexOutOfBoundsException)invocationTargetException.getTargetException();
                }
                throw invocationTargetException;
            }
        }
        method = PropertyUtils.getReadMethod(propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no getter method");
        }
        Object object2 = method.invoke(object, new Object[0]);
        if (!object2.getClass().isArray()) {
            if (!(object2 instanceof List)) {
                throw new IllegalArgumentException("Property '" + string + "' is not indexed");
            }
            return ((List)object2).get(n);
        }
        return Array.get(object2, n);
    }

    public static Object getMappedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n < 0 || n2 <= n) {
            throw new IllegalArgumentException("Invalid mapped property '" + string + "'");
        }
        String string2 = string.substring(n + 1, n2);
        string = string.substring(0, n);
        return PropertyUtils.getMappedProperty(object, string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getMappedProperty(Object object, String string, String string2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("No key specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty != null) return ((DynaBean)object).get(string, string2);
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        Object object2 = null;
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            Method method = ((MappedPropertyDescriptor)propertyDescriptor).getMappedReadMethod();
            if (method == null) throw new NoSuchMethodException("Property '" + string + "' has no mapped getter method");
            Object[] objectArray = new Object[]{string2};
            return method.invoke(object, objectArray);
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) throw new NoSuchMethodException("Property '" + string + "' has no mapped getter method");
        Object object3 = method.invoke(object, new Object[0]);
        if (!(object3 instanceof Map)) return object2;
        return ((Map)object3).get(string2);
    }

    public static FastHashMap getMappedPropertyDescriptors(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (FastHashMap)mappedDescriptorsCache.get((Object)clazz);
    }

    public static FastHashMap getMappedPropertyDescriptors(Object object) {
        if (object == null) {
            return null;
        }
        return PropertyUtils.getMappedPropertyDescriptors(object.getClass());
    }

    public static Object getNestedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        while (true) {
            n4 = string.indexOf(46);
            n2 = string.indexOf(40);
            n3 = string.indexOf(41);
            n4 = n3 >= 0 && n2 >= 0 && (n4 < 0 || n4 > n2) ? string.indexOf(46, n3) : string.indexOf(46);
            if (n4 < 0) break;
            String string2 = string.substring(0, n4);
            n = string2.indexOf(91);
            n2 = string2.indexOf(40);
            if ((object = object instanceof Map ? ((Map)object).get(string2) : (n2 >= 0 ? PropertyUtils.getMappedProperty(object, string2) : (n >= 0 ? PropertyUtils.getIndexedProperty(object, string2) : PropertyUtils.getSimpleProperty(object, string2)))) == null) {
                throw new IllegalArgumentException("Null property value for '" + string.substring(0, n4) + "'");
            }
            string = string.substring(n4 + 1);
        }
        n = string.indexOf(91);
        n2 = string.indexOf(40);
        object = object instanceof Map ? ((Map)object).get(string) : (n2 >= 0 ? PropertyUtils.getMappedProperty(object, string) : (n >= 0 ? PropertyUtils.getIndexedProperty(object, string) : PropertyUtils.getSimpleProperty(object, string)));
        return object;
    }

    public static Object getProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PropertyUtils.getNestedProperty(object, string);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int n;
        PropertyDescriptor[] propertyDescriptorArray;
        int n2;
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        while ((n2 = string.indexOf(46)) >= 0) {
            propertyDescriptorArray = string.substring(0, n2);
            n = propertyDescriptorArray.indexOf(91);
            int n3 = propertyDescriptorArray.indexOf(40);
            object = n3 >= 0 && (n < 0 || n3 < n) ? PropertyUtils.getMappedProperty(object, (String)propertyDescriptorArray) : (n >= 0 ? PropertyUtils.getIndexedProperty(object, (String)propertyDescriptorArray) : PropertyUtils.getSimpleProperty(object, (String)propertyDescriptorArray));
            if (object == null) {
                throw new IllegalArgumentException("Null property value for '" + string.substring(0, n2) + "'");
            }
            string = string.substring(n2 + 1);
        }
        n2 = string.indexOf(91);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n2 = string.indexOf(40)) >= 0) {
            string = string.substring(0, n2);
        }
        if (object == null || string == null) {
            return null;
        }
        propertyDescriptorArray = PropertyUtils.getPropertyDescriptors(object);
        if (propertyDescriptorArray != null) {
            n = 0;
            while (n < propertyDescriptorArray.length) {
                if (string.equals(propertyDescriptorArray[n].getName())) {
                    return propertyDescriptorArray[n];
                }
                ++n;
            }
        }
        PropertyDescriptor propertyDescriptor = null;
        FastHashMap fastHashMap = PropertyUtils.getMappedPropertyDescriptors(object);
        if (fastHashMap == null) {
            fastHashMap = new FastHashMap();
            fastHashMap.setFast(true);
            mappedDescriptorsCache.put(object.getClass(), (Object)fastHashMap);
        }
        if ((propertyDescriptor = (PropertyDescriptor)fastHashMap.get((Object)string)) == null) {
            try {
                propertyDescriptor = new MappedPropertyDescriptor(string, (Class)object.getClass());
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            if (propertyDescriptor != null) {
                fastHashMap.put((Object)string, (Object)propertyDescriptor);
            }
        }
        return propertyDescriptor;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] propertyDescriptorArray = null;
        propertyDescriptorArray = (PropertyDescriptor[])descriptorsCache.get((Object)clazz);
        if (propertyDescriptorArray != null) {
            return propertyDescriptorArray;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return new PropertyDescriptor[0];
        }
        propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        descriptorsCache.put((Object)clazz, (Object)propertyDescriptorArray);
        return propertyDescriptorArray;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return PropertyUtils.getPropertyDescriptors(object.getClass());
    }

    public static Class getPropertyEditorClass(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getPropertyEditorClass();
        }
        return null;
    }

    public static Class getPropertyType(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                return null;
            }
            Class clazz = dynaProperty.getType();
            if (clazz == null) {
                return null;
            }
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
            return clazz;
        }
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            return null;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType();
        }
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)propertyDescriptor).getMappedPropertyType();
        }
        return propertyDescriptor.getPropertyType();
    }

    public static Method getReadMethod(PropertyDescriptor propertyDescriptor) {
        return MethodUtils.getAccessibleMethod(propertyDescriptor.getReadMethod());
    }

    public static Object getSimpleProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (string.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (string.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            return ((DynaBean)object).get(string);
        }
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        Method method = PropertyUtils.getReadMethod(propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no getter method");
        }
        Object object2 = method.invoke(object, new Object[0]);
        return object2;
    }

    public static Method getWriteMethod(PropertyDescriptor propertyDescriptor) {
        return MethodUtils.getAccessibleMethod(propertyDescriptor.getWriteMethod());
    }

    public static boolean isReadable(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            return ((DynaBean)object).getDynaClass().getDynaProperty(string) != null;
        }
        try {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
            if (propertyDescriptor != null) {
                Method method = propertyDescriptor.getReadMethod();
                if (method == null && propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod();
                }
                return method != null;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static boolean isWriteable(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            return ((DynaBean)object).getDynaClass().getDynaProperty(string) != null;
        }
        try {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
            if (propertyDescriptor != null) {
                Method method = propertyDescriptor.getWriteMethod();
                if (method == null && propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod();
                }
                return method != null;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static void setIndexedProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        if (n < 0 || n2 <= n) {
            throw new IllegalArgumentException("Invalid indexed property '" + string + "'");
        }
        int n3 = -1;
        try {
            String string2 = string.substring(n + 1, n2);
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid indexed property '" + string + "'");
        }
        string = string.substring(0, n);
        PropertyUtils.setIndexedProperty(object, string, n3, object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setIndexedProperty(Object object, String string, int n, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method;
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            ((DynaBean)object).set(string, n, object2);
            return;
        }
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor && (method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod()) != null) {
            Object[] objectArray = new Object[]{new Integer(n), object2};
            try {
                method.invoke(object, objectArray);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!(invocationTargetException.getTargetException() instanceof ArrayIndexOutOfBoundsException)) throw invocationTargetException;
                throw (ArrayIndexOutOfBoundsException)invocationTargetException.getTargetException();
            }
        }
        method = propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no getter method");
        }
        Object object3 = method.invoke(object, new Object[0]);
        if (!object3.getClass().isArray()) {
            if (!(object3 instanceof List)) throw new IllegalArgumentException("Property '" + string + "' is not indexed");
            ((List)object3).set(n, object2);
            return;
        } else {
            Array.set(object3, n, object2);
        }
    }

    public static void setMappedProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n < 0 || n2 <= n) {
            throw new IllegalArgumentException("Invalid mapped property '" + string + "'");
        }
        String string2 = string.substring(n + 1, n2);
        string = string.substring(0, n);
        PropertyUtils.setMappedProperty(object, string, string2, object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setMappedProperty(Object object, String string, String string2, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("No key specified");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            ((DynaBean)object).set(string, string2, object2);
            return;
        }
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            Method method = ((MappedPropertyDescriptor)propertyDescriptor).getMappedWriteMethod();
            if (method == null) throw new NoSuchMethodException("Property '" + string + "' has no mapped setter method");
            Object[] objectArray = new Object[]{string2, object2};
            method.invoke(object, objectArray);
            return;
        } else {
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) throw new NoSuchMethodException("Property '" + string + "' has no mapped getter method");
            Object object3 = method.invoke(object, new Object[0]);
            if (!(object3 instanceof Map)) return;
            ((Map)object3).put(string2, object2);
        }
    }

    public static void setNestedProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int n;
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int n2 = -1;
        int n3 = -1;
        while ((n = string.indexOf(46)) >= 0) {
            String string2 = string.substring(0, n);
            n2 = string2.indexOf(91);
            n3 = string2.indexOf(40);
            if ((object = object instanceof Map ? ((Map)object).get(string2) : (n3 >= 0 ? PropertyUtils.getMappedProperty(object, string2) : (n2 >= 0 ? PropertyUtils.getIndexedProperty(object, string2) : PropertyUtils.getSimpleProperty(object, string2)))) == null) {
                throw new IllegalArgumentException("Null property value for '" + string.substring(0, n) + "'");
            }
            string = string.substring(n + 1);
        }
        n2 = string.indexOf(91);
        n3 = string.indexOf(40);
        if (object instanceof Map) {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
            if (propertyDescriptor == null) {
                ((Map)object).put(string, object2);
            } else {
                PropertyUtils.setSimpleProperty(object, string, object2);
            }
        } else if (n3 >= 0) {
            PropertyUtils.setMappedProperty(object, string, object2);
        } else if (n2 >= 0) {
            PropertyUtils.setIndexedProperty(object, string, object2);
        } else {
            PropertyUtils.setSimpleProperty(object, string, object2);
        }
    }

    public static void setProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyUtils.setNestedProperty(object, string, object2);
    }

    public static void setSimpleProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (string.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (string.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        if (object instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + string + "'");
            }
            ((DynaBean)object).set(string, object2);
            return;
        }
        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + string + "'");
        }
        Method method = PropertyUtils.getWriteMethod(propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + string + "' has no setter method");
        }
        Object[] objectArray = new Object[]{object2};
        method.invoke(object, objectArray);
    }

    static {
        descriptorsCache = new FastHashMap();
        descriptorsCache.setFast(true);
        mappedDescriptorsCache = new FastHashMap();
        mappedDescriptorsCache.setFast(true);
    }
}

