/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$MethodUtils == null ? (class$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$("org.apache.commons.beanutils.MethodUtils")) : class$org$apache$commons$beanutils$MethodUtils));
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    static /* synthetic */ Class class$org$apache$commons$beanutils$MethodUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeMethod(object, string, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = objectArray[n2].getClass();
            ++n2;
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeExactMethod(object, string, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = objectArray[n2].getClass();
            ++n2;
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return MethodUtils.getAccessibleMethod(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class[] classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                if (Modifier.isPublic(classArray2[n].getModifiers())) {
                    try {
                        method = classArray2[n].getDeclaredMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[n], string, classArray)) != null) break;
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Method getMatchingAccessibleMethod(Class var0, String var1_1, Class[] var2_2) {
        if (MethodUtils.log.isTraceEnabled()) {
            MethodUtils.log.trace((Object)("Matching name=" + var1_1 + " on " + var0));
        }
        try {
            var3_3 = var0.getMethod(var1_1, var2_2);
            if (MethodUtils.log.isTraceEnabled()) {
                MethodUtils.log.trace((Object)("Found straight match: " + var3_3));
                MethodUtils.log.trace((Object)("isPublic:" + Modifier.isPublic(var3_3.getModifiers())));
            }
            try {
                var3_3.setAccessible(true);
            }
            catch (SecurityException var4_6) {
                if (!MethodUtils.loggedAccessibleWarning) {
                    MethodUtils.log.warn((Object)"Cannot use JVM pre-1.4 access bug workaround die to restrictive security manager.");
                    MethodUtils.loggedAccessibleWarning = true;
                }
                MethodUtils.log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)var4_6);
            }
            return var3_3;
        }
        catch (NoSuchMethodException var3_4) {
            var3_5 = var2_2.length;
            var4_7 = var0.getMethods();
            var5_8 = 0;
            var6_9 = var4_7.length;
            ** while (var5_8 < var6_9)
        }
lbl-1000:
        // 1 sources

        {
            if (var4_7[var5_8].getName().equals(var1_1)) {
                if (MethodUtils.log.isTraceEnabled()) {
                    MethodUtils.log.trace((Object)"Found matching name:");
                    MethodUtils.log.trace((Object)var4_7[var5_8]);
                }
                if ((var8_11 = (var7_10 = var4_7[var5_8].getParameterTypes()).length) == var3_5) {
                    var9_12 = true;
                    var10_13 = 0;
                    while (var10_13 < var8_11) {
                        if (MethodUtils.log.isTraceEnabled()) {
                            MethodUtils.log.trace((Object)("Param=" + var2_2[var10_13].getName()));
                            MethodUtils.log.trace((Object)("Method=" + var7_10[var10_13].getName()));
                        }
                        if (!MethodUtils.isAssignmentCompatible(var7_10[var10_13], var2_2[var10_13])) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace((Object)(var7_10[var10_13] + " is not assignable from " + var2_2[var10_13]));
                            }
                            var9_12 = false;
                            break;
                        }
                        ++var10_13;
                    }
                    if (var9_12) {
                        var11_14 = MethodUtils.getAccessibleMethod(var4_7[var5_8]);
                        if (var11_14 != null) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace((Object)(var11_14 + " accessible version of " + var4_7[var5_8]));
                            }
                            try {
                                var11_14.setAccessible(true);
                            }
                            catch (SecurityException var12_15) {
                                if (!MethodUtils.loggedAccessibleWarning) {
                                    MethodUtils.log.warn((Object)"Cannot use JVM pre-1.4 access bug workaround die to restrictive security manager.");
                                    MethodUtils.loggedAccessibleWarning = true;
                                }
                                MethodUtils.log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)var12_15);
                            }
                            return var11_14;
                        }
                        MethodUtils.log.trace((Object)"Couldn't find accessible method.");
                    }
                }
            }
            ++var5_8;
            continue;
        }
lbl58:
        // 1 sources

        MethodUtils.log.trace((Object)"No match found.");
        return null;
    }

    protected static final boolean isAssignmentCompatible(Class clazz, Class clazz2) {
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE.equals(clazz)) {
                return (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(clazz2);
            }
            if (Float.TYPE.equals(clazz)) {
                return (class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$("java.lang.Float")) : class$java$lang$Float).equals(clazz2);
            }
            if (Long.TYPE.equals(clazz)) {
                return (class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$("java.lang.Long")) : class$java$lang$Long).equals(clazz2);
            }
            if (Integer.TYPE.equals(clazz)) {
                return (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(clazz2);
            }
            if (Double.TYPE.equals(clazz)) {
                return (class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$("java.lang.Double")) : class$java$lang$Double).equals(clazz2);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

