/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Array;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterArrayConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleArrayConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatArrayConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerArrayConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongArrayConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortArrayConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtils {
    private static Boolean defaultBoolean = Boolean.FALSE;
    private static Byte defaultByte = new Byte(0);
    private static Character defaultCharacter = new Character(' ');
    private static Double defaultDouble = new Double(0.0);
    private static Float defaultFloat = new Float(0.0f);
    private static Integer defaultInteger = new Integer(0);
    private static Long defaultLong = new Long(0L);
    private static Short defaultShort = new Short(0);
    private static FastHashMap converters = new FastHashMap();
    private static Log log;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$org$apache$commons$beanutils$ConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static boolean getDefaultBoolean() {
        return defaultBoolean;
    }

    public static void setDefaultBoolean(boolean bl) {
        defaultBoolean = new Boolean(bl);
        converters.put(Boolean.TYPE, (Object)new BooleanConverter(defaultBoolean));
        converters.put((Object)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean), (Object)new BooleanConverter(defaultBoolean));
    }

    public static byte getDefaultByte() {
        return defaultByte;
    }

    public static void setDefaultByte(byte by) {
        defaultByte = new Byte(by);
        converters.put(Byte.TYPE, (Object)new ByteConverter(defaultByte));
        converters.put((Object)(class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtils.class$("java.lang.Byte")) : class$java$lang$Byte), (Object)new ByteConverter(defaultByte));
    }

    public static char getDefaultCharacter() {
        return defaultCharacter.charValue();
    }

    public static void setDefaultCharacter(char c) {
        defaultCharacter = new Character(c);
        converters.put(Character.TYPE, (Object)new CharacterConverter(defaultCharacter));
        converters.put((Object)(class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtils.class$("java.lang.Character")) : class$java$lang$Character), (Object)new CharacterConverter(defaultCharacter));
    }

    public static double getDefaultDouble() {
        return defaultDouble;
    }

    public static void setDefaultDouble(double d) {
        defaultDouble = new Double(d);
        converters.put(Double.TYPE, (Object)new DoubleConverter(defaultDouble));
        converters.put((Object)(class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtils.class$("java.lang.Double")) : class$java$lang$Double), (Object)new DoubleConverter(defaultDouble));
    }

    public static float getDefaultFloat() {
        return defaultFloat.floatValue();
    }

    public static void setDefaultFloat(float f) {
        defaultFloat = new Float(f);
        converters.put(Float.TYPE, (Object)new FloatConverter(defaultFloat));
        converters.put((Object)(class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtils.class$("java.lang.Float")) : class$java$lang$Float), (Object)new FloatConverter(defaultFloat));
    }

    public static int getDefaultInteger() {
        return defaultInteger;
    }

    public static void setDefaultInteger(int n) {
        defaultInteger = new Integer(n);
        converters.put(Integer.TYPE, (Object)new IntegerConverter(defaultInteger));
        converters.put((Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtils.class$("java.lang.Integer")) : class$java$lang$Integer), (Object)new IntegerConverter(defaultInteger));
    }

    public static long getDefaultLong() {
        return defaultLong;
    }

    public static void setDefaultLong(long l) {
        defaultLong = new Long(l);
        converters.put(Long.TYPE, (Object)new LongConverter(defaultLong));
        converters.put((Object)(class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtils.class$("java.lang.Long")) : class$java$lang$Long), (Object)new LongConverter(defaultLong));
    }

    public static short getDefaultShort() {
        return defaultShort;
    }

    public static void setDefaultShort(short s) {
        defaultShort = new Short(s);
        converters.put(Short.TYPE, (Object)new ShortConverter(defaultShort));
        converters.put((Object)(class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtils.class$("java.lang.Short")) : class$java$lang$Short), (Object)new ShortConverter(defaultShort));
    }

    public static String convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            if (Array.getLength(object) < 1) {
                return null;
            }
            if ((object = Array.get(object, 0)) == null) {
                return null;
            }
            Converter converter = (Converter)converters.get((Object)(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String));
            return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String, object);
        }
        Converter converter = (Converter)converters.get((Object)(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String));
        return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String, object);
    }

    public static Object convert(String string, Class clazz) {
        Converter converter;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Convert string '" + string + "' to class '" + clazz.getName() + "'"));
        }
        if ((converter = (Converter)converters.get((Object)clazz)) == null) {
            converter = (Converter)converters.get((Object)(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Using converter " + converter));
        }
        return converter.convert(clazz, string);
    }

    public static Object convert(String[] stringArray, Class clazz) {
        Converter converter;
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Convert String[" + stringArray.length + "] to class '" + clazz2.getName() + "[]'"));
        }
        if ((converter = (Converter)converters.get(clazz2)) == null) {
            converter = (Converter)converters.get((Object)(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Using converter " + converter));
        }
        Object object = Array.newInstance(clazz2, stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            Array.set(object, n, converter.convert(clazz2, stringArray[n]));
            ++n;
        }
        return object;
    }

    public static void deregister() {
        boolean[] blArray = new boolean[]{};
        byte[] byArray = new byte[]{};
        char[] cArray = new char[]{};
        double[] dArray = new double[]{};
        float[] fArray = new float[]{};
        int[] nArray = new int[]{};
        long[] lArray = new long[]{};
        short[] sArray = new short[]{};
        String[] stringArray = new String[]{};
        converters.clear();
        converters.put((Object)(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConvertUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal), (Object)new BigDecimalConverter());
        converters.put((Object)(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConvertUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger), (Object)new BigIntegerConverter());
        converters.put(Boolean.TYPE, (Object)new BooleanConverter(defaultBoolean));
        converters.put((Object)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConvertUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean), (Object)new BooleanConverter(defaultBoolean));
        converters.put(blArray.getClass(), (Object)new BooleanArrayConverter(blArray));
        converters.put(Byte.TYPE, (Object)new ByteConverter(defaultByte));
        converters.put((Object)(class$java$lang$Byte == null ? (class$java$lang$Byte = ConvertUtils.class$("java.lang.Byte")) : class$java$lang$Byte), (Object)new ByteConverter(defaultByte));
        converters.put(byArray.getClass(), (Object)new ByteArrayConverter(byArray));
        converters.put(Character.TYPE, (Object)new CharacterConverter(defaultCharacter));
        converters.put((Object)(class$java$lang$Character == null ? (class$java$lang$Character = ConvertUtils.class$("java.lang.Character")) : class$java$lang$Character), (Object)new CharacterConverter(defaultCharacter));
        converters.put(cArray.getClass(), (Object)new CharacterArrayConverter(cArray));
        converters.put((Object)(class$java$lang$Class == null ? (class$java$lang$Class = ConvertUtils.class$("java.lang.Class")) : class$java$lang$Class), (Object)new ClassConverter());
        converters.put(Double.TYPE, (Object)new DoubleConverter(defaultDouble));
        converters.put((Object)(class$java$lang$Double == null ? (class$java$lang$Double = ConvertUtils.class$("java.lang.Double")) : class$java$lang$Double), (Object)new DoubleConverter(defaultDouble));
        converters.put(dArray.getClass(), (Object)new DoubleArrayConverter(dArray));
        converters.put(Float.TYPE, (Object)new FloatConverter(defaultFloat));
        converters.put((Object)(class$java$lang$Float == null ? (class$java$lang$Float = ConvertUtils.class$("java.lang.Float")) : class$java$lang$Float), (Object)new FloatConverter(defaultFloat));
        converters.put(fArray.getClass(), (Object)new FloatArrayConverter(fArray));
        converters.put(Integer.TYPE, (Object)new IntegerConverter(defaultInteger));
        converters.put((Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = ConvertUtils.class$("java.lang.Integer")) : class$java$lang$Integer), (Object)new IntegerConverter(defaultInteger));
        converters.put(nArray.getClass(), (Object)new IntegerArrayConverter(nArray));
        converters.put(Long.TYPE, (Object)new LongConverter(defaultLong));
        converters.put((Object)(class$java$lang$Long == null ? (class$java$lang$Long = ConvertUtils.class$("java.lang.Long")) : class$java$lang$Long), (Object)new LongConverter(defaultLong));
        converters.put(lArray.getClass(), (Object)new LongArrayConverter(lArray));
        converters.put(Short.TYPE, (Object)new ShortConverter(defaultShort));
        converters.put((Object)(class$java$lang$Short == null ? (class$java$lang$Short = ConvertUtils.class$("java.lang.Short")) : class$java$lang$Short), (Object)new ShortConverter(defaultShort));
        converters.put(sArray.getClass(), (Object)new ShortArrayConverter(sArray));
        converters.put((Object)(class$java$lang$String == null ? (class$java$lang$String = ConvertUtils.class$("java.lang.String")) : class$java$lang$String), (Object)new StringConverter());
        converters.put(stringArray.getClass(), (Object)new StringArrayConverter(stringArray));
        converters.put((Object)(class$java$sql$Date == null ? (class$java$sql$Date = ConvertUtils.class$("java.sql.Date")) : class$java$sql$Date), (Object)new SqlDateConverter());
        converters.put((Object)(class$java$sql$Time == null ? (class$java$sql$Time = ConvertUtils.class$("java.sql.Time")) : class$java$sql$Time), (Object)new SqlTimeConverter());
        converters.put((Object)(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConvertUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp), (Object)new SqlTimestampConverter());
    }

    public static void deregister(Class clazz) {
        converters.remove((Object)clazz);
    }

    public static Converter lookup(Class clazz) {
        return (Converter)converters.get((Object)clazz);
    }

    public static void register(Converter converter, Class clazz) {
        converters.put((Object)clazz, (Object)converter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        converters.setFast(false);
        ConvertUtils.deregister();
        converters.setFast(true);
        log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$ConvertUtils == null ? (class$org$apache$commons$beanutils$ConvertUtils = ConvertUtils.class$("org.apache.commons.beanutils.ConvertUtils")) : class$org$apache$commons$beanutils$ConvertUtils));
    }
}

