/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.MethodUtils;

public class ConstructorUtils {
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];

    public static Object invokeConstructor(Class clazz, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray = new Object[]{object};
        return ConstructorUtils.invokeConstructor(clazz, objectArray);
    }

    public static Object invokeConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == objectArray) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = objectArray[n2].getClass();
            ++n2;
        }
        return ConstructorUtils.invokeConstructor(clazz, objectArray, classArray);
    }

    public static Object invokeConstructor(Class clazz, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor constructor;
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (null == (constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz, classArray))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray);
    }

    public static Object invokeExactConstructor(Class clazz, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray = new Object[]{object};
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray);
    }

    public static Object invokeExactConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == objectArray) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = objectArray[n2].getClass();
            ++n2;
        }
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray, classArray);
    }

    public static Object invokeExactConstructor(Class clazz, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor constructor;
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (null == (constructor = ConstructorUtils.getAccessibleConstructor(clazz, classArray))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray);
    }

    public static Constructor getAccessibleConstructor(Class clazz, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return ConstructorUtils.getAccessibleConstructor(clazz, classArray);
    }

    public static Constructor getAccessibleConstructor(Class clazz, Class[] classArray) {
        try {
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Constructor getAccessibleConstructor(Constructor constructor) {
        if (constructor == null) {
            return null;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return null;
        }
        Class clazz = constructor.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return constructor;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static Constructor getMatchingAccessibleConstructor(Class var0, Class[] var1_1) {
        try {
            var2_2 = var0.getConstructor(var1_1);
            try {
                var2_2.setAccessible(true);
            }
            catch (SecurityException var3_5) {
                // empty catch block
            }
            return var2_2;
        }
        catch (NoSuchMethodException var2_3) {
            var2_4 = var1_1.length;
            var3_6 = var0.getConstructors();
            var4_7 = 0;
            var5_8 = var3_6.length;
            ** while (var4_7 < var5_8)
        }
lbl-1000:
        // 1 sources

        {
            var6_9 = var3_6[var4_7].getParameterTypes();
            var7_10 = var6_9.length;
            if (var7_10 == var2_4) {
                var8_11 = true;
                var9_12 = 0;
                while (var9_12 < var7_10) {
                    if (!MethodUtils.isAssignmentCompatible(var6_9[var9_12], var1_1[var9_12])) {
                        var8_11 = false;
                        break;
                    }
                    ++var9_12;
                }
                if (var8_11 && (var10_13 = ConstructorUtils.getAccessibleConstructor(var3_6[var4_7])) != null) {
                    try {
                        var10_13.setAccessible(true);
                    }
                    catch (SecurityException var11_14) {
                        // empty catch block
                    }
                    return var10_13;
                }
            }
            ++var4_7;
            continue;
        }
lbl35:
        // 1 sources

        return null;
    }
}

