/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtils {
    private static FastHashMap dummy = new FastHashMap();
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$BeanUtils == null ? (class$org$apache$commons$beanutils$BeanUtils = BeanUtils.class$("org.apache.commons.beanutils.BeanUtils")) : class$org$apache$commons$beanutils$BeanUtils));
    private static int debug = 0;
    static /* synthetic */ Class class$org$apache$commons$beanutils$BeanUtils;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int n) {
        debug = n;
    }

    public static Object cloneBean(Object object) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cloning bean: " + object.getClass().getName()));
        }
        Class<?> clazz = object.getClass();
        Object obj = clazz.newInstance();
        PropertyUtils.copyProperties(obj, object);
        return obj;
    }

    public static void copyProperties(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
        if (object == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BeanUtils.copyProperties(" + object + ", " + object2 + ")"));
        }
        if (object2 instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object2).getDynaClass().getDynaProperties();
            int n = 0;
            while (n < dynaPropertyArray.length) {
                String string = dynaPropertyArray[n].getName();
                if (PropertyUtils.isWriteable(object, string)) {
                    Object object3 = ((DynaBean)object2).get(string);
                    BeanUtils.copyProperty(object, string, object3);
                }
                ++n;
            }
        } else if (object2 instanceof Map) {
            Iterator iterator = ((Map)object2).keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!PropertyUtils.isWriteable(object, string)) continue;
                Object v = ((Map)object2).get(string);
                BeanUtils.copyProperty(object, string, v);
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors(object2);
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String string = propertyDescriptorArray[n].getName();
                if (!"class".equals(string) && PropertyUtils.isReadable(object2, string) && PropertyUtils.isWriteable(object, string)) {
                    try {
                        Object object4 = PropertyUtils.getSimpleProperty(object2, string);
                        BeanUtils.copyProperty(object, string, object4);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }

    public static void copyProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException {
        Object object3;
        int n;
        Object object4;
        if (log.isTraceEnabled()) {
            object4 = new StringBuffer("  copyProperty(");
            ((StringBuffer)object4).append(object);
            ((StringBuffer)object4).append(", ");
            ((StringBuffer)object4).append(string);
            ((StringBuffer)object4).append(", ");
            if (object2 == null) {
                ((StringBuffer)object4).append("<NULL>");
            } else if (object2 instanceof String) {
                ((StringBuffer)object4).append((String)object2);
            } else if (object2 instanceof String[]) {
                String[] stringArray = (String[])object2;
                ((StringBuffer)object4).append('[');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 > 0) {
                        ((StringBuffer)object4).append(',');
                    }
                    ((StringBuffer)object4).append(stringArray[n2]);
                    ++n2;
                }
                ((StringBuffer)object4).append(']');
            } else {
                ((StringBuffer)object4).append(object2.toString());
            }
            ((StringBuffer)object4).append(')');
            log.trace((Object)((StringBuffer)object4).toString());
        }
        object4 = object;
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0) {
            try {
                object4 = PropertyUtils.getProperty(object, string.substring(0, n3));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            string = string.substring(n3 + 1);
            if (log.isTraceEnabled()) {
                log.trace((Object)("    Target bean = " + object4));
                log.trace((Object)("    Target name = " + string));
            }
        }
        String string2 = null;
        Class<?> clazz = null;
        int n4 = -1;
        String string3 = null;
        string2 = string;
        int n5 = string2.indexOf(91);
        if (n5 >= 0) {
            n = string2.indexOf(93);
            try {
                n4 = Integer.parseInt(string2.substring(n5 + 1, n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string2 = string2.substring(0, n5);
        }
        if ((n = string2.indexOf(40)) >= 0) {
            int n6 = string2.indexOf(41);
            try {
                string3 = string2.substring(n + 1, n6);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            string2 = string2.substring(0, n);
        }
        if (object4 instanceof DynaBean) {
            object3 = ((DynaBean)object4).getDynaClass();
            DynaProperty dynaProperty = object3.getDynaProperty(string2);
            if (dynaProperty == null) {
                return;
            }
            clazz = dynaProperty.getType();
        } else {
            object3 = null;
            try {
                object3 = PropertyUtils.getPropertyDescriptor(object4, string);
                if (object3 == null) {
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            clazz = ((PropertyDescriptor)object3).getPropertyType();
            if (clazz == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("    target type for property '" + string2 + "' is null, so skipping ths setter"));
                }
                return;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("    target propName=" + string2 + ", type=" + clazz + ", index=" + n4 + ", key=" + string3));
        }
        if (n4 >= 0) {
            object3 = ConvertUtils.lookup(clazz.getComponentType());
            if (object3 != null) {
                log.trace((Object)("        USING CONVERTER " + object3));
                object2 = object3.convert(clazz, object2);
            }
            try {
                PropertyUtils.setIndexedProperty(object4, string2, n4, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
            }
        }
        if (string3 != null) {
            try {
                PropertyUtils.setMappedProperty(object4, string2, string3, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
            }
        }
        object3 = ConvertUtils.lookup(clazz);
        if (object3 != null) {
            log.trace((Object)("        USING CONVERTER " + object3));
            object2 = object3.convert(clazz, object2);
        }
        try {
            PropertyUtils.setSimpleProperty(object4, string2, object2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
        }
    }

    public static Map describe(Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            return new HashMap();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Describing bean: " + object.getClass().getName()));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (object instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object).getDynaClass().getDynaProperties();
            int n = 0;
            while (n < dynaPropertyArray.length) {
                String string = dynaPropertyArray[n].getName();
                hashMap.put(string, BeanUtils.getProperty(object, string));
                ++n;
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors(object);
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String string = propertyDescriptorArray[n].getName();
                if (propertyDescriptorArray[n].getReadMethod() != null) {
                    hashMap.put(string, BeanUtils.getProperty(object, string));
                }
                ++n;
            }
        }
        return hashMap;
    }

    public static String[] getArrayProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = PropertyUtils.getProperty(object, string);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Collection) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = ((Collection)object2).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(e.toString());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        if (object2.getClass().isArray()) {
            int n = Array.getLength(object2);
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                Object object3 = Array.get(object2, n2);
                stringArray[n2] = object3 == null ? null : object3.toString();
                ++n2;
            }
            return stringArray;
        }
        String[] stringArray = new String[]{object2.toString()};
        return stringArray;
    }

    public static String getIndexedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = PropertyUtils.getIndexedProperty(object, string);
        return ConvertUtils.convert(object2);
    }

    public static String getIndexedProperty(Object object, String string, int n) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = PropertyUtils.getIndexedProperty(object, string, n);
        return ConvertUtils.convert(object2);
    }

    public static String getMappedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = PropertyUtils.getMappedProperty(object, string);
        return ConvertUtils.convert(object2);
    }

    public static String getMappedProperty(Object object, String string, String string2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = PropertyUtils.getMappedProperty(object, string, string2);
        return ConvertUtils.convert(object2);
    }

    public static String getNestedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = PropertyUtils.getNestedProperty(object, string);
        return ConvertUtils.convert(object2);
    }

    public static String getProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return BeanUtils.getNestedProperty(object, string);
    }

    public static String getSimpleProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = PropertyUtils.getSimpleProperty(object, string);
        return ConvertUtils.convert(object2);
    }

    public static void populate(Object object, Map map) throws IllegalAccessException, InvocationTargetException {
        if (object == null || map == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BeanUtils.populate(" + object + ", " + map + ")"));
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null) continue;
            Object v = map.get(string);
            BeanUtils.setProperty(object, string, v);
        }
    }

    public static void setProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException {
        String[] stringArray;
        Object object3;
        int n;
        Object object4;
        if (log.isTraceEnabled()) {
            object4 = new StringBuffer("  setProperty(");
            ((StringBuffer)object4).append(object);
            ((StringBuffer)object4).append(", ");
            ((StringBuffer)object4).append(string);
            ((StringBuffer)object4).append(", ");
            if (object2 == null) {
                ((StringBuffer)object4).append("<NULL>");
            } else if (object2 instanceof String) {
                ((StringBuffer)object4).append((String)object2);
            } else if (object2 instanceof String[]) {
                String[] stringArray2 = (String[])object2;
                ((StringBuffer)object4).append('[');
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (n2 > 0) {
                        ((StringBuffer)object4).append(',');
                    }
                    ((StringBuffer)object4).append(stringArray2[n2]);
                    ++n2;
                }
                ((StringBuffer)object4).append(']');
            } else {
                ((StringBuffer)object4).append(object2.toString());
            }
            ((StringBuffer)object4).append(')');
            log.trace((Object)((StringBuffer)object4).toString());
        }
        object4 = object;
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0) {
            try {
                object4 = PropertyUtils.getProperty(object, string.substring(0, n3));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            string = string.substring(n3 + 1);
            if (log.isTraceEnabled()) {
                log.trace((Object)("    Target bean = " + object4));
                log.trace((Object)("    Target name = " + string));
            }
        }
        String string2 = null;
        Class<?> clazz = null;
        int n4 = -1;
        String string3 = null;
        string2 = string;
        int n5 = string2.indexOf(91);
        if (n5 >= 0) {
            n = string2.indexOf(93);
            try {
                n4 = Integer.parseInt(string2.substring(n5 + 1, n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string2 = string2.substring(0, n5);
        }
        if ((n = string2.indexOf(40)) >= 0) {
            int n6 = string2.indexOf(41);
            try {
                string3 = string2.substring(n + 1, n6);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            string2 = string2.substring(0, n);
        }
        if (object4 instanceof DynaBean) {
            object3 = ((DynaBean)object4).getDynaClass();
            stringArray = object3.getDynaProperty(string2);
            if (stringArray == null) {
                return;
            }
            clazz = stringArray.getType();
        } else {
            object3 = null;
            try {
                object3 = PropertyUtils.getPropertyDescriptor(object4, string);
                if (object3 == null) {
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            if (object3 instanceof MappedPropertyDescriptor) {
                if (((MappedPropertyDescriptor)object3).getMappedWriteMethod() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Skipping read-only property");
                    }
                    return;
                }
                clazz = ((MappedPropertyDescriptor)object3).getMappedPropertyType();
            } else if (object3 instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)object3).getIndexedWriteMethod() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Skipping read-only property");
                    }
                    return;
                }
                clazz = ((IndexedPropertyDescriptor)object3).getIndexedPropertyType();
            } else {
                if (((PropertyDescriptor)object3).getWriteMethod() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Skipping read-only property");
                    }
                    return;
                }
                clazz = ((PropertyDescriptor)object3).getPropertyType();
            }
        }
        object3 = null;
        if (clazz.isArray() && n4 < 0) {
            if (object2 == null) {
                stringArray = new String[]{(String)object2};
                object3 = ConvertUtils.convert(stringArray, clazz);
            } else if (object2 instanceof String) {
                stringArray = new String[]{(String)object2};
                object3 = ConvertUtils.convert(stringArray, clazz);
            } else {
                object3 = object2 instanceof String[] ? ConvertUtils.convert((String[])object2, clazz) : object2;
            }
        } else {
            object3 = clazz.isArray() ? (object2 instanceof String ? ConvertUtils.convert((String)object2, clazz.getComponentType()) : (object2 instanceof String[] ? ConvertUtils.convert(((String[])object2)[0], clazz.getComponentType()) : object2)) : (object2 instanceof String || object2 == null ? ConvertUtils.convert((String)object2, clazz) : (object2 instanceof String[] ? ConvertUtils.convert(((String[])object2)[0], clazz) : (ConvertUtils.lookup(object2.getClass()) != null ? ConvertUtils.convert(object2.toString(), clazz) : object2)));
        }
        try {
            if (n4 >= 0) {
                PropertyUtils.setIndexedProperty(object4, string2, n4, object3);
            } else if (string3 != null) {
                PropertyUtils.setMappedProperty(object4, string2, string3, object3);
            } else {
                PropertyUtils.setProperty(object4, string2, object3);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

