/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class BasicDynaBean
implements DynaBean,
Serializable {
    protected DynaClass dynaClass = null;
    protected HashMap values = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public BasicDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }

    public boolean contains(String string, String string2) {
        Object v = this.values.get(string);
        if (v == null) {
            throw new NullPointerException("No mapped value for '" + string + "(" + string2 + ")'");
        }
        if (v instanceof Map) {
            return ((Map)v).containsKey(string2);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'");
    }

    public Object get(String string) {
        Object v = this.values.get(string);
        if (v != null) {
            return v;
        }
        Class clazz = this.getDynaProperty(string).getType();
        if (!clazz.isPrimitive()) {
            return v;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return new Byte(0);
        }
        if (clazz == Character.TYPE) {
            return new Character('\u0000');
        }
        if (clazz == Double.TYPE) {
            return new Double(0.0);
        }
        if (clazz == Float.TYPE) {
            return new Float(0.0f);
        }
        if (clazz == Integer.TYPE) {
            return new Integer(0);
        }
        if (clazz == Long.TYPE) {
            return new Long(0L);
        }
        if (clazz == Short.TYPE) {
            return new Short(0);
        }
        return null;
    }

    public Object get(String string, int n) {
        Object v = this.values.get(string);
        if (v == null) {
            throw new NullPointerException("No indexed value for '" + string + "[" + n + "]'");
        }
        if (v.getClass().isArray()) {
            return Array.get(v, n);
        }
        if (v instanceof List) {
            return ((List)v).get(n);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n + "]'");
    }

    public Object get(String string, String string2) {
        Object v = this.values.get(string);
        if (v == null) {
            throw new NullPointerException("No mapped value for '" + string + "(" + string2 + ")'");
        }
        if (v instanceof Map) {
            return ((Map)v).get(string2);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'");
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void remove(String string, String string2) {
        Object v = this.values.get(string);
        if (v == null) {
            throw new NullPointerException("No mapped value for '" + string + "(" + string2 + ")'");
        }
        if (!(v instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'");
        }
        ((Map)v).remove(string2);
    }

    public void set(String string, Object object) {
        DynaProperty dynaProperty = this.getDynaProperty(string);
        if (object == null) {
            if (dynaProperty.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + string + "'");
            }
        } else if (!this.isAssignable(dynaProperty.getType(), object.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + object.getClass().getName() + "' to property '" + string + "' of type '" + dynaProperty.getType().getName() + "'");
        }
        this.values.put(string, object);
    }

    public void set(String string, int n, Object object) {
        Object v = this.values.get(string);
        if (v == null) {
            throw new NullPointerException("No indexed value for '" + string + "[" + n + "]'");
        }
        if (v.getClass().isArray()) {
            Array.set(v, n, object);
        } else if (v instanceof List) {
            try {
                ((List)v).set(n, object);
            }
            catch (ClassCastException classCastException) {
                throw new ConversionException(classCastException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + string + "[" + n + "]'");
        }
    }

    public void set(String string, String string2, Object object) {
        Object v = this.values.get(string);
        if (v == null) {
            throw new NullPointerException("No mapped value for '" + string + "(" + string2 + ")'");
        }
        if (!(v instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + string + "(" + string2 + ")'");
        }
        ((Map)v).put(string2, object);
    }

    protected DynaProperty getDynaProperty(String string) {
        DynaProperty dynaProperty = this.getDynaClass().getDynaProperty(string);
        if (dynaProperty == null) {
            throw new IllegalArgumentException("Invalid property name '" + string + "'");
        }
        return dynaProperty;
    }

    protected boolean isAssignable(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2) || clazz == Boolean.TYPE && clazz2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicDynaBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == Byte.TYPE && clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = BasicDynaBean.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Character.TYPE && clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = BasicDynaBean.class$("java.lang.Character")) : class$java$lang$Character) || clazz == Double.TYPE && clazz2 == (class$java$lang$Double == null ? (class$java$lang$Double = BasicDynaBean.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Float.TYPE && clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = BasicDynaBean.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Integer.TYPE && clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = BasicDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Long.TYPE && clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = BasicDynaBean.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Short.TYPE && clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = BasicDynaBean.class$("java.lang.Short")) : class$java$lang$Short);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

