/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MenuStylesKeyType implements Enumerator
{
    MENU(0, "Menu", "Menu"),
    MENU_ITEM(1, "MenuItem", "MenuItem"),
    ON_MOUSE_OVER(2, "OnMouseOver", "OnMouseOver"),
    ON_MOUSE_OUT(3, "OnMouseOut", "OnMouseOut");

    public static final int MENU_VALUE = 0;
    public static final int MENU_ITEM_VALUE = 1;
    public static final int ON_MOUSE_OVER_VALUE = 2;
    public static final int ON_MOUSE_OUT_VALUE = 3;
    private static final MenuStylesKeyType[] VALUES_ARRAY;
    public static final List<MenuStylesKeyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MenuStylesKeyType[]{MENU, MENU_ITEM, ON_MOUSE_OVER, ON_MOUSE_OUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MenuStylesKeyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MenuStylesKeyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MenuStylesKeyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MenuStylesKeyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MenuStylesKeyType get(int value) {
        switch (value) {
            case 0: {
                return MENU;
            }
            case 1: {
                return MENU_ITEM;
            }
            case 2: {
                return ON_MOUSE_OVER;
            }
            case 3: {
                return ON_MOUSE_OUT;
            }
        }
        return null;
    }

    private MenuStylesKeyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

