/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.IAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.util.ChartUtil;

public class VerticalAxisAdjuster
implements IAxisAdjuster {
    private OneAxis fVerticalAxis;
    private OneAxis fHorizontalAxis;
    private PlotWithAxes fPlotWithAxes;
    private Bounds fPlotBounds;
    private double fAxisX;
    private double fAxisLeftEdge;
    private double fAxisRightEdge;
    private AutoScale scX;
    private AutoScale scY;
    private int iXLabelLocation;
    private int iYLabelLocation;
    private int iYTitleLocation;
    private Label laXAxisLabels;
    private Label laYAxisLabels;
    private Label laYAxisTitle;
    private int iYTickStyle;
    private double dX;
    private double dX1;
    private double dX2;
    private double dAppliedYAxisPlotSpacing;
    private boolean bTicksLeft;
    private boolean bTicksRight;
    private double dWTotal;
    private double dYAxisLabelsThickness;
    private double[] dDecorationThickness = new double[]{0.0, 0.0};
    private double dYAxisTitleThickness = 0.0;
    private IDisplayServer ids;
    private AllAxes aax;
    private IntersectionValue iv;
    private double dLeftWidth;
    private double dRightWidth;

    public VerticalAxisAdjuster(OneAxis verticalAxis, OneAxis horizontalAxis, PlotWithAxes plotWithAxes, Bounds boPlot) {
        this.fVerticalAxis = verticalAxis;
        this.fHorizontalAxis = horizontalAxis;
        this.fPlotWithAxes = plotWithAxes;
        this.fPlotBounds = boPlot;
    }

    OneAxis getVerticalAxis() {
        return this.fVerticalAxis;
    }

    double getAxisX() {
        return this.fAxisX;
    }

    double getAxisLeftEdge() {
        return this.fAxisLeftEdge;
    }

    double getAxisRightEdge() {
        return this.fAxisRightEdge;
    }

    double getAxisLabelThickness() {
        return this.dYAxisLabelsThickness;
    }

    double getAxisTitleThickness() {
        return this.dYAxisTitleThickness;
    }

    private void init() throws ChartException {
        double dFixedLabelThickness;
        OneAxis axPH = this.fHorizontalAxis;
        OneAxis axPV = this.fVerticalAxis;
        this.aax = this.fPlotWithAxes.aax;
        double dYAxisPlotSpacing = this.fPlotWithAxes.getVerticalSpacingInPixels();
        this.ids = this.fPlotWithAxes.getDisplayServer();
        RunTimeContext rtc = this.fPlotWithAxes.getRunTimeContext();
        this.iv = this.fVerticalAxis.getIntersectionValue();
        this.scX = axPH.getScale();
        this.scY = axPV.getScale();
        this.iXLabelLocation = axPH.getLabelPosition();
        this.iYLabelLocation = axPV.getLabelPosition();
        this.iYTitleLocation = axPV.getTitlePosition();
        this.laXAxisLabels = axPH.getLabel();
        this.laYAxisLabels = axPV.getLabel();
        this.laYAxisTitle = axPV.getTitle();
        this.iYTickStyle = axPV.getCombinedTickStyle();
        IntersectionValue iv = axPV.getIntersectionValue();
        this.bTicksLeft = (this.iYTickStyle & 1) == 1;
        this.bTicksRight = (this.iYTickStyle & 2) == 2;
        this.dAppliedYAxisPlotSpacing = (iv.iType == 1 || iv.iType == 2) && !this.fVerticalAxis.getModelAxis().isLabelWithinAxes() ? dYAxisPlotSpacing : 0.0;
        double dStart = this.scY.getStart();
        double dEnd = this.scY.getEnd();
        this.scY.computeTicks(this.ids, this.laYAxisLabels, this.iYLabelLocation, 1, dStart, dEnd, true, this.aax);
        if (!this.scY.isStepFixed()) {
            Object[] oaMinMax = this.scY.getMinMax();
            while (!this.scY.checkFit(this.ids, this.laYAxisLabels, this.iYLabelLocation)) {
                if (!this.scY.zoomOut()) break;
                this.scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                int tickCount = this.scY.computeTicks(this.ids, this.laYAxisLabels, this.iYLabelLocation, 1, dStart, dEnd, true, this.aax);
                if (this.scY.getUnit() != null && PlotWithAxes.asInteger(this.scY.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
            }
        }
        this.dYAxisLabelsThickness = this.scY.computeAxisLabelThickness(this.ids, axPV.getLabel(), 1);
        Series[] sea = this.fPlotWithAxes.getModel().getSeries(2);
        Map<Series, LegendItemRenderingHints> seriesRenderingHints = rtc.getSeriesRenderers();
        int i = 0;
        while (i < sea.length) {
            IAxesDecorator iad;
            LegendItemRenderingHints lirh = seriesRenderingHints.get(sea[i]);
            if (lirh != null && lirh.getRenderer() instanceof AxesRenderer && (iad = ((AxesRenderer)lirh.getRenderer()).getAxesDecorator(axPV)) != null) {
                double[] thickness = iad.computeDecorationThickness(this.ids, axPV);
                if (thickness[0] > this.dDecorationThickness[0]) {
                    this.dDecorationThickness[0] = thickness[0];
                }
                if (thickness[1] > this.dDecorationThickness[1]) {
                    this.dDecorationThickness[1] = thickness[1];
                }
            }
            ++i;
        }
        this.dYAxisTitleThickness = 0.0;
        this.computeTitleThickness();
        this.dX1 = this.dX = PlotWithAxes.getLocation(this.scX, iv);
        this.dX2 = this.dX;
        this.dWTotal = Math.abs(this.scX.getStart() - this.scX.getEnd());
        if (axPV.getModelAxis().isSetLabelSpan() && (dFixedLabelThickness = axPV.getModelAxis().getLabelSpan() * this.fPlotWithAxes.getPointToPixel()) < this.dWTotal - 2.0 * this.fPlotWithAxes.getTickSize()) {
            if (this.dYAxisLabelsThickness + this.dYAxisTitleThickness > dFixedLabelThickness) {
                axPV.setShowLabels(false);
            }
            if (this.dYAxisTitleThickness > dFixedLabelThickness) {
                this.laYAxisTitle.setVisible(false);
                this.dYAxisTitleThickness = 0.0;
            }
            this.dYAxisLabelsThickness = dFixedLabelThickness;
        }
    }

    private void computeTitleThickness() throws ChartException {
        if (this.laYAxisTitle.isVisible()) {
            String sPreviousValue = this.laYAxisTitle.getCaption().getValue();
            this.laYAxisTitle.getCaption().setValue(this.fPlotWithAxes.getRunTimeContext().externalizedMessage(sPreviousValue));
            double maxWidth = 0.3 * this.fPlotBounds.getWidth();
            double maxHeight = this.fPlotBounds.getHeight();
            if (ChartUtil.isStudyLayout(this.fPlotWithAxes.getModel())) {
                maxHeight = Math.abs(this.fVerticalAxis.getScale().getEndPoints()[1] - this.fVerticalAxis.getScale().getEndPoints()[0]);
            }
            LabelLimiter lblLimit = new LabelLimiter(maxWidth, maxHeight, 0.0);
            lblLimit.computeWrapping(this.ids, this.laYAxisTitle);
            lblLimit = lblLimit.limitLabelSize(this.fPlotWithAxes.getChartComputation(), this.ids, this.laYAxisTitle, EnumSet.of(LabelLimiter.Option.FIX_HEIGHT));
            this.fPlotWithAxes.putLabelLimiter(this.fVerticalAxis.getModelAxis().getTitle(), lblLimit);
            this.dYAxisTitleThickness = lblLimit.getMaxWidth();
            this.laYAxisTitle.getCaption().setValue(sPreviousValue);
        }
    }

    public void adjust() throws ChartException {
        this.init();
        int iv = this.fVerticalAxis.getIntersectionValue().getType();
        switch (iv) {
            case 2: {
                this.computeXLocationWithMinOrigin();
                break;
            }
            case 1: {
                this.computeXLocationWithMaxOrigin();
                break;
            }
            default: {
                this.computeXLocatoinWithValueOrigin();
            }
        }
    }

    private void computeXLocationWithMinOrigin() throws ChartException, IllegalArgumentException {
        double dW2Delta = 0.0;
        if (this.scX.getDirection() == -1) {
            this.dX = PlotWithAxes.getLocation(this.scX, IntersectionValue.MAX_VALUE);
        }
        this.dX -= this.dAppliedYAxisPlotSpacing;
        double dX1 = this.dX;
        double dX2 = this.dX;
        double dTickSize = this.fPlotWithAxes.getTickSize();
        if (this.bTicksLeft && dTickSize <= this.dWTotal) {
            dX1 -= this.fPlotWithAxes.getTickSize();
            this.dWTotal -= dTickSize;
        } else {
            dTickSize = 0.0;
        }
        double dW1 = 0.0;
        double dW2 = 0.0;
        if (this.iYLabelLocation == 1) {
            dW1 = Math.max(this.dYAxisLabelsThickness, this.dDecorationThickness[0]);
            dW2 = Math.max(this.bTicksRight ? this.fPlotWithAxes.getTickSize() : 0.0, this.dAppliedYAxisPlotSpacing);
        } else if (this.iYLabelLocation == 2) {
            dW1 = this.dDecorationThickness[0];
            double dAcutalW2 = Math.max((this.bTicksRight ? this.fPlotWithAxes.getTickSize() : 0.0) + this.dYAxisLabelsThickness, this.dAppliedYAxisPlotSpacing);
            dW2 = Math.max(this.bTicksRight ? this.fPlotWithAxes.getTickSize() : 0.0, this.dAppliedYAxisPlotSpacing);
            dW2Delta = dAcutalW2 - dW2;
        }
        if (dW1 + dW2 <= this.dWTotal) {
            dX1 -= dW1;
            dX2 += dW2;
            this.dWTotal -= dW1 + dW2;
        } else {
            this.fVerticalAxis.setShowLabels(false);
        }
        if (this.iYTitleLocation == 1) {
            dX1 -= this.dYAxisTitleThickness;
        } else if (this.iYTitleLocation == 2) {
            dW2Delta += this.dYAxisTitleThickness;
        }
        double dBlockX = this.fPlotBounds.getLeft();
        if (dX1 < dBlockX) {
            double dDelta = dBlockX - dX1;
            dX1 = dBlockX;
            this.dX += dDelta;
            dX2 += dDelta;
        }
        this.fAxisX = this.dX;
        this.fAxisLeftEdge = dX1;
        this.fAxisRightEdge = dX2;
        this.dLeftWidth = this.dX - dX1;
        this.dRightWidth = dX2 - this.dX + dW2Delta;
    }

    private void computeXLocationWithMaxOrigin() throws ChartException, IllegalArgumentException {
        double dW1Delta = 0.0;
        if (this.scX.getDirection() == -1) {
            this.dX = PlotWithAxes.getLocation(this.scX, IntersectionValue.MIN_VALUE);
        }
        this.dX += this.dAppliedYAxisPlotSpacing;
        this.dWTotal -= this.dAppliedYAxisPlotSpacing;
        double dX1 = this.dX;
        double dX2 = this.dX;
        if (this.bTicksRight && this.fPlotWithAxes.getTickSize() <= this.dWTotal) {
            dX2 += this.fPlotWithAxes.getTickSize();
            this.dWTotal -= this.fPlotWithAxes.getTickSize();
        }
        double dW1 = 0.0;
        double dW2 = 0.0;
        if (this.iYLabelLocation == 2) {
            dW1 = Math.max((this.bTicksLeft ? this.fPlotWithAxes.getTickSize() : 0.0) + this.dDecorationThickness[0], this.dAppliedYAxisPlotSpacing);
            dW2 = Math.max(this.dYAxisLabelsThickness, this.dDecorationThickness[1]);
        } else if (this.iYLabelLocation == 1) {
            double dActualW1 = Math.max((this.bTicksLeft ? this.fPlotWithAxes.getTickSize() : 0.0) + Math.max(this.dYAxisLabelsThickness, this.dDecorationThickness[0]), this.dAppliedYAxisPlotSpacing);
            dW1 = Math.max(this.bTicksLeft ? this.fPlotWithAxes.getTickSize() : 0.0, this.dAppliedYAxisPlotSpacing);
            dW1Delta = dActualW1 - dW1;
            dW2 = this.dDecorationThickness[1];
        }
        if (dW1 + dW2 <= this.dWTotal) {
            dX1 -= dW1;
            dX2 += dW2;
            this.dWTotal -= dW1 + dW2;
        } else {
            this.fVerticalAxis.setShowLabels(false);
        }
        if (this.iYTitleLocation == 2) {
            dX2 += this.dYAxisTitleThickness;
        } else if (this.iYTitleLocation == 1) {
            dW1Delta += this.dYAxisTitleThickness;
        }
        double dBlockX = this.fPlotBounds.getLeft();
        double dBlockWidth = this.fPlotBounds.getWidth();
        if (dX2 > dBlockX + dBlockWidth) {
            double dDelta = dX2 - (dBlockX + dBlockWidth);
            dX2 = dBlockX + dBlockWidth;
            this.dX -= dDelta;
            dX1 -= dDelta;
        }
        this.fAxisX = this.dX;
        this.fAxisLeftEdge = dX1;
        this.fAxisRightEdge = dX2;
        this.dLeftWidth = this.dX - dX1 + dW1Delta;
        this.dRightWidth = dX2 - dX1;
    }

    private void computeXLocatoinWithValueOrigin() throws ChartException {
        double dDeltaX1 = 0.0;
        double dDeltaX2 = 0.0;
        double dBlockX = this.fPlotBounds.getLeft();
        double dBlockWidth = this.fPlotBounds.getWidth();
        if (this.iYTitleLocation == 2) {
            this.dX2 += this.dYAxisTitleThickness;
        } else if (this.iYTitleLocation == 1) {
            this.dX1 -= this.dYAxisTitleThickness;
        }
        double dW1 = 0.0;
        double dW2 = 0.0;
        if (this.iYLabelLocation == 1) {
            Object[] oaMinMax;
            dW1 = (this.bTicksLeft ? this.fPlotWithAxes.getTickSize() : 0.0) + Math.max(this.dYAxisLabelsThickness, this.dDecorationThickness[0]);
            double d = dW2 = this.bTicksRight ? this.fPlotWithAxes.getTickSize() : 0.0;
            if (dW1 + dW2 <= this.dWTotal) {
                this.dX1 -= dW1;
                this.dX2 += dW2;
                this.dWTotal -= dW1 + dW2;
            } else {
                this.fVerticalAxis.setShowLabels(false);
            }
            dDeltaX1 = this.dX - this.dX1;
            dDeltaX2 = this.dX2 - this.dX;
            if (this.dX1 < dBlockX) {
                oaMinMax = this.scX.getMinMax();
                boolean bForceBreak = false;
                do {
                    double dStart;
                    double dEnd;
                    double dDelta;
                    double dAMax_RI;
                    double dAMin_AMax;
                    this.scX.setEndPoints(this.scX.getStart() - this.scX.getStartShift(), this.scX.getEnd() + this.scX.getEndShift());
                    this.scX.resetShifts();
                    double[] da = this.scX.getEndPoints();
                    double dT_RI = dBlockX - this.dX1;
                    if (this.scX.getDirection() == -1) {
                        dAMin_AMax = da[0] - da[1];
                        dAMax_RI = Math.abs(da[0] - this.dX);
                        dDelta = dT_RI / dAMax_RI * dAMin_AMax;
                        dEnd = da[1] + dDelta;
                        dStart = da[0];
                        if (dEnd < dBlockX) {
                            dEnd = dBlockX;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[1] - da[0];
                        dAMax_RI = Math.abs(da[1] - this.dX);
                        dDelta = dT_RI / dAMax_RI * dAMin_AMax;
                        dStart = da[0] + dDelta;
                        dEnd = da[1];
                        if (dStart < dBlockX) {
                            dStart = dBlockX;
                            bForceBreak = true;
                        }
                    }
                    this.scX.setEndPoints(dStart, dEnd);
                    this.scX.computeTicks(this.ids, this.laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, this.aax);
                    while (!this.scX.checkFit(this.ids, this.laXAxisLabels, this.iXLabelLocation)) {
                        if (!this.scX.zoomOut()) {
                            bForceBreak = true;
                            break;
                        }
                        this.scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = this.scX.computeTicks(this.ids, this.laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, this.aax);
                        if ((this.scX.getUnit() == null || PlotWithAxes.asInteger(this.scX.getUnit()) != 1 || tickCount > 3) && !this.fPlotWithAxes.isSharedScale()) continue;
                        bForceBreak = true;
                        break;
                    }
                    this.dX = PlotWithAxes.getLocation(this.scX, this.iv);
                    this.dX1 = this.dX - dDeltaX1;
                } while (Math.abs(this.dX1 - dBlockX) > 1.0 && !bForceBreak);
            } else {
                double dStart = this.scX.getStart();
                double dEnd = this.scX.getEnd();
                this.scX.setEndPoints(dStart, dEnd);
                this.scX.computeTicks(this.ids, this.laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, this.aax);
                if (!this.scX.isStepFixed()) {
                    oaMinMax = this.scX.getMinMax();
                    while (!this.scX.checkFit(this.ids, this.laXAxisLabels, this.iXLabelLocation)) {
                        if (!this.scX.zoomOut()) break;
                        this.scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = this.scX.computeTicks(this.ids, this.laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, this.aax);
                        if (this.scX.getUnit() != null && PlotWithAxes.asInteger(this.scX.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                    }
                }
                this.dX = PlotWithAxes.getLocation(this.scX, this.iv);
            }
            this.dX1 = this.dX - dDeltaX1;
            this.dX2 = this.dX + dDeltaX2;
        } else if (this.iYLabelLocation == 2) {
            dW1 = this.bTicksLeft ? this.fPlotWithAxes.getTickSize() : 0.0;
            if (dW1 + (dW2 = (this.bTicksRight ? this.fPlotWithAxes.getTickSize() : 0.0) + Math.max(this.dYAxisLabelsThickness, this.dDecorationThickness[1])) <= this.dWTotal) {
                this.dX1 -= dW1;
                this.dX2 += dW2;
                this.dWTotal -= dW1 + dW2;
            }
            dDeltaX1 = this.dX - this.dX1;
            dDeltaX2 = this.dX2 - this.dX;
            if (this.dX2 > dBlockX + dBlockWidth) {
                Object[] oaMinMax = this.scX.getMinMax();
                boolean bForceBreak = false;
                do {
                    double dEnd;
                    double dStart;
                    double dDelta;
                    double dAMin_RI;
                    double dAMin_AMax;
                    this.scX.setEndPoints(this.scX.getStart() - this.scX.getStartShift(), this.scX.getEnd() + this.scX.getEndShift());
                    this.scX.resetShifts();
                    double[] da = this.scX.getEndPoints();
                    double dT_RI = this.dX2 - (dBlockX + dBlockWidth);
                    if (this.scX.getDirection() == -1) {
                        dAMin_AMax = da[0] - da[1];
                        dAMin_RI = Math.abs(this.dX - da[1]);
                        dDelta = Math.abs(dT_RI / dAMin_RI) * dAMin_AMax;
                        dStart = da[0] - dDelta;
                        dEnd = da[1];
                        if (dStart > dBlockX + dBlockWidth) {
                            dStart = dBlockX + dBlockWidth;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[1] - da[0];
                        dAMin_RI = Math.abs(this.dX - da[0]);
                        dDelta = dT_RI / dAMin_RI * dAMin_AMax;
                        dEnd = da[1] - dDelta;
                        dStart = da[0];
                        if (dEnd > dBlockX + dBlockWidth) {
                            dEnd = dBlockX + dBlockWidth;
                            bForceBreak = true;
                        }
                    }
                    this.scX.setEndPoints(dStart, dEnd);
                    this.scX.computeTicks(this.ids, this.laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, this.aax);
                    if (!this.scX.isStepFixed()) {
                        while (!this.scX.checkFit(this.ids, this.laXAxisLabels, this.iXLabelLocation)) {
                            if (!this.scX.zoomOut()) {
                                bForceBreak = true;
                                break;
                            }
                            this.scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = this.scX.computeTicks(this.ids, this.laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, this.aax);
                            if ((this.scX.getUnit() == null || PlotWithAxes.asInteger(this.scX.getUnit()) != 1 || tickCount > 3) && !this.fPlotWithAxes.isSharedScale()) continue;
                            bForceBreak = true;
                            break;
                        }
                    }
                    this.dX = PlotWithAxes.getLocation(this.scX, this.iv);
                    this.dX2 = this.dX + dDeltaX2;
                } while (Math.abs(this.dX2 - (dBlockX + dBlockWidth)) > 1.0 && !bForceBreak);
            } else {
                double delta = dBlockX - this.dX1;
                double dStart = this.dX1 < dBlockX && this.dX2 + delta < dBlockX + dBlockWidth ? this.scX.getStart() + delta : this.scX.getStart();
                double dEnd = this.scX.getEnd();
                this.scX.setEndPoints(dStart, dEnd);
                this.scX.computeTicks(this.ids, this.laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, this.aax);
                if (!this.scX.isStepFixed()) {
                    Object[] oaMinMax = this.scX.getMinMax();
                    while (!this.scX.checkFit(this.ids, this.laXAxisLabels, this.iXLabelLocation)) {
                        if (!this.scX.zoomOut()) break;
                        this.scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = this.scX.computeTicks(this.ids, this.laXAxisLabels, this.iXLabelLocation, 0, dStart, dEnd, true, this.aax);
                        if (this.scX.getUnit() != null && PlotWithAxes.asInteger(this.scX.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                    }
                }
                this.dX = PlotWithAxes.getLocation(this.scX, this.iv);
            }
            this.dX2 = this.dX + dDeltaX2;
            this.dX1 = this.dX - dDeltaX1;
        }
        if (this.dX1 < this.fPlotBounds.getLeft()) {
            double dDelta = dBlockX - this.dX1;
            this.dX1 = dBlockX;
            this.dX += dDelta;
            this.dX2 += dDelta;
        }
        this.fAxisX = this.dX;
        this.fAxisLeftEdge = this.dX1;
        this.fAxisRightEdge = this.dX2;
        this.dLeftWidth = this.dX - this.dX1;
        this.dRightWidth = this.dX2 - this.dX;
    }

    double getLeftWidth() {
        return this.dLeftWidth;
    }

    double getRightWidth() {
        return this.dRightWidth;
    }
}

