/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.util.ArrayList;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxesAdjuster;
import org.eclipse.birt.chart.computation.withaxes.IAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.VerticalAxisAdjuster;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Label;

public class VerticalAxesAdjuster
implements IAxisAdjuster {
    private OneAxis[] fVerticalAxes;
    private OneAxis fHorizontalAxis;
    private PlotWithAxes fPlotWithAxes;
    private Bounds fPlotBounds;

    public VerticalAxesAdjuster(OneAxis[] verticalAxes, OneAxis horizontalAxis, PlotWithAxes plotWithAxes, Bounds boPlot) {
        this.fVerticalAxes = verticalAxes;
        this.fHorizontalAxis = horizontalAxis;
        this.fPlotWithAxes = plotWithAxes;
        this.fPlotBounds = boPlot;
    }

    public void adjust() throws ChartException {
        double iYTitleLocation;
        VerticalAxisAdjuster vaa;
        AutoScale scX = this.fHorizontalAxis.getScale();
        ArrayList<VerticalAxisAdjuster> values = new ArrayList<VerticalAxisAdjuster>();
        ArrayList<VerticalAxisAdjuster> min = new ArrayList<VerticalAxisAdjuster>();
        ArrayList<VerticalAxisAdjuster> max = new ArrayList<VerticalAxisAdjuster>();
        OneAxis[] oneAxisArray = this.fVerticalAxes;
        int n = this.fVerticalAxes.length;
        int n2 = 0;
        while (n2 < n) {
            OneAxis oa = oneAxisArray[n2];
            VerticalAxisAdjuster vaa2 = new VerticalAxisAdjuster(oa, this.fHorizontalAxis, this.fPlotWithAxes, this.fPlotBounds);
            int iv = oa.getIntersectionValue().getType();
            switch (iv) {
                case 2: {
                    min.add(vaa2);
                    break;
                }
                case 1: {
                    max.add(vaa2);
                    break;
                }
                default: {
                    values.add(vaa2);
                }
            }
            ++n2;
        }
        boolean onlyValueOrigin = values.size() > 0 && min.size() == 0 && max.size() == 0;
        double x = Double.NaN;
        double left = Double.NaN;
        double right = Double.NaN;
        double[] endPoints = scX.getEndPoints();
        int i = 0;
        while (i < values.size()) {
            scX.setEndPoints(endPoints[0], endPoints[1]);
            scX.resetShifts();
            vaa = (VerticalAxisAdjuster)values.get(i);
            vaa.adjust();
            double locationDelta = AxesAdjuster.getLocationDelta(scX, vaa.getVerticalAxis().getIntersectionValue());
            if (locationDelta <= 0.0 || vaa.getAxisLeftEdge() <= endPoints[0]) {
                min.add(vaa);
            } else if (vaa.getAxisRightEdge() >= endPoints[1]) {
                max.add(vaa);
            }
            ++i;
        }
        i = 0;
        while (i < min.size()) {
            boolean isMinOrigin;
            scX.setEndPoints(endPoints[0], endPoints[1]);
            scX.resetShifts();
            vaa = (VerticalAxisAdjuster)min.get(i);
            vaa.adjust();
            boolean bl = isMinOrigin = vaa.getVerticalAxis().getIntersectionValue().getType() == 2;
            if (Double.isNaN(x)) {
                if (isMinOrigin) {
                    x = vaa.getAxisX();
                    left = vaa.getAxisLeftEdge();
                    right = vaa.getAxisRightEdge();
                } else {
                    x = vaa.getLeftWidth() <= scX.getStart() ? vaa.getAxisX() : scX.getStart();
                    left = vaa.getAxisLeftEdge() < x ? vaa.getAxisLeftEdge() : x;
                    right = x;
                }
            } else {
                double deltaX1 = x - left;
                double deltaX2 = right - x;
                if (isMinOrigin) {
                    if (vaa.getAxisX() > x) {
                        x = vaa.getAxisX();
                    }
                    left = x - Math.max(deltaX1, vaa.getAxisX() - vaa.getAxisLeftEdge());
                    right = x + Math.max(deltaX2, vaa.getAxisRightEdge() - vaa.getAxisX());
                } else {
                    if (scX.getEndPoints()[0] > x) {
                        x = scX.getEndPoints()[0];
                    }
                    left = x - Math.max(deltaX1, scX.getEndPoints()[0] - vaa.getAxisLeftEdge());
                    right = x + deltaX2;
                }
            }
            ++i;
        }
        if (!Double.isNaN(x)) {
            scX.setEndPoints(x, endPoints[1]);
            scX.resetShifts();
            double[] positions = this.adjustAcrossAxis(onlyValueOrigin ? 3 : 2, this.fHorizontalAxis, x, left, right);
            x = positions[0];
            left = positions[1];
            right = positions[2];
        }
        i = 0;
        while (i < min.size()) {
            vaa = (VerticalAxisAdjuster)min.get(i);
            OneAxis oa = vaa.getVerticalAxis();
            oa.setAxisCoordinate(x);
            iYTitleLocation = oa.getTitlePosition();
            oa.setTitleCoordinate(iYTitleLocation == 1.0 ? x - vaa.getLeftWidth() - 1.0 : x + vaa.getRightWidth() - vaa.getAxisTitleThickness() + 1.0);
            ++i;
        }
        x = Double.NaN;
        left = Double.NaN;
        right = Double.NaN;
        endPoints = scX.getEndPoints();
        i = 0;
        while (i < max.size()) {
            scX.setEndPoints(endPoints[0], endPoints[1]);
            scX.resetShifts();
            vaa = (VerticalAxisAdjuster)max.get(i);
            vaa.adjust();
            if (Double.isNaN(x)) {
                x = vaa.getAxisX();
                left = vaa.getAxisLeftEdge();
                right = vaa.getAxisRightEdge();
            } else {
                double deltaX1 = x - left;
                double deltaX2 = right - x;
                if (vaa.getAxisX() < x) {
                    x = vaa.getAxisX();
                    left = x - Math.max(deltaX1, x - vaa.getAxisLeftEdge());
                    right = x + Math.max(deltaX2, vaa.getAxisRightEdge() - x);
                }
            }
            ++i;
        }
        if (!Double.isNaN(x)) {
            scX.setEndPoints(endPoints[0], endPoints[1]);
            scX.resetShifts();
            double[] positions = this.adjustAcrossAxis(onlyValueOrigin ? 3 : 1, this.fHorizontalAxis, x, left, right);
            x = positions[0];
            left = positions[1];
            right = positions[2];
        }
        i = 0;
        while (i < max.size()) {
            OneAxis oa;
            vaa = (VerticalAxisAdjuster)max.get(i);
            iYTitleLocation = (oa = vaa.getVerticalAxis()).getTitlePosition();
            oa.setTitleCoordinate(iYTitleLocation == 1.0 ? x - vaa.getLeftWidth() - 1.0 : x + vaa.getRightWidth() - vaa.getAxisTitleThickness() + 1.0);
            oa.setAxisCoordinate(x);
            ++i;
        }
        i = 0;
        while (i < values.size()) {
            vaa = (VerticalAxisAdjuster)values.get(i);
            OneAxis oa = vaa.getVerticalAxis();
            iYTitleLocation = oa.getTitlePosition();
            double axisCoordinate = 0.0;
            double locationDelta = AxesAdjuster.getLocationDelta(scX, vaa.getVerticalAxis().getIntersectionValue());
            axisCoordinate = scX.getEndPoints()[0] + locationDelta;
            double axisTitleCoordinate = iYTitleLocation == 1.0 ? axisCoordinate - (vaa.getAxisX() - vaa.getAxisLeftEdge()) - 1.0 : axisCoordinate + 1.0 + (oa.getLabelPosition() == 1 ? 0.0 : vaa.getAxisLabelThickness());
            oa.setAxisCoordinate(axisCoordinate);
            oa.setTitleCoordinate(axisTitleCoordinate);
            ++i;
        }
        scX.computeTicks(this.fPlotWithAxes.getDisplayServer(), this.fHorizontalAxis.getLabel(), this.fHorizontalAxis.getLabelPosition(), 0, scX.getStart(), scX.getEnd(), false, this.fPlotWithAxes.getAxes());
        scX.resetShifts();
    }

    double[] adjustAcrossAxis(int iv, OneAxis acrossAxis, double dX, double dLeftEdge, double dRightEdge) throws ChartException {
        IDisplayServer ids = this.fPlotWithAxes.getDisplayServer();
        AutoScale scX = acrossAxis.getScale();
        AllAxes aax = this.fPlotWithAxes.getAxes();
        Label laXAxisLabels = acrossAxis.getLabel();
        int iXLabelLocation = acrossAxis.getLabelPosition();
        double dYAxisThickness = dRightEdge - dLeftEdge;
        double dDeltaX2 = dRightEdge - dX;
        double dDeltaX1 = dX - dLeftEdge;
        if (iv == 2) {
            double dStart;
            double dEnd;
            scX.computeAxisStartEndShifts(ids, laXAxisLabels, 0, iXLabelLocation, aax);
            boolean startEndChanged = false;
            if (scX.getDirection() == -1) {
                dEnd = dRightEdge;
                dStart = scX.getStart();
                startEndChanged = true;
            } else {
                dStart = dRightEdge;
                dEnd = scX.getEnd();
                startEndChanged = true;
            }
            scX.resetShifts();
            scX.setEndPoints(dStart, dEnd);
            boolean considerStartLabel = false;
            boolean considerEndLabel = false;
            if (scX.getDirection() == -1) {
                considerEndLabel = !startEndChanged;
            } else {
                considerStartLabel = !startEndChanged;
            }
            scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
            if (!scX.isStepFixed()) {
                Object[] oaMinMax = scX.getMinMax();
                while (!scX.checkFit(ids, laXAxisLabels, iXLabelLocation)) {
                    if (!scX.zoomOut()) break;
                    scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
                    if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                }
            }
            if (scX.getDirection() == -1) {
                if (dYAxisThickness < scX.getEndShift()) {
                    dX = scX.getEnd() - (dRightEdge - dX);
                }
            } else if (dYAxisThickness < scX.getStartShift()) {
                dX = scX.getStart() - (dRightEdge - dX);
            }
            dRightEdge = (dX -= this.fPlotWithAxes.getPlotInsets().getLeft()) + dDeltaX2;
            dLeftEdge = dX - dDeltaX1;
        } else if (iv == 1) {
            double dEnd;
            double dStart;
            scX.computeAxisStartEndShifts(ids, laXAxisLabels, 0, iXLabelLocation, aax);
            boolean startEndChanged = false;
            if (scX.getDirection() == -1) {
                if (dYAxisThickness > scX.getStartShift()) {
                    dStart = dLeftEdge;
                    startEndChanged = true;
                } else {
                    dStart = scX.getStart();
                }
                dEnd = scX.getEnd();
            } else {
                if (dYAxisThickness > scX.getEndShift()) {
                    dEnd = dLeftEdge;
                    startEndChanged = true;
                } else {
                    dEnd = scX.getEnd();
                }
                dStart = scX.getStart();
            }
            scX.resetShifts();
            scX.setEndPoints(dStart, dEnd);
            boolean considerStartLabel = false;
            boolean considerEndLabel = false;
            if (scX.getDirection() == -1) {
                considerStartLabel = !startEndChanged;
            } else {
                considerEndLabel = !startEndChanged;
            }
            scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
            if (!scX.isStepFixed()) {
                Object[] oaMinMax = scX.getMinMax();
                while (!scX.checkFit(ids, laXAxisLabels, iXLabelLocation)) {
                    if (!scX.zoomOut()) break;
                    scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
                    if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                }
            }
            if (scX.getDirection() == -1) {
                if (dYAxisThickness < scX.getStartShift()) {
                    dX = scX.getStart() - (dLeftEdge - dX);
                }
            } else if (dYAxisThickness < scX.getEndShift()) {
                dX = scX.getEnd() - (dLeftEdge - dX);
            }
            dRightEdge = (dX += this.fPlotWithAxes.getPlotInsets().getRight()) + dDeltaX2;
            dLeftEdge = dX - dDeltaX1;
        } else {
            scX.computeAxisStartEndShifts(ids, laXAxisLabels, 0, iXLabelLocation, aax);
            boolean startEndChanged = false;
            double dStart = scX.getStart();
            double dEnd = scX.getEnd();
            if (dLeftEdge <= scX.getStart()) {
                dStart = dX;
                startEndChanged = true;
            } else if (dX >= scX.getEnd()) {
                dEnd = dX;
                startEndChanged = true;
            }
            scX.resetShifts();
            scX.setEndPoints(dStart, dEnd);
            boolean considerStartLabel = false;
            boolean considerEndLabel = false;
            if (scX.getDirection() == -1) {
                considerEndLabel = !startEndChanged;
            } else {
                considerStartLabel = !startEndChanged;
            }
            scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
            if (!scX.isStepFixed()) {
                Object[] oaMinMax = scX.getMinMax();
                while (!scX.checkFit(ids, laXAxisLabels, iXLabelLocation)) {
                    if (!scX.zoomOut()) break;
                    scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
                    if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                }
            }
            if (dYAxisThickness < scX.getStartShift()) {
                dX = scX.getStart() - (dRightEdge - dX);
            }
            dRightEdge = (dX -= this.fPlotWithAxes.getPlotInsets().getLeft()) + dDeltaX2;
            dLeftEdge = dX - dDeltaX1;
        }
        return new double[]{dX, dLeftEdge, dRightEdge};
    }
}

