/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.HorizontalAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWith2DAxes;
import org.eclipse.birt.chart.computation.withaxes.VerticalAxisAdjuster;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Axis;

class ValueAxesHelper {
    private AllAxes fAllAxes;
    private double fLeft;
    private double fTop;
    private double fWidth;
    private double fHeight;
    private double fPercentTotal = 0.0;
    private double[] fAllAxesPercents;
    private OneAxis[] fAllValueAxes;
    private int fCrossingIndex = 0;
    private double fBaseAxisThickness = 0.0;

    public ValueAxesHelper(PlotWith2DAxes plotWithAxes, AllAxes aax, Bounds plotBounds) throws ChartException {
        this.fAllAxes = aax;
        this.fLeft = plotBounds.getLeft();
        this.fTop = plotBounds.getTop();
        this.fWidth = plotBounds.getWidth();
        this.fHeight = plotBounds.getHeight();
        this.fAllValueAxes = new OneAxis[aax.getOverlayCount() + 1];
        this.fAllValueAxes[0] = aax.getPrimaryOrthogonal();
        int i = 1;
        while (i < this.fAllValueAxes.length) {
            this.fAllValueAxes[i] = aax.getOverlay(i - 1);
            ++i;
        }
        i = 0;
        this.fAllAxesPercents = new double[this.fAllValueAxes.length];
        OneAxis[] oneAxisArray = this.fAllValueAxes;
        int n = this.fAllValueAxes.length;
        int n2 = 0;
        while (n2 < n) {
            OneAxis axis = oneAxisArray[n2];
            this.fPercentTotal += this.getPercent(axis.getModelAxis());
            this.fAllAxesPercents[i++] = this.fPercentTotal;
            ++n2;
        }
        if (this.fAllValueAxes.length > 1) {
            this.precomputeCrossingAxisDelta(plotWithAxes, aax, plotBounds);
        }
    }

    private void precomputeCrossingAxisDelta(PlotWith2DAxes plotWithAxes, AllAxes aax, Bounds plotBounds) throws ChartException {
        boolean isMaxOrigin;
        boolean bl = isMaxOrigin = this.fAllAxes.getPrimaryBase().getIntersectionValue().iType == 1;
        if (isMaxOrigin) {
            this.fCrossingIndex = this.fAllValueAxes.length - 1;
        }
        if (!this.fAllAxes.areAxesSwapped()) {
            plotWithAxes.updateValueAxis(this.fAllValueAxes[this.fCrossingIndex], this.fTop + this.fHeight, this.fTop, plotWithAxes.getModel().isReverseCategory());
            HorizontalAxisAdjuster haa = new HorizontalAxisAdjuster(aax.getPrimaryBase(), this.fAllValueAxes[this.fCrossingIndex], plotWithAxes, plotBounds);
            haa.adjust();
            this.fBaseAxisThickness = haa.getAxisBottomEdge() - haa.getAxisTopEdge() - plotWithAxes.getHorizontalSpacingInPixels();
            if (!isMaxOrigin) {
                this.fHeight -= this.fBaseAxisThickness;
            } else {
                this.fTop += this.fBaseAxisThickness;
                this.fHeight -= this.fBaseAxisThickness;
            }
        } else {
            plotWithAxes.updateValueAxis(this.fAllValueAxes[this.fCrossingIndex], this.fLeft, this.fLeft + this.fWidth, plotWithAxes.getModel().isReverseCategory());
            VerticalAxisAdjuster haa = new VerticalAxisAdjuster(aax.getPrimaryBase(), this.fAllValueAxes[this.fCrossingIndex], plotWithAxes, plotBounds);
            haa.adjust();
            this.fBaseAxisThickness = haa.getAxisRightEdge() - haa.getAxisLeftEdge() - plotWithAxes.getVerticalSpacingInPixels();
            if (!isMaxOrigin) {
                this.fLeft += this.fBaseAxisThickness;
                this.fWidth -= this.fBaseAxisThickness;
            } else {
                this.fWidth -= this.fBaseAxisThickness;
            }
        }
        this.fAllValueAxes[this.fCrossingIndex].set((AutoScale)null);
    }

    OneAxis[] getValueAxes() {
        return this.fAllValueAxes;
    }

    double getStart(int valueAxisIndex) {
        double d;
        double start = 0.0;
        double d2 = d = this.fCrossingIndex == 0 && this.fCrossingIndex == valueAxisIndex ? this.fBaseAxisThickness : 0.0;
        start = this.fAllValueAxes.length == 1 || valueAxisIndex == 0 ? (!this.fAllAxes.areAxesSwapped() ? this.fTop + this.fHeight + d : this.fLeft - d) : (!this.fAllAxes.areAxesSwapped() ? this.fTop + this.fHeight * (1.0 - this.fAllAxesPercents[valueAxisIndex - 1] / this.fPercentTotal) + d : this.fLeft + this.fWidth * this.fAllAxesPercents[valueAxisIndex - 1] / this.fPercentTotal - d);
        return start;
    }

    double getEnd(int valueAxisIndex) {
        double d;
        double end = 0.0;
        double d2 = d = this.fCrossingIndex == this.fAllValueAxes.length - 1 && this.fCrossingIndex == valueAxisIndex ? this.fBaseAxisThickness : 0.0;
        end = this.fAllValueAxes.length == 1 ? (!this.fAllAxes.areAxesSwapped() ? this.fTop - d : this.fLeft + this.fWidth + d) : (!this.fAllAxes.areAxesSwapped() ? this.fTop + this.fHeight * (1.0 - this.fAllAxesPercents[valueAxisIndex] / this.fPercentTotal) - d : this.fLeft + this.fWidth * this.fAllAxesPercents[valueAxisIndex] / this.fPercentTotal + d);
        return end;
    }

    private double getPercent(Axis axis) {
        if (axis.isSetAxisPercent()) {
            return axis.getAxisPercent();
        }
        return 1.0;
    }
}

