/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifIFD0Descriptor
extends TagDescriptor<ExifIFD0Directory> {
    private final boolean _allowDecimalRepresentationOfRationals = true;

    public ExifIFD0Descriptor(@NotNull ExifIFD0Directory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 296: {
                return this.getResolutionDescription();
            }
            case 531: {
                return this.getYCbCrPositioningDescription();
            }
            case 282: {
                return this.getXResolutionDescription();
            }
            case 283: {
                return this.getYResolutionDescription();
            }
            case 532: {
                return this.getReferenceBlackWhiteDescription();
            }
            case 274: {
                return this.getOrientationDescription();
            }
            case 40093: {
                return this.getWindowsAuthorDescription();
            }
            case 40092: {
                return this.getWindowsCommentDescription();
            }
            case 40094: {
                return this.getWindowsKeywordsDescription();
            }
            case 40095: {
                return this.getWindowsSubjectDescription();
            }
            case 40091: {
                return this.getWindowsTitleDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getReferenceBlackWhiteDescription() {
        int[] ints = ((ExifIFD0Directory)this._directory).getIntArray(532);
        if (ints == null || ints.length < 6) {
            return null;
        }
        int blackR = ints[0];
        int whiteR = ints[1];
        int blackG = ints[2];
        int whiteG = ints[3];
        int blackB = ints[4];
        int whiteB = ints[5];
        return String.format("[%d,%d,%d] [%d,%d,%d]", blackR, blackG, blackB, whiteR, whiteG, whiteB);
    }

    @Nullable
    public String getYResolutionDescription() {
        Rational value = ((ExifIFD0Directory)this._directory).getRational(283);
        if (value == null) {
            return null;
        }
        String unit = this.getResolutionDescription();
        return String.format("%s dots per %s", value.toSimpleString(true), unit == null ? "unit" : unit.toLowerCase());
    }

    @Nullable
    public String getXResolutionDescription() {
        Rational value = ((ExifIFD0Directory)this._directory).getRational(282);
        if (value == null) {
            return null;
        }
        String unit = this.getResolutionDescription();
        return String.format("%s dots per %s", value.toSimpleString(true), unit == null ? "unit" : unit.toLowerCase());
    }

    @Nullable
    public String getYCbCrPositioningDescription() {
        return this.getIndexedDescription(531, 1, "Center of pixel array", "Datum point");
    }

    @Nullable
    public String getOrientationDescription() {
        return this.getIndexedDescription(274, 1, "Top, left side (Horizontal / normal)", "Top, right side (Mirror horizontal)", "Bottom, right side (Rotate 180)", "Bottom, left side (Mirror vertical)", "Left side, top (Mirror horizontal and rotate 270 CW)", "Right side, top (Rotate 90 CW)", "Right side, bottom (Mirror horizontal and rotate 90 CW)", "Left side, bottom (Rotate 270 CW)");
    }

    @Nullable
    public String getResolutionDescription() {
        return this.getIndexedDescription(296, 1, "(No unit)", "Inch", "cm");
    }

    @Nullable
    private String getUnicodeDescription(int tag) {
        byte[] bytes = ((ExifIFD0Directory)this._directory).getByteArray(tag);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-16LE").trim();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    @Nullable
    public String getWindowsAuthorDescription() {
        return this.getUnicodeDescription(40093);
    }

    @Nullable
    public String getWindowsCommentDescription() {
        return this.getUnicodeDescription(40092);
    }

    @Nullable
    public String getWindowsKeywordsDescription() {
        return this.getUnicodeDescription(40094);
    }

    @Nullable
    public String getWindowsTitleDescription() {
        return this.getUnicodeDescription(40091);
    }

    @Nullable
    public String getWindowsSubjectDescription() {
        return this.getUnicodeDescription(40095);
    }
}

