/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.Job;
import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReserveOperation
extends AbstractOperation<Job> {
    private static final Logger LOG = LoggerFactory.getLogger(ReserveOperation.class);
    private Reserved reserved;

    public ReserveOperation(long timeout) {
        super(new OperationFuture());
        this.command = timeout >= 0L ? "reserve-with-timeout " + timeout : "reserve";
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        if (this.reserved != null) {
            Job job = new Job();
            job.setId(this.reserved.id);
            byte[] data = new byte[this.reserved.length];
            in.get(data, 0, this.reserved.length);
            job.setData(data);
            this.future.setResult(job);
            return true;
        }
        try {
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            if (line.startsWith("TIMED_OUT")) {
                this.future.setResult(null);
                return true;
            }
            if (line.startsWith("DEADLINE_SOON")) {
                this.future.setResult(null);
                return true;
            }
            if (line.startsWith("RESERVED")) {
                this.reserved = new Reserved();
                String[] tmp = line.split("\\s+");
                this.reserved.id = Long.parseLong(tmp[1]);
                this.reserved.length = Integer.parseInt(tmp[2]);
                return false;
            }
            this.exceptionHandler(line);
        }
        catch (Exception e) {
            this.future.setException(e);
        }
        return true;
    }

    @Override
    public int expect() {
        if (this.reserved != null) {
            return this.reserved.length;
        }
        return 0;
    }

    private static class Reserved {
        long id;
        int length;

        private Reserved() {
        }
    }
}

