/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.BadFormatException;
import com.dinstone.beanstalkc.OutOfMemoryException;
import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutOperation
extends AbstractOperation<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(PutOperation.class);

    public PutOperation(int priority, int delay, int ttr, byte[] data) {
        super(new OperationFuture());
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        this.command = "put " + priority + " " + delay + " " + ttr + " " + data.length;
        this.data = data;
    }

    @Override
    public IoBuffer prepareRequest(Charset charset, String delimiter) {
        byte[] delBytes = delimiter.getBytes(charset);
        IoBuffer buffer = IoBuffer.allocate((int)64);
        buffer.setAutoExpand(true);
        buffer.put(this.command.getBytes(charset));
        buffer.put(delBytes);
        buffer.put(this.data);
        buffer.put(delBytes);
        return buffer;
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        try {
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            if (line.startsWith("INSERTED")) {
                long id = Long.parseLong(line.replaceAll("[^0-9]", ""));
                this.future.setResult(id);
                return true;
            }
            if (line.startsWith("BURIED")) {
                this.future.setException(new OutOfMemoryException("this job is buried"));
                return true;
            }
            if (line.startsWith("EXPECTED_CRLF")) {
                this.future.setException(new BadFormatException("the job body must be followed by a CR-LF pair"));
                return true;
            }
            if (line.startsWith("JOB_TOO_BIG")) {
                this.future.setException(new BadFormatException("the job's size is larger than max-job-size bytes."));
                return true;
            }
            this.exceptionHandler(line);
        }
        catch (Exception e) {
            this.future.setException(e);
        }
        return true;
    }
}

