/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.YamlUtil;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTubeOperation
extends AbstractOperation<List<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(ListTubeOperation.class);
    private int length;

    public ListTubeOperation(Type type) {
        super(new OperationFuture());
        if (type == Type.all) {
            this.command = "list-tubes";
        } else if (type == Type.used) {
            this.command = "list-tube-used";
        } else if (type == Type.watched) {
            this.command = "list-tubes-watched";
        }
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        try {
            if (this.length > 0) {
                this.future.setResult(YamlUtil.yaml2List(charset, in));
                return true;
            }
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            if (line.startsWith("USING")) {
                String[] tmp = line.split("\\s+");
                this.future.setResult(Arrays.asList(tmp[1]));
                return true;
            }
            if (line.startsWith("OK")) {
                String[] tmp = line.split("\\s+");
                this.length = Integer.parseInt(tmp[1]);
                return false;
            }
            this.exceptionHandler(line);
        }
        catch (Exception e) {
            this.future.setException(e);
        }
        return true;
    }

    @Override
    public int expect() {
        return this.length;
    }

    public static enum Type {
        all,
        used,
        watched;

    }
}

