/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.BadFormatException;
import com.dinstone.beanstalkc.DrainingException;
import com.dinstone.beanstalkc.InternalErrorException;
import com.dinstone.beanstalkc.OutOfMemoryException;
import com.dinstone.beanstalkc.UnknownCommandException;
import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.Operation;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;

public class AbstractOperation<R>
implements Operation<R> {
    protected final OperationFuture<R> future;
    protected String command;
    protected byte[] data;

    public AbstractOperation(OperationFuture<R> future) {
        this.future = future;
    }

    @Override
    public IoBuffer prepareRequest(Charset charset, String delimiter) {
        IoBuffer buffer = IoBuffer.allocate((int)64);
        buffer.setAutoExpand(true);
        buffer.put(this.command.getBytes(charset));
        buffer.put(delimiter.getBytes(charset));
        return buffer;
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        return true;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public OperationFuture<R> getOperationFuture() {
        return this.future;
    }

    @Override
    public int expect() {
        return 0;
    }

    protected void exceptionHandler(String line) {
        if (line.startsWith("OUT_OF_MEMORY")) {
            this.future.setException(new OutOfMemoryException());
        } else if (line.startsWith("INTERNAL_ERROR")) {
            this.future.setException(new InternalErrorException());
        } else if (line.startsWith("DRAINING")) {
            this.future.setException(new DrainingException());
        } else if (line.startsWith("BAD_FORMAT")) {
            this.future.setException(new BadFormatException());
        } else {
            this.future.setException(new UnknownCommandException(line));
        }
    }
}

