/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal;

import com.dinstone.beanstalkc.Configuration;
import com.dinstone.beanstalkc.internal.Connection;
import com.dinstone.beanstalkc.internal.ConnectionInitializer;
import com.dinstone.beanstalkc.internal.ConnectorKey;
import com.dinstone.beanstalkc.internal.DefaultConnection;
import com.dinstone.beanstalkc.internal.DefaultConnector;
import java.util.HashMap;
import java.util.Map;

public class ConnectionFactory {
    private static final ConnectionFactory factory = new ConnectionFactory();
    private final Map<ConnectorKey, DefaultConnector> cachedConnectors = new HashMap<ConnectorKey, DefaultConnector>();

    protected ConnectionFactory() {
    }

    public static ConnectionFactory getInstance() {
        return factory;
    }

    public Connection createConnection(Configuration config) {
        return this.createConnection(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection(Configuration config, ConnectionInitializer initer) {
        ConnectorKey ckey = new ConnectorKey(config);
        Map<ConnectorKey, DefaultConnector> map = this.cachedConnectors;
        synchronized (map) {
            DefaultConnector connector = this.cachedConnectors.get(ckey);
            if (connector == null) {
                connector = new DefaultConnector(config);
                this.cachedConnectors.put(ckey, connector);
            }
            connector.incrementRefCount();
            return new DefaultConnection(connector, initer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Configuration config) {
        ConnectorKey ckey = new ConnectorKey(config);
        Map<ConnectorKey, DefaultConnector> map = this.cachedConnectors;
        synchronized (map) {
            DefaultConnector connector = this.cachedConnectors.get(ckey);
            if (connector != null) {
                connector.decrementRefCount();
                if (connector.isZeroRefCount()) {
                    this.cachedConnectors.remove(ckey);
                    connector.dispose();
                }
            }
        }
    }
}

