/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc;

import com.dinstone.beanstalkc.BeanstalkClient;
import com.dinstone.beanstalkc.Configuration;
import com.dinstone.beanstalkc.JobConsumer;
import com.dinstone.beanstalkc.JobProducer;
import com.dinstone.beanstalkc.internal.Connection;
import com.dinstone.beanstalkc.internal.ConnectionInitializer;
import com.dinstone.beanstalkc.internal.DefaultBeanstalkClient;
import com.dinstone.beanstalkc.internal.operation.IgnoreOperation;
import com.dinstone.beanstalkc.internal.operation.UseOperation;
import com.dinstone.beanstalkc.internal.operation.WatchOperation;

public class BeanstalkClientFactory {
    private Configuration configuration = new Configuration();

    public BeanstalkClientFactory(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.configuration.merge(config);
    }

    public BeanstalkClient createBeanstalkClient() {
        return new DefaultBeanstalkClient(this.configuration, null);
    }

    public JobConsumer createJobConsumer(final String ... watchTubes) {
        final boolean ignoreDefault = this.configuration.getBoolean("IgnoreDefaultTube", false);
        ConnectionInitializer initer = new ConnectionInitializer(){

            @Override
            public void initConnection(Connection connection) throws Exception {
                if (watchTubes != null && watchTubes.length > 0) {
                    for (int i = 0; i < watchTubes.length; ++i) {
                        connection.handle(new WatchOperation(watchTubes[i])).get();
                    }
                }
                if (ignoreDefault) {
                    connection.handle(new IgnoreOperation("default")).get();
                }
            }
        };
        return new DefaultBeanstalkClient(this.configuration, initer);
    }

    public JobProducer createJobProducer(final String useTube) {
        ConnectionInitializer initer = new ConnectionInitializer(){

            @Override
            public void initConnection(Connection connection) throws Exception {
                if (useTube != null) {
                    connection.handle(new UseOperation(useTube));
                }
            }
        };
        return new DefaultBeanstalkClient(this.configuration, initer);
    }
}

