/*
 * Decompiled with CFR 0.152.
 */
package com.denghb.dbhelper.impl;

import com.denghb.dbhelper.DbHelper;
import com.denghb.dbhelper.annotation.Column;
import com.denghb.dbhelper.annotation.Id;
import com.denghb.dbhelper.paging.Paging;
import com.denghb.dbhelper.paging.PagingResult;
import com.denghb.dbhelper.utils.DbHelperUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DbHelperImpl
implements DbHelper {
    private static final Log log = LogFactory.getLog(DbHelperImpl.class);
    private JdbcTemplate jdbcTemplate;

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public DbHelperImpl() {
    }

    public DbHelperImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public boolean insert(Object object) {
        StringBuffer sql = new StringBuffer();
        StringBuffer paramsSql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("insert into ");
        sql.append(DbHelperUtils.getTableName(object.getClass()));
        sql.append(" (");
        int count = 0;
        Field idField = null;
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                Object value;
                Column column;
                String fieldName = field.getName();
                if ("serialVersionUID".equals(fieldName) || null == (column = field.getAnnotation(Column.class))) continue;
                Id id = field.getAnnotation(Id.class);
                if (null != id) {
                    idField = field;
                }
                if ((value = DbHelperUtils.getFieldValue(object, fieldName)) == null) continue;
                if (null != id) {
                    idField = null;
                }
                if (count != 0) {
                    sql.append(',');
                    paramsSql.append(',');
                }
                ++count;
                sql.append('`');
                sql.append(column.name());
                sql.append('`');
                paramsSql.append('?');
                params.add(value);
            }
            sql.append(") values (");
            sql.append(paramsSql);
            sql.append(')');
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        Object[] objects = params.toArray();
        boolean res = 1 == this.execute(sql.toString(), objects);
        try {
            if (res && null != idField) {
                Object id = this.queryForObject("SELECT LAST_INSERT_ID() as id", idField.getType(), new Object[0]);
                idField.setAccessible(true);
                idField.set(object, id);
            }
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return res;
    }

    @Override
    public boolean updateById(Object object) {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("update ");
        sql.append(DbHelperUtils.getTableName(object.getClass()));
        sql.append(" set ");
        int count = 0;
        Field idField = null;
        try {
            Field[] fields = object.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Object value;
                Field field = fields[i];
                String fieldName = field.getName();
                if ("serialVersionUID".equals(fieldName)) continue;
                Id id = field.getAnnotation(Id.class);
                if (null != id) {
                    idField = field;
                    continue;
                }
                Column column = field.getAnnotation(Column.class);
                if (null == column || (value = DbHelperUtils.getFieldValue(object, fieldName)) == null) continue;
                if (0 != count) {
                    sql.append(",");
                }
                sql.append('`');
                sql.append(column.name());
                sql.append("` = ?");
                params.add(value);
                ++count;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        sql.append(" where ");
        if (null == idField) {
            log.error((Object)"@Id not find");
            return false;
        }
        Column column = idField.getAnnotation(Column.class);
        if (null == column) {
            log.error((Object)"@Id not find");
            return false;
        }
        sql.append('`');
        sql.append(column.name());
        sql.append("` = ?");
        params.add(DbHelperUtils.getFieldValue(object, idField.getName()));
        Object[] objects = params.toArray();
        return 1 == this.execute(sql.toString(), params.toArray(objects));
    }

    @Override
    public int execute(String sql, Object ... args) {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("params:" + Arrays.toString(args)));
            log.debug((Object)("update sql:" + sql.toString()));
        }
        int res = this.jdbcTemplate.update(sql, args);
        if (log.isDebugEnabled()) {
            log.debug((Object)("execute time:" + (System.currentTimeMillis() - start) + "ms"));
        }
        return res;
    }

    @Override
    public <T> PagingResult<T> list(StringBuffer sql, Class<T> clazz, Paging paging) {
        String[] sorts;
        PagingResult<T> result = new PagingResult<T>(paging);
        Object[] objects = paging.getParams().toArray();
        long rows = paging.getRows();
        if (0L != rows) {
            String totalSql = "select count(*) ";
            String tempSql = sql.toString().toLowerCase();
            if (0 < (totalSql = totalSql + sql.substring(tempSql.indexOf("from"), sql.length())).indexOf(" group ")) {
                totalSql = "select count(*) from (" + totalSql + ") temp";
            }
            long total = this.queryForObject(totalSql, Long.class, objects);
            paging.setTotal(total);
            if (0L == total) {
                return result;
            }
        }
        if (paging.isSort() && null != (sorts = paging.getSorts()) && 0 < sorts.length) {
            int sortIndex = paging.getSortIndex();
            if (sortIndex >= sorts.length) {
                sortIndex = sorts.length - 1;
            }
            sql.append(" order by ");
            sql.append('`');
            sql.append(sorts[sortIndex]);
            sql.append('`');
            if (paging.isDesc()) {
                sql.append(" desc");
            } else {
                sql.append(" asc");
            }
        }
        if (0L != rows) {
            sql.append(" limit ");
            sql.append(paging.getStart());
            sql.append(",");
            sql.append(rows);
        }
        List<T> list = this.list(sql.toString(), clazz, objects);
        result.setList(list);
        return result;
    }

    @Override
    public <T> List<T> list(String sql, Class<T> clazz, Object ... args) {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("params:" + Arrays.toString(args)));
            log.debug((Object)("query sql:" + sql));
        }
        List list = null;
        list = null == args || 0 == args.length || args[0] == null ? (DbHelperUtils.isSingleClass(clazz) ? this.jdbcTemplate.queryForList(sql, clazz) : this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(clazz))) : (DbHelperUtils.isSingleClass(clazz) ? this.jdbcTemplate.queryForList(sql, clazz, args) : this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(clazz), args));
        if (log.isDebugEnabled()) {
            log.debug((Object)("execute time:" + (System.currentTimeMillis() - start) + "ms"));
        }
        return list;
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> clazz, Object ... args) {
        List<T> list = this.list(sql, clazz, args);
        if (null != list && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> T queryById(Class<T> clazz, Object id) {
        StringBuffer sb = new StringBuffer("select ");
        sb.append(DbHelperUtils.getTableColumnAsFieldName(clazz));
        sb.append(" from ");
        sb.append(DbHelperUtils.getTableName(clazz));
        sb.append(" where `");
        sb.append(DbHelperUtils.getIdColumn(clazz));
        sb.append("` = ?");
        String sql = sb.toString();
        List<T> list = this.list(sql, clazz, id);
        if (null != list && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> boolean deleteById(Class<T> clazz, Object id) {
        StringBuffer sb = new StringBuffer("delete from ");
        sb.append(DbHelperUtils.getTableName(clazz));
        sb.append(" where `");
        sb.append(DbHelperUtils.getIdColumn(clazz));
        sb.append("` = ?");
        return 1 == this.execute(sb.toString(), id);
    }
}

