/*
 * Decompiled with CFR 0.152.
 */
package com.denghb.dbhelper.utils;

import com.denghb.dbhelper.annotation.Column;
import com.denghb.dbhelper.annotation.Id;
import com.denghb.dbhelper.annotation.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DbHelperUtils {
    private static final Logger log = LoggerFactory.getLogger(DbHelperUtils.class);
    private static Set<Class> classes = new HashSet<Class>();

    public static <T> boolean isSingleClass(Class<T> clazz) {
        return classes.contains(clazz);
    }

    public static <T> Object getFieldValue(Object object, String fieldName) {
        String up1 = DbHelperUtils.firstCharToUpperCase(fieldName);
        Object value = null;
        try {
            Method getter = object.getClass().getMethod("get" + up1, new Class[0]);
            if (null == getter) {
                getter = object.getClass().getMethod("is" + up1, new Class[0]);
            }
            value = getter.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            log.error(fieldName + " 'get' or 'is' Method doesn't exist!", (Throwable)e);
        }
        return value;
    }

    public static String firstCharToUpperCase(String string) {
        if (StringUtils.hasText((String)string)) {
            int length = string.length();
            String first = string.substring(0, 1);
            first = first.toUpperCase();
            if (1 == length) {
                return first;
            }
            String other = string.substring(1, length);
            return first + other;
        }
        return string;
    }

    public static <T> String getTableName(Class<T> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (null == table) {
            throw new RuntimeException("not find table name...");
        }
        StringBuffer tableName = new StringBuffer("`");
        String database = table.database();
        if (StringUtils.hasText((String)database)) {
            tableName.append(database);
            tableName.append("`.`");
        }
        tableName.append(table.name());
        tableName.append("`");
        return tableName.toString();
    }

    public static <T> String getIdColumn(Class<T> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        if (null == fields) {
            throw new RuntimeException("Id Conlmn not find");
        }
        for (int i = 0; i < fields.length; ++i) {
            Column column;
            Id id;
            Field field = fields[i];
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName) || null == (id = field.getAnnotation(Id.class)) || null == (column = field.getAnnotation(Column.class))) continue;
            return column.name();
        }
        throw new RuntimeException("Id Conlmn not find");
    }

    public static <T> String getTableColumnAsFieldName(Class<T> clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Field[] fields = clazz.getDeclaredFields();
        if (null == fields) {
            return stringBuffer.toString();
        }
        int i = 0;
        for (Field field : fields) {
            Column column;
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName) || null == (column = field.getAnnotation(Column.class))) continue;
            if (0 != i) {
                stringBuffer.append(',');
            }
            stringBuffer.append('`');
            stringBuffer.append(column.name());
            stringBuffer.append("` as ");
            stringBuffer.append(fieldName);
            ++i;
        }
        return stringBuffer.toString();
    }

    public static <T> String getSelectSql(Class<T> clazz) {
        StringBuffer sql = new StringBuffer("select ");
        sql.append(DbHelperUtils.getTableColumnAsFieldName(clazz));
        sql.append(" from ");
        sql.append(DbHelperUtils.getTableName(clazz));
        return sql.toString();
    }

    static {
        classes.add(Integer.class);
        classes.add(Long.class);
        classes.add(Short.class);
        classes.add(Double.class);
        classes.add(String.class);
        classes.add(BigDecimal.class);
        classes.add(Time.class);
        classes.add(Date.class);
        classes.add(Timestamp.class);
    }
}

