/*
 * Decompiled with CFR 0.152.
 */
package com.denghb.dbhelper.impl;

import com.denghb.dbhelper.DbHelper;
import com.denghb.dbhelper.annotation.Column;
import com.denghb.dbhelper.annotation.Id;
import com.denghb.dbhelper.domain.Paging;
import com.denghb.dbhelper.domain.PagingResult;
import com.denghb.dbhelper.utils.DbHelperUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DbHelperImpl
implements DbHelper {
    private static final Logger log = LoggerFactory.getLogger(DbHelperImpl.class);
    private JdbcTemplate jdbcTemplate;

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public boolean insert(Object object) {
        StringBuffer sql = new StringBuffer();
        StringBuffer paramsSql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("insert into ");
        sql.append(DbHelperUtils.getTableName(object.getClass()));
        sql.append(" (");
        int count = 0;
        Field idField = null;
        try {
            boolean res;
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                Object value;
                Column column;
                String fieldName = field.getName();
                if ("serialVersionUID".equals(fieldName)) continue;
                Id id = field.getAnnotation(Id.class);
                if (null != id) {
                    idField = field;
                }
                if (null == (column = field.getAnnotation(Column.class)) || (value = DbHelperUtils.getFieldValue(object, fieldName)) == null) continue;
                if (count != 0) {
                    sql.append(',');
                    paramsSql.append(',');
                }
                ++count;
                sql.append('`');
                sql.append(column.name());
                sql.append('`');
                paramsSql.append('?');
                params.add(value);
            }
            sql.append(") values (");
            sql.append(paramsSql);
            sql.append(')');
            Object[] objects = params.toArray();
            boolean bl = res = 1 == this.execute(sql.toString(), objects);
            if (res && null != idField) {
                Integer id = this.queryForObject("SELECT LAST_INSERT_ID() as id", Integer.class, new Object[0]);
                idField.setAccessible(true);
                idField.set(object, id);
            }
            return res;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updateById(Object object) {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("update ");
        sql.append(DbHelperUtils.getTableName(object.getClass()));
        sql.append(" set ");
        int count = 0;
        Field idField = null;
        try {
            Field[] fields = object.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Object value;
                Field field = fields[i];
                String fieldName = field.getName();
                if ("serialVersionUID".equals(fieldName)) continue;
                Id id = field.getAnnotation(Id.class);
                if (null != id) {
                    idField = field;
                    continue;
                }
                Column column = field.getAnnotation(Column.class);
                if (null == column || (value = DbHelperUtils.getFieldValue(object, fieldName)) == null) continue;
                if (0 != count) {
                    sql.append(",");
                }
                sql.append('`');
                sql.append(column.name());
                sql.append("` = ?");
                params.add(value);
                ++count;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        sql.append(" where ");
        if (null == idField) {
            throw new RuntimeException("Id Error");
        }
        Column column = idField.getAnnotation(Column.class);
        if (null == column) {
            throw new RuntimeException("Id Error");
        }
        sql.append('`');
        sql.append(column.name());
        sql.append("` = ?");
        params.add(DbHelperUtils.getFieldValue(object, idField.getName()));
        Object[] objects = params.toArray();
        return 1 == this.execute(sql.toString(), params.toArray(objects));
    }

    @Override
    public int execute(String sql, Object ... args) {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("params:" + Arrays.toString(args));
            log.debug("update sql:" + sql.toString());
        }
        int res = this.jdbcTemplate.update(sql, args);
        if (log.isDebugEnabled()) {
            log.debug("execute time:{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return res;
    }

    @Override
    public <T> PagingResult<T> list(StringBuffer sql, Class<T> clazz, Paging paging) {
        String[] sorts;
        PagingResult<T> result = new PagingResult<T>(paging);
        Object[] objects = paging.getParams().toArray();
        long rows = paging.getRows();
        if (0L != rows) {
            String totalSql = "select count(*) as size ";
            String tempSql = sql.toString().toLowerCase();
            int fromIndex = tempSql.indexOf("from");
            if (0 < fromIndex) {
                totalSql = totalSql + sql.substring(fromIndex, sql.length());
            }
            long total = this.queryForObject(totalSql, Long.class, objects);
            paging.setTotal(total);
            if (0L == total) {
                return result;
            }
        }
        long page = paging.getPage() - 1L;
        if (paging.isSort() && null != (sorts = paging.getSorts()) && 0 < sorts.length) {
            int sortIndex = paging.getSortIndex();
            if (sortIndex >= sorts.length) {
                sortIndex = sorts.length - 1;
            }
            sql.append(" order by ");
            sql.append('`');
            sql.append(sorts[paging.getSortIndex()]);
            sql.append('`');
            if (paging.isDesc()) {
                sql.append(" desc");
            } else {
                sql.append(" asc");
            }
        }
        if (0L != rows) {
            sql.append(" limit ");
            sql.append(page * rows);
            sql.append(",");
            sql.append(rows);
        }
        List<T> list = this.list(sql.toString(), clazz, objects);
        result.setList(list);
        return result;
    }

    @Override
    public <T> List<T> list(String sql, Class<T> clazz, Object ... args) {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("params:[{}]", args);
            log.debug("query sql:[{}]", (Object)sql);
        }
        List list = null;
        Object[] objects = args;
        list = null == objects || 0 == objects.length || objects[0] == null ? (DbHelperUtils.isSingleClass(clazz) ? this.jdbcTemplate.queryForList(sql, clazz) : this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(clazz))) : (DbHelperUtils.isSingleClass(clazz) ? this.jdbcTemplate.queryForList(sql, clazz, args) : this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(clazz), args));
        if (log.isDebugEnabled()) {
            log.debug("execute time:{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return list;
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> clazz, Object ... args) {
        List<T> list = this.list(sql, clazz, args);
        if (null != list && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> T queryById(Class<T> clazz, Object id) {
        StringBuffer sb = new StringBuffer("select ");
        sb.append(DbHelperUtils.getTableColumnAsFieldName(clazz));
        sb.append(" from ");
        sb.append(DbHelperUtils.getTableName(clazz));
        sb.append(" where `");
        sb.append(DbHelperUtils.getIdColumn(clazz));
        sb.append("` = ?");
        String sql = sb.toString();
        List<T> list = this.list(sql, clazz, id);
        if (null != list && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> boolean deleteById(Class<T> clazz, Object id) {
        StringBuffer sb = new StringBuffer("delete from ");
        sb.append(DbHelperUtils.getTableName(clazz));
        sb.append(" where `");
        sb.append(DbHelperUtils.getIdColumn(clazz));
        sb.append("` = ?");
        return 1 == this.execute(sb.toString(), id);
    }
}

